package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class WirelessIOSlotConfigMessage {
    public static final class_2960 ID = getResourceLocation("wireless_slot_config");
    private static final byte[] EMPTY = new byte[]{};

    public static class_2540 encode() {
        return encode(EMPTY);
    }

    public static class_2540 encode(byte[] configData) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10813(configData);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        byte[] configData = buf.method_10795();
        server.execute(() -> {
            class_1799 handItem = sender.method_6047();
            if (handItem.method_7909() == InitItems.WIRELESS_IO) {
                if (configData.length > 0) {
                    ItemWirelessIO.setSlotConfig(handItem, configData);
                }
                sender.method_17355((ItemWirelessIO) handItem.method_7909());
            }
        });
    }

}
