package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import java.util.List;

public class TileEntityMaidBeacon extends class_2586 implements IBlockEntityPersistentData {
    public static final class_2591<TileEntityMaidBeacon> TYPE = class_2591.class_2592.method_20528(TileEntityMaidBeacon::new, InitBlocks.MAID_BEACON).method_11034(null);
    public static final String POTION_INDEX_TAG = "PotionIndex";
    public static final String STORAGE_POWER_TAG = "StoragePower";
    public static final String OVERFLOW_DELETE_TAG = "OverflowDelete";
    private int potionIndex = -1;
    private float storagePower;
    private boolean overflowDelete = false;

    public TileEntityMaidBeacon(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, TileEntityMaidBeacon beacon) {
        if (beacon.field_11863 != null && !level.field_9236 && level.method_8510() % 80L == 0L) {
            if (beacon.potionIndex != -1 && beacon.storagePower >= beacon.getEffectCost()) {
                beacon.storagePower = beacon.storagePower - beacon.getEffectCost();
                beacon.updateBeaconEffect(level, BeaconEffect.getEffectByIndex(beacon.potionIndex).getEffect());
            }
            beacon.updateAbsorbPower(level);
        }
    }

    private void updateBeaconEffect(class_1937 world, class_1291 potion) {
        List<EntityMaid> list = world.method_8390(EntityMaid.class, new class_238(method_11016()).method_1009(8, 8, 8), class_1309::method_5805);
        for (EntityMaid maid : list) {
            maid.method_6092(new class_1293(potion, 100, 1, true, true));
        }
    }

    private void updateAbsorbPower(class_1937 world) {
        int range = MiscConfig.SHRINE_LAMP_MAX_RANGE.get();
        List<EntityPowerPoint> list = world.method_8390(EntityPowerPoint.class, new class_238(method_11016()).method_1009(range, range, range), class_1297::method_5805);
        for (EntityPowerPoint powerPoint : list) {
            float addNum = this.getStoragePower() + powerPoint.value / 100.0f;
            if (addNum <= this.getMaxStorage()) {
                this.setStoragePower(addNum);
                powerPoint.spawnExplosionParticle();
                powerPoint.method_31472();
            } else {
                if (overflowDelete) {
                    powerPoint.spawnExplosionParticle();
                    powerPoint.method_31472();
                }
            }
        }
    }

    @Override
    public void method_11007(class_2487 compound) {
        tlm$getPersistentData().method_10569(POTION_INDEX_TAG, potionIndex);
        tlm$getPersistentData().method_10548(STORAGE_POWER_TAG, storagePower);
        tlm$getPersistentData().method_10556(OVERFLOW_DELETE_TAG, overflowDelete);
        super.method_11007(compound);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        potionIndex = tlm$getPersistentData().method_10550(POTION_INDEX_TAG);
        storagePower = tlm$getPersistentData().method_10583(STORAGE_POWER_TAG);
        overflowDelete = tlm$getPersistentData().method_10577(OVERFLOW_DELETE_TAG);
    }

    public void loadData(class_2487 data) {
        potionIndex = data.method_10550(POTION_INDEX_TAG);
        storagePower = data.method_10583(STORAGE_POWER_TAG);
        overflowDelete = data.method_10577(OVERFLOW_DELETE_TAG);
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public int getPotionIndex() {
        return potionIndex;
    }

    public void setPotionIndex(int potionIndex) {
        this.potionIndex = potionIndex;
        this.refresh();
    }

    public float getStoragePower() {
        return storagePower;
    }

    public void setStoragePower(float storagePower) {
        this.storagePower = storagePower;
        this.refresh();
    }

    public boolean isOverflowDelete() {
        return overflowDelete;
    }

    public void setOverflowDelete(boolean overflowDelete) {
        this.overflowDelete = overflowDelete;
        this.refresh();
    }

    public float getEffectCost() {
        return (float) (MiscConfig.SHRINE_LAMP_EFFECT_COST.get() / 900);
    }

    public float getMaxStorage() {
        return MiscConfig.SHRINE_LAMP_MAX_STORAGE.get().floatValue();
    }

    public void refresh() {
        this.method_5431();
        if (field_11863 != null) {
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
        }
    }

    public enum BeaconEffect {
        // Effects
        SPEED(class_1294.field_5904),
        FIRE_RESISTANCE(class_1294.field_5918),
        STRENGTH(class_1294.field_5910),
        RESISTANCE(class_1294.field_5907),
        REGENERATION(class_1294.field_5924);

        private final class_1291 effect;

        BeaconEffect(class_1291 effect) {
            this.effect = effect;
        }

        public static BeaconEffect getEffectByIndex(int index) {
            return values()[class_3532.method_15340(0, index, values().length - 1)];
        }

        public class_1291 getEffect() {
            return effect;
        }
    }


}
