/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class LanguageLoader {
    private static final String COMMENT_SYMBOL = "#";
    private static final Pattern LANG_PATTERN = Pattern.compile("^assets/[\\w.]+/lang/(\\w{2}_\\w{2})\\.(?:lang|json)$");
    private static final Map<String, Map<String, String>> LANG_CACHE = Maps.newHashMap();
    private static final String REMOVE_KEY = "subtitle.touhou_little_maid.other.credit";
    private static final Gson GSON = new Gson();

    public static void clear() {
        LANG_CACHE.clear();
    }

    public static Map<String, String> getLanguages(String code) {
        return LANG_CACHE.get(code);
    }

    public static void loadDownloadInfoLanguages() {
        InfoGetManager.DOWNLOAD_INFO_LIST_ALL.forEach(info -> LanguageLoader.getLanguageMap(info.getLanguages()));
    }

    public static void readLanguageFile(ZipFile zipFile, String filePath) throws IOException {
        Matcher matcher = LANG_PATTERN.matcher(filePath);
        if (matcher.find()) {
            String languageCode = matcher.group(1);
            LANG_CACHE.putIfAbsent(languageCode, Maps.newHashMap());
            LanguageLoader.getLanguageMap(zipFile, LANG_CACHE.get(languageCode), filePath, filePath.endsWith(".json"));
        }
    }

    public static void readLanguageFile(Path rootPath, String namespace) throws IOException {
        File[] languageFiles = rootPath.resolve("assets").resolve(namespace).resolve("lang").toFile().listFiles((dir, name) -> true);
        if (languageFiles == null) {
            return;
        }
        for (File file : languageFiles) {
            String languageCode = FilenameUtils.getBaseName((String)file.getName());
            LANG_CACHE.putIfAbsent(languageCode, Maps.newHashMap());
            LanguageLoader.getLanguageMap(file, LANG_CACHE.get(languageCode));
        }
    }

    public static void getLanguageMap(HashMap<String, HashMap<String, String>> langMap) {
        for (String languageCode : langMap.keySet()) {
            LANG_CACHE.putIfAbsent(languageCode, Maps.newHashMap());
            Map<String, String> languages = LANG_CACHE.get(languageCode);
            languages.putAll((Map<String, String>)langMap.get(languageCode));
        }
    }

    private static void getLanguageMap(ZipFile zipFile, Map<String, String> langData, String filePath, boolean newFormat) throws IOException {
        ZipEntry entry = zipFile.getEntry(filePath);
        if (entry == null) {
            return;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            LanguageLoader.readLanguages(langData, stream, newFormat);
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn("Failed to load language file: {}", (Object)filePath);
            ioe.printStackTrace();
        }
    }

    private static void getLanguageMap(File languageFile, Map<String, String> langData) throws IOException {
        if (!languageFile.isFile()) {
            return;
        }
        try (InputStream stream = Files.newInputStream(languageFile.toPath(), new OpenOption[0]);){
            LanguageLoader.readLanguages(langData, stream, languageFile.getName().endsWith(".json"));
        }
    }

    private static void readLanguages(Map<String, String> langData, InputStream stream, boolean newFormat) throws IOException {
        if (newFormat) {
            Map result = (Map)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (TypeToken)new TypeToken<Map<String, String>>(){});
            langData.putAll(result);
        } else {
            List lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            for (String str : lines) {
                String key;
                String[] map;
                if (str.startsWith(COMMENT_SYMBOL) || (map = str.split("=", 2)).length != 2 || REMOVE_KEY.equals(key = map[0])) continue;
                langData.put(key, map[1]);
            }
        }
    }
}

