/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidFollowOwnerTask
extends class_4097<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        class_1309 owner = maid.method_35057();
        if (this.ownerStateConditions(owner, maid)) {
            if (maid.getSwimManager().isGoingToBreath()) {
                return !owner.method_5869();
            }
            return true;
        }
        return false;
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1309 owner = maid.method_35057();
        if (maid.getSwimManager().isGoingToBreath() && this.ownerStateConditions(owner, maid) && this.maidStateConditions(maid) && maid.teleportToOwner(owner)) {
            maid.getNavigationManager().resetNavigation();
            maid.getSwimManager().setGoingToBreath(false);
            maid.method_18868().method_18875(class_4140.field_18445);
            maid.method_18868().method_18875(InitEntities.TARGET_POS);
            this.method_18925(worldIn, (class_1309)maid, gameTimeIn);
            return;
        }
        int startDistance = (int)maid.method_18413() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner, maid) && this.maidStateConditions(maid) && !maid.method_24516((class_1297)owner, startDistance)) {
            if (!maid.method_24516((class_1297)owner, minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                class_4215.method_24557((class_1309)maid, (class_1297)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner, EntityMaid maid) {
        return owner != null && !owner.method_7325() && !owner.method_29504() && maid.field_6002 == owner.field_6002;
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, class_1309 owner) {
        return maid.method_18868().method_18904(class_4140.field_18445).map(target -> {
            class_4115 patt0$temp = target.method_19094();
            if (patt0$temp instanceof class_4102) {
                class_4102 tracker = (class_4102)patt0$temp;
                return tracker.method_35066().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

