/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4168;

public class ItemKappaCompass
extends class_1792 {
    public ItemKappaCompass() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static void addPoint(class_4168 activity, class_2338 pos, class_1799 compass) {
        Map activityPos = Objects.requireNonNullElse((Map)compass.method_57824(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS), new HashMap());
        activityPos.put(activity.method_19634(), pos);
        compass.method_57379(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS, (Object)activityPos);
    }

    public static void addDimension(class_2960 dimension, class_1799 compass) {
        compass.method_57379(InitDataComponent.KAPPA_COMPASS_DIMENSION, (Object)dimension.toString());
    }

    @Nullable
    public static class_2338 getPoint(class_4168 activity, class_1799 compass) {
        Map activityPos = (Map)compass.method_57824(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS);
        if (activityPos != null) {
            String name = activity.method_19634();
            if (activityPos.containsKey(name)) {
                return (class_2338)activityPos.get(name);
            }
            name = class_4168.field_18595.method_19634();
            if (activityPos.containsKey(name)) {
                return (class_2338)activityPos.get(name);
            }
            name = class_4168.field_18596.method_19634();
            if (activityPos.containsKey(name)) {
                return (class_2338)activityPos.get(name);
            }
        }
        return null;
    }

    @Nullable
    public static class_2960 getDimension(class_1799 compass) {
        String dim = (String)compass.method_57824(InitDataComponent.KAPPA_COMPASS_DIMENSION);
        if (dim != null) {
            return class_2960.method_60654((String)dim);
        }
        return null;
    }

    public static int getRecordCount(class_1799 compass) {
        Map activityPos = (Map)compass.method_57824(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS);
        if (activityPos != null) {
            return activityPos.size();
        }
        return 0;
    }

    public static boolean hasKappaCompassData(class_1799 compass) {
        return compass.method_57826(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS) && compass.method_57826(InitDataComponent.KAPPA_COMPASS_DIMENSION);
    }

    public class_1269 method_7847(class_1799 compass, class_1657 player, class_1309 livingEntity, class_1268 hand) {
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            if (!maid.field_6002.field_9236) {
                if (player.method_21751()) {
                    maid.getSchedulePos().clear(maid);
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.maid_clear"));
                    player.field_6002.method_8396(null, player.method_24515(), InitSounds.COMPASS_POINT, class_3419.field_15248, 0.8f, 1.5f);
                    return class_1269.field_5812;
                }
                class_2960 dimension = ItemKappaCompass.getDimension(compass);
                if (compass.method_57826(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS) || dimension != null) {
                    if (!maid.field_6002.method_27983().method_29177().equals((Object)dimension)) {
                        player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.maid_dimension_check"));
                        return class_1269.field_21466;
                    }
                    maid.getSchedulePos().setDimension(dimension);
                    class_2338 point = ItemKappaCompass.getPoint(class_4168.field_18596, compass);
                    if (point != null) {
                        maid.getSchedulePos().setWorkPos(point);
                    }
                    if ((point = ItemKappaCompass.getPoint(class_4168.field_18595, compass)) != null) {
                        maid.getSchedulePos().setIdlePos(point);
                    }
                    if ((point = ItemKappaCompass.getPoint(class_4168.field_18597, compass)) != null) {
                        maid.getSchedulePos().setSleepPos(point);
                    }
                    maid.getSchedulePos().setConfigured(true);
                    maid.getSchedulePos().restrictTo(maid);
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.maid_write"));
                    player.field_6002.method_8396(null, player.method_24515(), InitSounds.COMPASS_POINT, class_3419.field_15248, 0.8f, 1.5f);
                    return class_1269.field_5812;
                }
                player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.no_data"));
                return class_1269.field_21466;
            }
        }
        return super.method_7847(compass, player, livingEntity, hand);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1799 compass = context.method_8041();
        class_2338 clickedPos = context.method_8037();
        if (player == null) {
            return super.method_7884(context);
        }
        if (player.method_21751()) {
            compass.method_57381(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS);
            compass.method_57381(InitDataComponent.KAPPA_COMPASS_DIMENSION);
            this.sendMessage(player, (class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.clear"));
        } else {
            int recordCount = ItemKappaCompass.getRecordCount(compass);
            if (recordCount >= 3) {
                this.sendMessage(player, (class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.full"));
            } else if (recordCount == 2) {
                class_2338 idlePos = ItemKappaCompass.getPoint(class_4168.field_18595, compass);
                if (idlePos != null && idlePos.method_10262((class_2382)clickedPos) > 4096.0) {
                    this.sendMessage(player, (class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.far_away"));
                    return super.method_7884(context);
                }
                ItemKappaCompass.addPoint(class_4168.field_18597, clickedPos, compass);
                this.sendMessage(player, (class_2561)class_2561.method_43469((String)"message.touhou_little_maid.kappa_compass.sleep", (Object[])new Object[]{clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260()}));
            } else if (recordCount == 1) {
                class_2338 workPos = ItemKappaCompass.getPoint(class_4168.field_18596, compass);
                if (workPos != null && workPos.method_10262((class_2382)clickedPos) > 4096.0) {
                    this.sendMessage(player, (class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.far_away"));
                    return super.method_7884(context);
                }
                ItemKappaCompass.addPoint(class_4168.field_18595, clickedPos, compass);
                this.sendMessage(player, (class_2561)class_2561.method_43469((String)"message.touhou_little_maid.kappa_compass.idle", (Object[])new Object[]{clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260()}));
            } else {
                ItemKappaCompass.addPoint(class_4168.field_18596, clickedPos, compass);
                this.sendMessage(player, (class_2561)class_2561.method_43469((String)"message.touhou_little_maid.kappa_compass.work", (Object[])new Object[]{clickedPos.method_10263(), clickedPos.method_10264(), clickedPos.method_10260()}));
            }
            ItemKappaCompass.addDimension(player.field_6002.method_27983().method_29177(), compass);
        }
        player.field_6002.method_8396(null, player.method_24515(), InitSounds.COMPASS_POINT, class_3419.field_15248, 0.8f, 1.5f);
        return class_1269.field_5812;
    }

    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 worldIn, List<class_2561> components, class_1836 flagIn) {
        if (ItemKappaCompass.hasKappaCompassData(stack)) {
            class_2960 dimension = ItemKappaCompass.getDimension(stack);
            class_2338 workPos = ItemKappaCompass.getPoint(class_4168.field_18596, stack);
            class_2338 idlePos = ItemKappaCompass.getPoint(class_4168.field_18595, stack);
            class_2338 sleepPos = ItemKappaCompass.getPoint(class_4168.field_18597, stack);
            if (dimension != null) {
                components.add((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{dimension.toString()}).method_27692(class_124.field_1065));
            }
            if (workPos != null) {
                components.add((class_2561)class_2561.method_43469((String)"message.touhou_little_maid.kappa_compass.work", (Object[])new Object[]{workPos.method_10263(), workPos.method_10264(), workPos.method_10260()}).method_27692(class_124.field_1061));
            }
            if (idlePos != null) {
                components.add((class_2561)class_2561.method_43469((String)"message.touhou_little_maid.kappa_compass.idle", (Object[])new Object[]{idlePos.method_10263(), idlePos.method_10264(), idlePos.method_10260()}).method_27692(class_124.field_1060));
            }
            if (sleepPos != null) {
                components.add((class_2561)class_2561.method_43469((String)"message.touhou_little_maid.kappa_compass.sleep", (Object[])new Object[]{sleepPos.method_10263(), sleepPos.method_10264(), sleepPos.method_10260()}).method_27692(class_124.field_1078));
            }
            components.add((class_2561)class_2561.method_43473());
        }
        components.add((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.usage.set_pos"));
        components.add((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.usage.clear_pos"));
        components.add((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.usage.write_pos_to_maid"));
        components.add((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.kappa_compass.usage.clear_maid_pos"));
    }

    private void sendMessage(class_1657 player, class_2561 component) {
        if (!player.field_6002.field_9236) {
            player.method_43496(component);
        }
    }
}

