/*
 * Decompiled with CFR 0.152.
 */
package vesper.vcc.leaks.emi;

import dev.vesper.eveningstarlib.fabric.events.ClientRespawnEventCallback;
import java.lang.reflect.Method;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class EMI {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VCC/EMI");

    public static void initialize() {
        if (!FabricLoader.getInstance().isModLoaded("emi")) {
            return;
        }
        try {
            Class<?> emiHistoryClass = Class.forName("dev.emi.emi.runtime.EmiHistory");
            Method clearMethod = emiHistoryClass.getDeclaredMethod("clear", new Class[0]);
            ClientRespawnEventCallback.EVENT.register((gameMode, oldPlayer, newPlayer, connection) -> {
                try {
                    clearMethod.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.error("Error clearing EMI history on respawn", (Throwable)e);
                }
            });
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("EMI classes not found, skipping EMI fix");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize EMI fix", (Throwable)e);
        }
    }
}

