/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.shulkertooltip;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Mod(value="shulkertooltip")
public class ShulkerToolTip {
    public static final String MODID = "shulkertooltip";
    private static final KeyMapping enableView = new KeyMapping("key.enableView", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 342, "key.categories.shulkerTooltip");
    private static final KeyMapping openShulker = new KeyMapping("key.openShulker", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 78, "key.categories.shulkerTooltip");
    private static final KeyMapping toggleView = new KeyMapping("key.toggleView", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 86, "key.categories.shulkerTooltip");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"shulkertooltip", (String)"textures/gui/shulker_parts.png");

    public ShulkerToolTip(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::registerKeyMappings);
    }

    public void registerKeyMappings(RegisterKeyMappingsEvent e) {
        e.register(enableView);
        e.register(openShulker);
        e.register(toggleView);
    }

    private void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new EventManager());
    }

    private class EventManager
    extends GuiGraphics {
        private boolean box;
        private final List<String> ironChestWidths;
        private final String[] boxNames;
        private final int[] boxWidths;
        private int color;
        private boolean show;
        private boolean pressed;

        public EventManager() {
            super(Minecraft.getInstance(), (GuiRenderState)ObfuscationReflectionHelper.getPrivateValue(GameRenderer.class, (Object)Minecraft.getInstance().gameRenderer, (String)"guiRenderState"));
            this.box = false;
            this.ironChestWidths = Arrays.asList("diamond", "crystal", "obsidian");
            this.boxNames = new String[]{"shulker_box", "end_troll_box", "sack"};
            this.boxWidths = new int[]{8, 8, 8};
            this.color = -1;
            this.show = false;
            this.pressed = false;
        }

        private String shulkerStorageItem(ItemStack stack) {
            String name = stack.getItem().builtInRegistryHolder().key().location().toString();
            if (stack.getComponentsPatch() != DataComponentPatch.EMPTY) {
                for (String n : this.boxNames) {
                    if (!name.contains(n)) continue;
                    return name;
                }
            }
            return null;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void tooltipEvent(ItemTooltipEvent e) {
            if (this.shulkerStorageItem(e.getItemStack()) != null && (enableView.getKey().getValue() == -1 || enableView.getKey().getValue() != -1 && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)enableView.getKey().getValue()) == this.show && this.box)) {
                e.getToolTip().clear();
            }
        }

        @SubscribeEvent
        public void onClick(ScreenEvent.MouseButtonPressed.Pre e) {
            if (e.getScreen() instanceof FakeShulkerBox) {
                e.setCanceled(true);
            }
        }

        void boxPart(int atX, int atY, int fromX, int fromY, int toX, int toY) {
            this.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, atX, atY, fromX, fromY, toX, toY, toX, toY, 256, 256, this.color);
        }

        private void drawBar(int x, int y, int yStart, int boxWidth, int howTall) {
            this.boxPart(x, y, 0, yStart, 5, howTall);
            for (int i = 0; i < boxWidth + 1; ++i) {
                this.boxPart(x + 4 + i * 18, y, 4, yStart, 18, howTall);
            }
            this.boxPart(x + 4 + (boxWidth + 1) * 18, y, 22, yStart, 6, howTall);
        }

        private int getWidth(String id) {
            for (int i = 0; i < this.boxWidths.length; ++i) {
                if (!id.contains(this.boxNames[i])) continue;
                return this.boxWidths[i];
            }
            return 8;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SubscribeEvent
        public void event(ScreenEvent.Render.Post event) {
            ItemStack item;
            Minecraft mc = Minecraft.getInstance();
            long window = mc.getWindow().getWindow();
            LocalPlayer p = mc.player;
            if (event.getScreen() instanceof AbstractContainerScreen) {
                Slot itemSlot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse();
                if (itemSlot == null) {
                    return;
                }
                ItemStack itemStack2 = itemSlot.getItem();
                item = itemStack2;
            } else {
                if (!(event.getScreen() instanceof ChatScreen)) return;
                Style style = mc.gui.getChat().getClickedComponentStyleAt((double)event.getMouseX(), (double)event.getMouseY());
                if (style == null) return;
                if (style.getHoverEvent() == null) return;
                if (!(style.getHoverEvent() instanceof HoverEvent.ShowItem)) return;
                DyeColor[] itemstackinfo = (DyeColor[])style.getHoverEvent();
                if (itemstackinfo == null) {
                    return;
                }
                ItemStack itemStack3 = itemstackinfo.item();
                item = itemStack3;
            }
            if (item == null) {
                return;
            }
            String name = this.shulkerStorageItem(item);
            if (name != null) {
                String id;
                if (toggleView.getKey().getValue() != -1 && InputConstants.isKeyDown((long)window, (int)toggleView.getKey().getValue())) {
                    if (!this.pressed) {
                        this.show = !this.show;
                        this.pressed = true;
                    }
                } else {
                    this.pressed = false;
                }
                for (DyeColor c : DyeColor.values()) {
                    if (name.contains(c.toString().toLowerCase().replace("_", ""))) {
                        this.color = c.getTextureDiffuseColor();
                        break;
                    }
                    this.color = -1;
                }
                int boxWidth = this.ironChestWidths.contains((id = item.getItem().builtInRegistryHolder().key().location().toString().split(":")[1]).split("_")[0]) ? 11 : this.getWidth(id);
                ArrayList boxContents = new ArrayList();
                ((ItemContainerContents)item.getComponents().getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).stream().forEach(itemStack -> boxContents.add(itemStack));
                if (openShulker.getKey().getValue() != -1 && InputConstants.isKeyDown((long)window, (int)openShulker.getKey().getValue())) {
                    if (boxWidth != 8 || boxContents.size() > 54) {
                        p.displayClientMessage((Component)Component.literal((String)"\u00a7cERROR: Chest contents wouldn't fit in GUI."), false);
                    }
                    SimpleContainer inventory = new SimpleContainer(boxContents.size() < 27 ? 27 : boxContents.size());
                    for (int i = 0; i < boxContents.size(); ++i) {
                        inventory.setItem(i, (ItemStack)boxContents.get(i));
                    }
                    ChestMenu container = new ChestMenu(MenuType.GENERIC_9x3, p.containerMenu.containerId, p.getInventory(), (Container)inventory, 3);
                    mc.setScreen((Screen)new FakeShulkerBox(ShulkerToolTip.this, container, p.getInventory(), item.getDisplayName()));
                }
                if (enableView.getKey().getValue() != -1) {
                    if (enableView.getKey().getValue() == -1) return;
                    if (InputConstants.isKeyDown((long)window, (int)enableView.getKey().getValue()) != this.show) return;
                }
                int lengthOver = event.getMouseX() + 32 + boxWidth * 18 - mc.getWindow().getWidth();
                int toolTipHeight = 8 + (boxContents.size() - 1) / boxWidth * 18;
                int centerToolTip = toolTipHeight / 2;
                int lengthAbove = event.getMouseY() - 23 - centerToolTip;
                int lengthBelow = event.getMouseY() - 10 + toolTipHeight - mc.getWindow().getHeight() - centerToolTip;
                this.box = true;
                int drawX = event.getMouseX() + 4 - (lengthOver > 0 ? lengthOver : 0);
                int drawY = event.getMouseY() - 12 - centerToolTip - (lengthBelow > 0 ? lengthBelow : 0) - (lengthAbove < 0 ? lengthAbove : 0);
                this.drawBar(drawX, drawY - 11, 0, boxWidth, 16);
                int row = 0;
                int slot = 0;
                int x = 0;
                int y = drawY + 6 + 18 * row;
                this.boxPart(drawX, drawY + 5, 0, 4, 5, 18);
                this.boxPart(drawX + (boxWidth + 1) * 18 + 5, drawY + 5, 23, 5, 5, 18);
                for (int i = 0; i < boxContents.size(); ++i) {
                    if (slot > boxWidth) {
                        slot = 0;
                        this.boxPart(drawX, drawY + 5 + 18 * ++row, 0, 4, 5, 18);
                        this.boxPart(drawX + (boxWidth + 1) * 18 + 5, drawY + 5 + 18 * row, 23, 5, 5, 18);
                    }
                    x = drawX + 6 + 18 * slot;
                    y = drawY + 6 + 18 * row;
                    this.boxPart(x - 1, y - 1, 5, 17, 18, 18);
                    this.renderItem((ItemStack)boxContents.get(i), x, y);
                    this.renderItemDecorations(mc.font, (ItemStack)boxContents.get(i), x, y);
                    ++slot;
                }
                while (boxWidth + 1 > slot) {
                    x = drawX + 6 + 18 * slot;
                    this.boxPart(x - 1, y - 1, 5, 17, 18, 18);
                    ++slot;
                }
                this.drawBar(drawX, drawY + (row + 1) * 18 + 5, 35, boxWidth, 5);
                this.drawString(mc.font, item.getDisplayName().getString().replace("[", "").replace("]", ""), drawX + 6, drawY - 6, -1, true);
                return;
            } else {
                this.box = false;
            }
        }
    }

    private class FakeShulkerBox
    extends ContainerScreen {
        public FakeShulkerBox(ShulkerToolTip shulkerToolTip, ChestMenu container, Inventory inventory, Component name) {
            super(container, inventory, name);
        }
    }
}

