/*
 * Decompiled with CFR 0.152.
 */
package dev.bikerboys.clearviews.config;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.ValueFormatters;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClearviewsConfig {
    public static final ConfigClassHandler<ClearviewsConfig> CONFIG = ConfigClassHandler.createBuilder(ClearviewsConfig.class).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(YACLPlatform.getConfigDir().resolve("clearviews.json")).build()).build();
    @SerialEntry
    public boolean disableNausea = true;
    @SerialEntry
    public boolean disableBlindness = true;
    @SerialEntry
    public boolean disableDarkness = true;
    @SerialEntry
    public boolean disablePortalOverlay = true;
    @SerialEntry
    public boolean removeSpyglassBorder = true;
    @SerialEntry
    public boolean removePumpkinOverlay = true;
    @SerialEntry
    public boolean disableLocatorBar = true;
    @SerialEntry
    public boolean disableVignette = true;
    @SerialEntry
    public boolean disableBossBar = false;
    @SerialEntry
    public boolean disablePowderedSnowOverlay = true;
    @SerialEntry
    public boolean disableFireOverlay = false;
    @SerialEntry
    public float fireOpacity = 0.9f;
    @SerialEntry
    public boolean useWaterFog = true;
    @SerialEntry
    public float waterFogStart = 1000.0f;
    @SerialEntry
    public float waterFogEnd = 1000.0f;
    @SerialEntry
    public boolean useLavaFog = true;
    @SerialEntry
    public float lavaFogStart = 1000.0f;
    @SerialEntry
    public float lavaFogEnd = 1000.0f;
    @SerialEntry
    public boolean useBlindnessFog = true;
    @SerialEntry
    public float blindnessFogStart = 1000.0f;
    @SerialEntry
    public float blindnessFogEnd = 1000.0f;
    @SerialEntry
    public boolean useDarknessFog = true;
    @SerialEntry
    public float darknessFogStart = 1000.0f;
    @SerialEntry
    public float darknessFogEnd = 1000.0f;
    @SerialEntry
    public boolean useAtmosphericFog = true;
    @SerialEntry
    public float atmosphericFogStart = 1000.0f;
    @SerialEntry
    public float atmosphericFogEnd = 1000.0f;
    @SerialEntry
    public boolean useDimensionOrBossFog = true;
    @SerialEntry
    public float dimensionOrBossFogStart = 1000.0f;
    @SerialEntry
    public float dimensionOrBossFogEnd = 1000.0f;
    @SerialEntry
    public boolean usePowderSnowFog = true;
    @SerialEntry
    public float powderSnowFogStart = 1000.0f;
    @SerialEntry
    public float powderSnowFogEnd = 1000.0f;
    @SerialEntry
    public boolean useRenderDistanceFog = true;
    @SerialEntry
    public float renderDistanceFogStart = 1000.0f;
    @SerialEntry
    public float renderDistanceFogEnd = 1000.0f;

    public static Screen configScreen(Screen parent) {
        return YetAnotherConfigLib.create(CONFIG, (defaults, config, builder) -> builder.title((Component)Component.literal((String)"Clearviews")).category(ConfigCategory.createBuilder().name((Component)Component.literal((String)"Clearviews")).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Nausea")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the nausea effect")})).binding((Object)defaults.disableNausea, () -> config.disableNausea, newVal -> {
            config.disableNausea = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Blindness")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the blindness effect")})).binding((Object)defaults.disableBlindness, () -> config.disableBlindness, newVal -> {
            config.disableBlindness = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).group(OptionGroup.createBuilder().name((Component)Component.literal((String)"Fire")).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Fire Overlay")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the fire overlay")})).binding((Object)defaults.disableFireOverlay, () -> config.disableFireOverlay, newVal -> {
            config.disableFireOverlay = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Fire Opacity")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Sets the fire opacity")})).binding((Object)Float.valueOf(defaults.fireOpacity), () -> Float.valueOf(config.fireOpacity), newVal -> {
            config.fireOpacity = newVal.floatValue();
        }).controller(floatOption -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)floatOption).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.05f))).formatValue(ValueFormatters.percent((int)0))).build()).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Darkness")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the darkness effect")})).binding((Object)defaults.disableDarkness, () -> config.disableDarkness, newVal -> {
            config.disableDarkness = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Portal Overlay")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the portal overlay")})).binding((Object)defaults.disablePortalOverlay, () -> config.disablePortalOverlay, newVal -> {
            config.disablePortalOverlay = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Remove Spyglass Border")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Removes the spyglass border")})).binding((Object)defaults.removeSpyglassBorder, () -> config.removeSpyglassBorder, newVal -> {
            config.removeSpyglassBorder = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Remove Pumpkin Overlay")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Removes the pumpkin overlay")})).binding((Object)defaults.removePumpkinOverlay, () -> config.removePumpkinOverlay, newVal -> {
            config.removePumpkinOverlay = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Locator Bar")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the locator bar")})).binding((Object)defaults.disableLocatorBar, () -> config.disableLocatorBar, newVal -> {
            config.disableLocatorBar = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Vignette")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the vignette effect when you're close to the border")})).binding((Object)defaults.disableVignette, () -> config.disableVignette, newVal -> {
            config.disableVignette = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Bossbar")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the bossbar")})).binding((Object)defaults.disableBossBar, () -> config.disableBossBar, newVal -> {
            config.disableBossBar = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Disable Powdered Snow Overlay")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Disables the powdered snow overlay")})).binding((Object)defaults.disablePowderedSnowOverlay, () -> config.disablePowderedSnowOverlay, newVal -> {
            config.disablePowderedSnowOverlay = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).group(ClearviewsConfig.makeFogGroup("Water Fog", defaults.useWaterFog, () -> config.useWaterFog, v -> {
            config.useWaterFog = v;
        }, defaults.waterFogStart, () -> Float.valueOf(config.waterFogStart), v -> {
            config.waterFogStart = v.floatValue();
        }, defaults.waterFogEnd, () -> Float.valueOf(config.waterFogEnd), v -> {
            config.waterFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Lava Fog", defaults.useLavaFog, () -> config.useLavaFog, v -> {
            config.useLavaFog = v;
        }, defaults.lavaFogStart, () -> Float.valueOf(config.lavaFogStart), v -> {
            config.lavaFogStart = v.floatValue();
        }, defaults.lavaFogEnd, () -> Float.valueOf(config.lavaFogEnd), v -> {
            config.lavaFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Blindness Fog", defaults.useBlindnessFog, () -> config.useBlindnessFog, v -> {
            config.useBlindnessFog = v;
        }, defaults.blindnessFogStart, () -> Float.valueOf(config.blindnessFogStart), v -> {
            config.blindnessFogStart = v.floatValue();
        }, defaults.blindnessFogEnd, () -> Float.valueOf(config.blindnessFogEnd), v -> {
            config.blindnessFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Darkness Fog", defaults.useDarknessFog, () -> config.useDarknessFog, v -> {
            config.useDarknessFog = v;
        }, defaults.darknessFogStart, () -> Float.valueOf(config.darknessFogStart), v -> {
            config.darknessFogStart = v.floatValue();
        }, defaults.darknessFogEnd, () -> Float.valueOf(config.darknessFogEnd), v -> {
            config.darknessFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Atmospheric Fog", defaults.useAtmosphericFog, () -> config.useAtmosphericFog, v -> {
            config.useAtmosphericFog = v;
        }, defaults.atmosphericFogStart, () -> Float.valueOf(config.atmosphericFogStart), v -> {
            config.atmosphericFogStart = v.floatValue();
        }, defaults.atmosphericFogEnd, () -> Float.valueOf(config.atmosphericFogEnd), v -> {
            config.atmosphericFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Dimension/Boss Fog", defaults.useDimensionOrBossFog, () -> config.useDimensionOrBossFog, v -> {
            config.useDimensionOrBossFog = v;
        }, defaults.dimensionOrBossFogStart, () -> Float.valueOf(config.dimensionOrBossFogStart), v -> {
            config.dimensionOrBossFogStart = v.floatValue();
        }, defaults.dimensionOrBossFogEnd, () -> Float.valueOf(config.dimensionOrBossFogEnd), v -> {
            config.dimensionOrBossFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Powder Snow Fog", defaults.usePowderSnowFog, () -> config.usePowderSnowFog, v -> {
            config.usePowderSnowFog = v;
        }, defaults.powderSnowFogStart, () -> Float.valueOf(config.powderSnowFogStart), v -> {
            config.powderSnowFogStart = v.floatValue();
        }, defaults.powderSnowFogEnd, () -> Float.valueOf(config.powderSnowFogEnd), v -> {
            config.powderSnowFogEnd = v.floatValue();
        })).group(ClearviewsConfig.makeFogGroup("Render Distance Fog", defaults.useRenderDistanceFog, () -> config.useRenderDistanceFog, v -> {
            config.useRenderDistanceFog = v;
        }, defaults.renderDistanceFogStart, () -> Float.valueOf(config.renderDistanceFogStart), v -> {
            config.renderDistanceFogStart = v.floatValue();
        }, defaults.renderDistanceFogEnd, () -> Float.valueOf(config.renderDistanceFogEnd), v -> {
            config.renderDistanceFogEnd = v.floatValue();
        })).build())).generateScreen(parent);
    }

    private static OptionGroup makeFogGroup(String name, boolean defaultToggle, Supplier<Boolean> getToggle, Consumer<Boolean> setToggle, float defaultStart, Supplier<Float> getStart, Consumer<Float> setStart, float defaultEnd, Supplier<Float> getEnd, Consumer<Float> setEnd) {
        return OptionGroup.createBuilder().name((Component)Component.literal((String)name)).option(Option.createBuilder().name((Component)Component.literal((String)("Enable " + name))).binding((Object)defaultToggle, getToggle, setToggle).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)(name + " Start"))).binding((Object)Float.valueOf(defaultStart), getStart, setStart).controller(FloatFieldControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)(name + " End"))).binding((Object)Float.valueOf(defaultEnd), getEnd, setEnd).controller(FloatFieldControllerBuilder::create).build()).build();
    }
}

