/*
 * Decompiled with CFR 0.152.
 */
package com.bikerboys.clearviews;

import com.bikerboys.clearviews.Config;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClearviewConfigScreen
extends Screen {
    private final Screen parent;

    protected ClearviewConfigScreen(Component component, Screen parent, Minecraft minecraft) {
        super(component);
        this.minecraft = minecraft;
        this.parent = parent;
    }

    protected void init() {
        int y = 40;
        int spacing = 25;
        this.addToggle(0, y, "Darkness Effect", Config.DarknessRemover, val -> {
            Config.DarknessRemover = val;
        });
        this.addToggle(1, y += spacing, "Blindness Effect", Config.BlindnessRemover, val -> {
            Config.BlindnessRemover = val;
        });
        this.addToggle(2, y += spacing, "Nausea Effect", Config.NauseaRemover, val -> {
            Config.NauseaRemover = val;
        });
        this.addToggle(3, y += spacing, "Portal Overlay", Config.PortalOverlay, val -> {
            Config.PortalOverlay = val;
        });
        this.addToggle(4, y += spacing, "Spyglass Overlay", Config.SpyglassOverlay, val -> {
            Config.SpyglassOverlay = val;
        });
        this.addToggle(5, y += spacing, "Custom Fog", Config.CustomFog, val -> {
            Config.CustomFog = val;
        });
        this.addRenderableOnly((Renderable)new StringWidget(this.width / 2 - 100, y += spacing, 200, 20, (Component)Component.literal((String)"Fog Start Distance (m)"), this.font));
        EditBox fogStartBox = new EditBox(this.font, this.width / 2 - 100, y += 15, 200, 20, (Component)Component.literal((String)"Fog Start"));
        fogStartBox.setValue(String.valueOf(Config.FogStart));
        fogStartBox.setEditable(true);
        fogStartBox.setResponder(value -> {
            try {
                Config.FogStart = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addRenderableWidget((GuiEventListener)fogStartBox);
        this.addRenderableOnly((Renderable)new StringWidget(this.width / 2 - 100, y += spacing, 200, 20, (Component)Component.literal((String)"Fog End Distance (m)"), this.font));
        EditBox fogEndBox = new EditBox(this.font, this.width / 2 - 100, y += 15, 200, 20, (Component)Component.literal((String)"Fog End"));
        fogEndBox.setValue(String.valueOf(Config.FogEnd));
        fogEndBox.setEditable(true);
        fogEndBox.setResponder(value -> {
            try {
                Config.FogEnd = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addRenderableWidget((GuiEventListener)fogEndBox);
        Button done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 - 100, y += spacing).size(200, 20).build());
    }

    private void addToggle(int index, int y, String label, boolean initialValue, Consumer<Boolean> setter) {
        boolean[] currentValue = new boolean[]{initialValue};
        Button toggle = Button.builder((Component)Component.literal((String)(label + ": " + (currentValue[0] ? "Enabled" : "Disabled"))), btn -> {
            currentValue[0] = !currentValue[0];
            setter.accept(currentValue[0]);
            btn.setMessage((Component)Component.literal((String)(label + ": " + (currentValue[0] ? "Enabled" : "Disabled"))));
        }).pos(this.width / 2 - 100, y).size(200, 20).build();
        this.addRenderableWidget((GuiEventListener)toggle);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

