/*
 * Decompiled with CFR 0.152.
 */
package dev.bikerboys.clearviews.mixin.fog;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.bikerboys.clearviews.config.ClearviewsConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import net.neoforged.neoforge.client.ClientHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Shadow
    @Final
    private static List<FogRenderer.MobEffectFogFunction> MOB_EFFECT_FOG;

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void alwaysSpectatorFog(Camera camera, FogRenderer.FogMode fogMode, float farPlaneDistance, boolean shouldCreateFog, float partialTick, CallbackInfo cir) {
        FogShape fogShape = FogShape.CYLINDER;
        FogType fogType = camera.getFluidInCamera();
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).useRenderDistanceFog && fogType.equals((Object)FogType.NONE) && (fogMode.equals((Object)FogRenderer.FogMode.FOG_SKY) || fogMode.equals((Object)FogRenderer.FogMode.FOG_TERRAIN)) && !Minecraft.getInstance().player.hasEffect(MobEffects.DARKNESS) && !Minecraft.getInstance().player.hasEffect(MobEffects.BLINDNESS)) {
            RenderSystem.setShaderFogStart((float)FogRendererMixin.getInstance().renderDistanceFogStart);
            RenderSystem.setShaderFogEnd((float)FogRendererMixin.getInstance().renderDistanceFogEnd);
            RenderSystem.setShaderFogShape((FogShape)fogShape);
            ClientHooks.onFogRender((FogRenderer.FogMode)fogMode, (FogType)fogType, (Camera)camera, (float)partialTick, (float)farPlaneDistance, (float)FogRendererMixin.getInstance().renderDistanceFogStart, (float)FogRendererMixin.getInstance().renderDistanceFogEnd, (FogShape)fogShape);
            cir.cancel();
        }
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).usePowderSnowFog && fogType.equals((Object)FogType.POWDER_SNOW)) {
            RenderSystem.setShaderFogStart((float)FogRendererMixin.getInstance().powderSnowFogStart);
            RenderSystem.setShaderFogEnd((float)FogRendererMixin.getInstance().powderSnowFogEnd);
            RenderSystem.setShaderFogShape((FogShape)fogShape);
            ClientHooks.onFogRender((FogRenderer.FogMode)fogMode, (FogType)fogType, (Camera)camera, (float)partialTick, (float)farPlaneDistance, (float)FogRendererMixin.getInstance().powderSnowFogStart, (float)FogRendererMixin.getInstance().powderSnowFogEnd, (FogShape)fogShape);
            cir.cancel();
        }
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).useLavaFog && fogType.equals((Object)FogType.LAVA)) {
            RenderSystem.setShaderFogStart((float)FogRendererMixin.getInstance().lavaFogStart);
            RenderSystem.setShaderFogEnd((float)FogRendererMixin.getInstance().lavaFogEnd);
            RenderSystem.setShaderFogShape((FogShape)fogShape);
            ClientHooks.onFogRender((FogRenderer.FogMode)fogMode, (FogType)fogType, (Camera)camera, (float)partialTick, (float)farPlaneDistance, (float)FogRendererMixin.getInstance().lavaFogStart, (float)FogRendererMixin.getInstance().lavaFogEnd, (FogShape)fogShape);
            cir.cancel();
        }
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).useWaterFog && fogType.equals((Object)FogType.WATER)) {
            RenderSystem.setShaderFogStart((float)FogRendererMixin.getInstance().waterFogStart);
            RenderSystem.setShaderFogEnd((float)FogRendererMixin.getInstance().waterFogEnd);
            RenderSystem.setShaderFogShape((FogShape)fogShape);
            ClientHooks.onFogRender((FogRenderer.FogMode)fogMode, (FogType)fogType, (Camera)camera, (float)partialTick, (float)farPlaneDistance, (float)FogRendererMixin.getInstance().waterFogStart, (float)FogRendererMixin.getInstance().waterFogEnd, (FogShape)fogShape);
            cir.cancel();
        }
    }

    private static ClearviewsConfig getInstance() {
        return (ClearviewsConfig)ClearviewsConfig.CONFIG.instance();
    }

    @WrapOperation(method={"getPriorityFogFunction(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/FogRenderer$MobEffectFogFunction;"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;")})
    private static Stream<FogRenderer.MobEffectFogFunction> clearviews$filterMobEffects(Stream<FogRenderer.MobEffectFogFunction> original, Predicate<FogRenderer.MobEffectFogFunction> predicate, Operation<Stream<FogRenderer.MobEffectFogFunction>> operation, Entity entity, float partialTick) {
        Stream base = (Stream)operation.call(new Object[]{original, predicate});
        ClearviewsConfig cfg = (ClearviewsConfig)ClearviewsConfig.CONFIG.instance();
        return base.filter(fog -> {
            if (fog instanceof FogRenderer.DarknessFogFunction && cfg.disableDarkness) {
                return false;
            }
            return !(fog instanceof FogRenderer.BlindnessFogFunction) || !cfg.disableBlindness;
        });
    }
}

