/*
 * Decompiled with CFR 0.152.
 */
package dev.bikerboys.clearviews.mixin.fog;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.shaders.FogShape;
import dev.bikerboys.clearviews.config.ClearviewsConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Shadow
    @Final
    private static List<FogRenderer.MobEffectFogFunction> MOB_EFFECT_FOG;

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;Lorg/joml/Vector4f;FZF)Lnet/minecraft/client/renderer/FogParameters;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void alwaysSpectatorFog(Camera camera, FogRenderer.FogMode fogMode, Vector4f color, float renderDistance, boolean isFoggy, float partialTick, CallbackInfoReturnable<FogParameters> cir) {
        FogShape fogShape = FogShape.CYLINDER;
        FogType fogType = camera.getFluidInCamera();
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).useRenderDistanceFog && fogType.equals((Object)FogType.NONE) && (fogMode.equals((Object)FogRenderer.FogMode.FOG_SKY) || fogMode.equals((Object)FogRenderer.FogMode.FOG_TERRAIN)) && !Minecraft.getInstance().player.hasEffect(MobEffects.DARKNESS) && !Minecraft.getInstance().player.hasEffect(MobEffects.BLINDNESS)) {
            cir.setReturnValue((Object)new FogParameters(FogRendererMixin.getInstance().renderDistanceFogStart, FogRendererMixin.getInstance().renderDistanceFogEnd, fogShape, color.x, color.y, color.z, color.w));
        }
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).usePowderSnowFog && fogType.equals((Object)FogType.POWDER_SNOW)) {
            cir.setReturnValue((Object)new FogParameters(FogRendererMixin.getInstance().powderSnowFogStart, FogRendererMixin.getInstance().powderSnowFogEnd, fogShape, color.x, color.y, color.z, color.w));
        }
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).useLavaFog && fogType.equals((Object)FogType.LAVA)) {
            cir.setReturnValue((Object)new FogParameters(FogRendererMixin.getInstance().lavaFogStart, FogRendererMixin.getInstance().lavaFogEnd, fogShape, color.x, color.y, color.z, color.w));
        }
        if (((ClearviewsConfig)ClearviewsConfig.CONFIG.instance()).useWaterFog && fogType.equals((Object)FogType.WATER)) {
            cir.setReturnValue((Object)new FogParameters(FogRendererMixin.getInstance().waterFogStart, FogRendererMixin.getInstance().waterFogEnd, fogShape, color.x, color.y, color.z, color.w));
        }
    }

    private static ClearviewsConfig getInstance() {
        return (ClearviewsConfig)ClearviewsConfig.CONFIG.instance();
    }

    @WrapOperation(method={"getPriorityFogFunction(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/FogRenderer$MobEffectFogFunction;"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;")})
    private static Stream<FogRenderer.MobEffectFogFunction> clearviews$filterMobEffects(Stream<FogRenderer.MobEffectFogFunction> original, Predicate<FogRenderer.MobEffectFogFunction> predicate, Operation<Stream<FogRenderer.MobEffectFogFunction>> operation, Entity entity, float partialTick) {
        Stream base = (Stream)operation.call(new Object[]{original, predicate});
        ClearviewsConfig cfg = (ClearviewsConfig)ClearviewsConfig.CONFIG.instance();
        return base.filter(fog -> {
            if (fog instanceof FogRenderer.DarknessFogFunction && cfg.disableDarkness) {
                return false;
            }
            return !(fog instanceof FogRenderer.BlindnessFogFunction) || !cfg.disableBlindness;
        });
    }
}

