/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.entity.ai.goal;

import it.mitl.minecraftbecomeplayers.entity.custom.SynthEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FollowOwnerGoal
extends Goal {
    private final SynthEntity mob;
    private Player owner;
    private final double speedModifier;
    private final float stopDistance;
    private final float startDistance;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public FollowOwnerGoal(SynthEntity mob, double speedModifier, float startDistance, float stopDistance) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.mob.isFollowing() || this.mob.isStaying() || !this.mob.isActivationComplete()) {
            return false;
        }
        Player player = this.getOwner();
        if (player == null) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        if ((double)this.mob.m_20270_((Entity)player) < (double)this.startDistance) {
            return false;
        }
        this.owner = player;
        return true;
    }

    public boolean m_8045_() {
        if (!this.mob.isFollowing() || this.mob.isStaying()) {
            return false;
        }
        if (this.owner == null || this.owner.m_5833_()) {
            return false;
        }
        return (double)this.mob.m_20270_((Entity)this.owner) > (double)this.stopDistance;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.mob.m_21573_().m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.mob.m_21573_().m_5624_((Entity)this.owner, this.speedModifier);
        }
    }

    @Nullable
    private Player getOwner() {
        if (this.mob.m_9236_().f_46443_) {
            return null;
        }
        return this.mob.m_9236_().m_46003_(this.mob.getOwnerUUID());
    }
}

