/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.entity.custom;

import it.mitl.minecraftbecomeplayers.entity.ai.goal.FollowOwnerGoal;
import it.mitl.minecraftbecomeplayers.item.ModItems;
import it.mitl.minecraftbecomeplayers.menu.SynthInventoryMenu;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SynthEntity
extends PathfinderMob {
    private static final EntityDataAccessor<String> SYNTH_SKIN = SynchedEntityData.m_135353_(SynthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SYNTH_SKIN_ENABLED = SynchedEntityData.m_135353_(SynthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> SYNTH_NAME = SynchedEntityData.m_135353_(SynthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ACTIVATION_STAGE = SynchedEntityData.m_135353_(SynthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(SynthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID ownerUUID;
    private WaterAvoidingRandomStrollGoal strollGoal;
    private RandomLookAroundGoal randomLookGoal;
    private boolean activationGoalsAdded = false;
    private LookAtPlayerGoal lookAtPlayerGoal;
    private boolean lookGoalAdded = false;
    private boolean staying = false;
    private boolean following = false;
    private FollowOwnerGoal followOwnerGoal;
    private MeleeAttackGoal meleeAttackGoal;
    private final ItemStackHandler inventory = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            if (!SynthEntity.this.m_9236_().f_46443_ && SynthEntity.this.m_6084_() && SynthEntity.this.m_5448_() != null) {
                SynthEntity.this.equipFirstAvailableWeapon();
            }
        }
    };
    private final LazyOptional<IItemHandler> inventoryOptional = LazyOptional.of(() -> this.inventory);
    private int equippedInventorySlot = -1;
    private Set<ChunkPos> forcedChunks = new HashSet<ChunkPos>();
    private ResourceKey<Level> forcedDimension = null;

    public SynthEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SYNTH_SKIN, (Object)"default.png");
        this.f_19804_.m_135372_(SYNTH_SKIN_ENABLED, (Object)true);
        this.f_19804_.m_135372_(SYNTH_NAME, (Object)"");
        this.f_19804_.m_135372_(ACTIVATION_STAGE, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.strollGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0);
        this.randomLookGoal = new RandomLookAroundGoal((Mob)this);
        this.lookAtPlayerGoal = new LookAtPlayerGoal((Mob)this, Player.class, 8.0f);
        this.followOwnerGoal = new FollowOwnerGoal(this, 1.15, 4.0f, 2.0f);
        this.meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, true);
        this.updateActivationDependentGoals();
    }

    private void updateActivationDependentGoals() {
        boolean shouldHaveMelee;
        boolean shouldFollow;
        boolean shouldHaveActivationGoals;
        boolean shouldLook;
        if (this.m_9236_().f_46443_) {
            return;
        }
        int stage = this.getActivationStage();
        boolean bl = shouldLook = stage >= 1;
        if (shouldLook) {
            if (!this.lookGoalAdded) {
                this.f_21345_.m_25352_(5, (Goal)this.lookAtPlayerGoal);
                this.lookGoalAdded = true;
            }
        } else if (this.lookGoalAdded) {
            this.f_21345_.m_25363_((Goal)this.lookAtPlayerGoal);
            this.lookGoalAdded = false;
        }
        boolean bl2 = shouldHaveActivationGoals = this.isActivationComplete() && !this.staying && !this.following;
        if (shouldHaveActivationGoals) {
            if (!this.activationGoalsAdded) {
                this.f_21345_.m_25352_(3, (Goal)this.strollGoal);
                this.f_21345_.m_25352_(4, (Goal)this.randomLookGoal);
                this.activationGoalsAdded = true;
            }
        } else if (this.activationGoalsAdded) {
            this.f_21345_.m_25363_((Goal)this.strollGoal);
            this.f_21345_.m_25363_((Goal)this.randomLookGoal);
            this.activationGoalsAdded = false;
        }
        boolean bl3 = shouldFollow = this.isActivationComplete() && this.following && !this.staying;
        if (shouldFollow) {
            if (!this.f_21345_.m_148105_().stream().anyMatch(w -> w.m_26015_() == this.followOwnerGoal)) {
                this.f_21345_.m_25352_(2, (Goal)this.followOwnerGoal);
            }
        } else {
            this.f_21345_.m_25363_((Goal)this.followOwnerGoal);
        }
        boolean bl4 = shouldHaveMelee = this.isActivationComplete() && !this.staying;
        if (shouldHaveMelee) {
            if (!this.f_21345_.m_148105_().stream().anyMatch(w -> w.m_26015_() == this.meleeAttackGoal)) {
                this.f_21345_.m_25352_(1, (Goal)this.meleeAttackGoal);
            }
        } else {
            this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
        }
        if (this.staying) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand pHand) {
        if (pHand == InteractionHand.MAIN_HAND) {
            if (this.m_9236_().f_46443_) {
                return super.m_6071_(player, pHand);
            }
            if (player.m_21120_(pHand).m_41720_() == ModItems.BLUE_BLOOD.get()) {
                player.m_21120_(pHand).m_41774_(1);
                this.m_5634_(4.0f);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.5f, 1.0f);
                if (this.isActivationComplete()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a79[\u00a7b" + (this.getSynthName().isEmpty() ? "Synth" : this.getSynthName()) + "\u00a79]\u00a77 Thank you, I feel better now.")));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Thank you, I feel better now."));
                }
                return InteractionResult.CONSUME;
            }
            if (player.m_6144_() && this.isOwner(player)) {
                if (player.m_21205_().m_150930_((Item)ModItems.TRACKER.get()) || player.m_21206_().m_150930_((Item)ModItems.TRACKER.get())) {
                    return InteractionResult.PASS;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, pl) -> new SynthInventoryMenu(id, inv, this), (Component)Component.m_237113_((String)this.getSynthName()));
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, buf -> buf.m_130130_(this.m_19879_()));
                return InteractionResult.CONSUME;
            }
            if (player.m_21120_(pHand).m_41619_() && !this.isActivationComplete()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Greetings, " + player.m_7755_().getString() + "!")));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Congratulations on the purchase of your new synthetic appliance! To begin attunement, please say 'Activate Synth'."));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, pHand);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.62f;
    }

    public String getSynthSkin() {
        return (String)this.f_19804_.m_135370_(SYNTH_SKIN);
    }

    public void setSynthSkin(String skin) {
        this.f_19804_.m_135381_(SYNTH_SKIN, (Object)skin);
    }

    public Boolean getSynthSkinEnabled() {
        return (Boolean)this.f_19804_.m_135370_(SYNTH_SKIN_ENABLED);
    }

    public void setSynthSkinEnabled(boolean enabled) {
        this.f_19804_.m_135381_(SYNTH_SKIN_ENABLED, (Object)enabled);
    }

    public String getSynthName() {
        return (String)this.f_19804_.m_135370_(SYNTH_NAME);
    }

    public void setSynthName(String name) {
        this.f_19804_.m_135381_(SYNTH_NAME, (Object)name);
        if (!name.isEmpty()) {
            this.m_6593_((Component)Component.m_237113_((String)name));
            this.m_20340_(true);
        }
    }

    public int getActivationStage() {
        return (Integer)this.f_19804_.m_135370_(ACTIVATION_STAGE);
    }

    public void setActivationStage(int stage) {
        Level level;
        this.f_19804_.m_135381_(ACTIVATION_STAGE, (Object)stage);
        this.updateActivationDependentGoals();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isActivationComplete()) {
                this.unforceAll(serverLevel);
            }
        }
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public boolean isOwner(Player player) {
        return player.m_20148_().equals(this.ownerUUID);
    }

    public boolean isActivationComplete() {
        int lastActivationStage = 3;
        return this.getActivationStage() >= lastActivationStage;
    }

    public boolean isStaying() {
        return this.staying;
    }

    public void setStaying(boolean staying) {
        this.staying = staying;
        if (!this.m_9236_().f_46443_) {
            if (staying) {
                this.m_21573_().m_26573_();
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            }
            this.updateActivationDependentGoals();
        }
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setFollowing(boolean following) {
        this.following = following;
        if (!this.m_9236_().f_46443_) {
            if (!following) {
                this.m_21573_().m_26573_();
            }
            this.updateActivationDependentGoals();
        }
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        super.m_6710_(entity);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (entity != null) {
            this.equipFirstAvailableWeapon();
        } else {
            this.stowEquippedItem();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryOptional.cast();
        }
        return super.getCapability(capability, direction);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryOptional.invalidate();
    }

    public IItemHandler getItemHandler() {
        return this.inventory;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("SynthSkin", this.getSynthSkin());
        tag.m_128379_("SynthSkinEnabled", this.getSynthSkinEnabled().booleanValue());
        tag.m_128359_("SynthName", this.getSynthName());
        tag.m_128405_("ActivationStage", this.getActivationStage());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Staying", this.staying);
        tag.m_128379_("Following", this.following);
        tag.m_128405_("EquippedInventorySlot", this.equippedInventorySlot);
        if (this.ownerUUID != null) {
            tag.m_128362_("OwnerUuid", this.ownerUUID);
        }
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("SynthSkin")) {
            this.setSynthSkin(tag.m_128461_("SynthSkin"));
        }
        if (tag.m_128441_("SynthSkinEnabled")) {
            this.setSynthSkinEnabled(tag.m_128471_("SynthSkinEnabled"));
        }
        if (tag.m_128441_("SynthName")) {
            this.setSynthName(tag.m_128461_("SynthName"));
        }
        if (tag.m_128441_("ActivationStage")) {
            this.setActivationStage(tag.m_128451_("ActivationStage"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        this.ownerUUID = tag.m_128403_("OwnerUuid") ? tag.m_128342_("OwnerUuid") : null;
        if (tag.m_128441_("Staying")) {
            this.setStaying(tag.m_128471_("Staying"));
        }
        if (tag.m_128441_("Following")) {
            this.setFollowing(tag.m_128471_("Following"));
        }
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("EquippedInventorySlot")) {
            this.equippedInventorySlot = tag.m_128451_("EquippedInventorySlot");
        }
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean recentlyHit) {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        super.m_7472_(source, lootingMultiplier, recentlyHit);
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), stack.m_41777_());
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.unforceAll(serverLevel);
        }
        super.m_142687_(reason);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.updateForcedChunks();
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            this.pickupNearbyItems();
            LivingEntity currentTarget = this.m_5448_();
            if (currentTarget == null || !currentTarget.m_6084_() || currentTarget.m_213877_() || currentTarget.m_21224_()) {
                if (currentTarget != null) {
                    this.m_6710_(null);
                } else if (!this.m_21205_().m_41619_()) {
                    this.stowEquippedItem();
                }
            } else {
                this.ensureEquippedItemValid();
            }
        }
    }

    private void updateForcedChunks() {
        boolean sameArea;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean shouldForce = this.isActivationComplete() && !this.m_213877_();
        ChunkPos center = new ChunkPos(this.m_20183_());
        ResourceKey currentDim = serverLevel.m_46472_();
        if (!shouldForce) {
            this.unforceAll(serverLevel);
            return;
        }
        Set<ChunkPos> desired = SynthEntity.computeArea(center, 1);
        boolean dimChanged = this.forcedDimension == null || !this.forcedDimension.equals((Object)currentDim);
        boolean bl = sameArea = !dimChanged && this.forcedChunks.equals(desired);
        if (sameArea) {
            return;
        }
        this.unforceAll(serverLevel);
        for (ChunkPos cp : desired) {
            serverLevel.m_8602_(cp.f_45578_, cp.f_45579_, true);
        }
        this.forcedChunks = desired;
        this.forcedDimension = currentDim;
    }

    private static Set<ChunkPos> computeArea(ChunkPos center, int radius) {
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                set.add(new ChunkPos(center.f_45578_ + dx, center.f_45579_ + dz));
            }
        }
        return set;
    }

    private void unforceAll(ServerLevel level) {
        if (this.forcedChunks.isEmpty()) {
            return;
        }
        for (ChunkPos cp : this.forcedChunks) {
            level.m_8602_(cp.f_45578_, cp.f_45579_, false);
        }
        this.forcedChunks.clear();
        this.forcedDimension = null;
    }

    private void pickupNearbyItems() {
        if (this.isInventoryFull()) {
            return;
        }
        if (!this.isActivationComplete()) {
            return;
        }
        AABB box = this.m_20191_().m_82400_(1.5);
        List items = this.m_9236_().m_6443_(ItemEntity.class, box, e -> e.m_6084_() && !e.m_32063_());
        for (ItemEntity itemEntity : items) {
            ItemStack remaining;
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)(remaining = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack.m_41777_(), (boolean)false))) && remaining.m_41613_() == stack.m_41613_()) continue;
            if (remaining.m_41619_()) {
                itemEntity.m_146870_();
            } else {
                itemEntity.m_32045_(remaining);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.7f + 1.0f);
            if (!this.isInventoryFull()) continue;
            break;
        }
    }

    private boolean isInventoryFull() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41613_() < Math.min(this.inventory.getSlotLimit(i), this.inventory.getStackInSlot(i).m_41741_())) {
                return false;
            }
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void equipFirstAvailableWeapon() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack candidate = this.inventory.getStackInSlot(i);
            if (candidate.m_41619_() || !this.isUsableWeapon(candidate)) continue;
            this.m_8061_(EquipmentSlot.MAINHAND, candidate);
            this.equippedInventorySlot = i;
            return;
        }
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.equippedInventorySlot = -1;
    }

    private void stowEquippedItem() {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.equippedInventorySlot = -1;
    }

    private void ensureEquippedItemValid() {
        ItemStack stack;
        if (this.equippedInventorySlot >= 0 && this.equippedInventorySlot < this.inventory.getSlots() && !(stack = this.inventory.getStackInSlot(this.equippedInventorySlot)).m_41619_() && this.isUsableWeapon(stack)) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.m_21205_())) {
                this.m_8061_(EquipmentSlot.MAINHAND, stack);
            }
            return;
        }
        this.equipFirstAvailableWeapon();
    }

    private boolean isUsableWeapon(ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof TridentItem || stack.m_41720_() instanceof TieredItem;
    }
}

