/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.event.synthevent.chat;

import it.mitl.minecraftbecomeplayers.entity.custom.SynthEntity;
import it.mitl.minecraftbecomeplayers.subroutine.SynthUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SynthActivationEvent {
    private static final String DEFAULT_PREFIX = "\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 ";
    public static final double ACTIVATION_RADIUS = 10.0;

    @SubscribeEvent
    public static void onChatMessage(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        String message = event.getRawText();
        if (message == null) {
            return;
        }
        message = message.trim();
        SynthEntity synth = SynthActivationEvent.getNearestSynth((Player)player);
        if (synth == null) {
            return;
        }
        String prefix = SynthActivationEvent.getSynthPrefix(synth);
        if (message.equalsIgnoreCase("Activate Synth")) {
            event.setCanceled(true);
            if (synth.isActivationComplete()) {
                player.m_213846_((Component)Component.m_237113_((String)(prefix + "This synth has already been activated.")));
                return;
            }
            if (synth.getActivationStage() > 0 && !synth.isOwner((Player)player)) {
                player.m_213846_((Component)Component.m_237113_((String)(prefix + "This synth is currently being activated by another user.")));
                return;
            }
            synth.setOwnerUUID(player.m_20148_());
            if (synth.getActivationStage() <= 0) {
                synth.setActivationStage(1);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Initializing..."));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Activation complete. Welcome!"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Please state the name you would like me to go by."));
            } else {
                SynthActivationEvent.promptForCurrentStage((Player)player, synth);
            }
            return;
        }
        if (synth.getActivationStage() > 0 && synth.isOwner((Player)player)) {
            int stage = synth.getActivationStage();
            switch (stage) {
                case 1: {
                    event.setCanceled(true);
                    String name = message;
                    if (name.isEmpty()) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 Please provide a non-empty name."));
                        return;
                    }
                    if (name.length() > 16) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a79[\u00a7bCrafter\u00a73Life\u00a79]\u00a77 That name is a bit long. Please use 16 characters or fewer."));
                        return;
                    }
                    synth.setSynthName(name);
                    String newPrefix = SynthActivationEvent.getSynthPrefix(synth);
                    player.m_213846_((Component)Component.m_237113_((String)(newPrefix + "Thank you. My name is now " + name + ".")));
                    synth.setActivationStage(2);
                    player.m_213846_((Component)Component.m_237113_((String)(newPrefix + "Please specify my gender (Male/Female/Non-binary/Other).")));
                    return;
                }
                case 2: {
                    event.setCanceled(true);
                    int gender = SynthActivationEvent.handleGenders(message);
                    if (gender == -1) {
                        player.m_213846_((Component)Component.m_237113_((String)(SynthActivationEvent.getSynthPrefix(synth) + "I didn't catch that. Please reply with Male, Female, Non-binary, or Other.")));
                        return;
                    }
                    synth.setSynthSkin(SynthActivationEvent.pickRandomSkin(gender));
                    synth.setGender(gender);
                    synth.setActivationStage(3);
                    player.m_213846_((Component)Component.m_237113_((String)(SynthActivationEvent.getSynthPrefix(synth) + "Activation complete. Ready for service.")));
                    return;
                }
            }
        }
    }

    private static void promptForCurrentStage(Player player, SynthEntity synth) {
        String prefix = SynthActivationEvent.getSynthPrefix(synth);
        switch (synth.getActivationStage()) {
            case 1: {
                player.m_213846_((Component)Component.m_237113_((String)(prefix + "Please state the name you would like me to go by.")));
                break;
            }
            case 2: {
                player.m_213846_((Component)Component.m_237113_((String)(prefix + "Please specify my gender (Male/Female/Non-binary/Other).")));
                break;
            }
            default: {
                player.m_213846_((Component)Component.m_237113_((String)(prefix + "This synth is already activated.")));
            }
        }
    }

    public static boolean isSynthNearby(Player player) {
        return SynthActivationEvent.getNearestSynth(player) != null;
    }

    @Nullable
    private static SynthEntity getNearestSynth(Player player) {
        List list = player.m_9236_().m_6443_(SynthEntity.class, player.m_20191_().m_82400_(10.0), Entity::m_6084_);
        if (list.isEmpty()) {
            return null;
        }
        SynthEntity best = null;
        double bestDist = Double.MAX_VALUE;
        for (SynthEntity synth : list) {
            double d = synth.m_20280_((Entity)player);
            if (!(d < bestDist)) continue;
            bestDist = d;
            best = synth;
        }
        return best;
    }

    private static int handleGenders(String input) {
        String genderInput;
        return switch (genderInput = input.trim().toLowerCase()) {
            case "male", "m" -> 1;
            case "female", "f" -> 2;
            case "non-binary", "nonbinary", "nb" -> 3;
            case "other", "o" -> 4;
            default -> -1;
        };
    }

    private static String getSynthPrefix(SynthEntity synth) {
        String name = synth.getSynthName();
        if (name == null || name.isEmpty()) {
            return DEFAULT_PREFIX;
        }
        return "\u00a79[\u00a7b" + name + "\u00a79]\u00a77 ";
    }

    private static String pickRandomSkin(int gender) {
        int totalSkins = 0;
        String path = "";
        if (gender == 1) {
            totalSkins = SynthUtils.getTotalSkins(gender);
            path = "male/";
        } else if (gender == 2) {
            totalSkins = SynthUtils.getTotalSkins(gender);
            path = "female/";
        } else if (gender == 3 || gender == 4) {
            int newGender = Math.random() < 0.5 ? 1 : 2;
            totalSkins = SynthUtils.getTotalSkins(newGender);
            path = newGender == 1 ? "male/" : "female/";
        }
        int skinNumber = 1 + (int)(Math.random() * (double)totalSkins);
        return path + skinNumber + ".png";
    }

    public static void sendChat(Player player, Component message) {
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                player.m_213846_(message);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

