/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.event.synthevent.chat;

import it.mitl.minecraftbecomeplayers.entity.custom.SynthEntity;
import it.mitl.minecraftbecomeplayers.subroutine.SynthUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SynthInstructionEvent {
    public static final double INSTRUCTION_RADIUS = 25.0;

    @SubscribeEvent
    public static void onChatMessage(ServerChatEvent event) {
        Collection targets;
        ServerPlayer player = event.getPlayer();
        String message = event.getRawText();
        if (message == null) {
            return;
        }
        if ((message = message.trim()).isEmpty()) {
            return;
        }
        String lowerMsg = message.toLowerCase();
        boolean hasStay = SynthInstructionEvent.containsWord(lowerMsg, "stay");
        boolean hasRoam = SynthInstructionEvent.containsWord(lowerMsg, "roam");
        boolean hasFollow = SynthInstructionEvent.containsWord(lowerMsg, "follow");
        if (!(hasStay || hasRoam || hasFollow)) {
            return;
        }
        boolean targetAllOwnedSynths = SynthInstructionEvent.containsWord(lowerMsg, "synths");
        List list = player.m_9236_().m_6443_(SynthEntity.class, player.m_20191_().m_82400_(25.0), Entity::m_6084_);
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, SynthEntity> chosenByName = new HashMap<String, SynthEntity>();
        HashMap<String, Double> bestDistByName = new HashMap<String, Double>();
        for (SynthEntity synth : list) {
            String nameLower;
            Object name;
            if (!synth.isOwner((Player)player) || (name = synth.getSynthName()) == null || ((String)name).isEmpty() || !SynthInstructionEvent.containsWord(lowerMsg, nameLower = ((String)name).toLowerCase())) continue;
            double dist = synth.m_20280_((Entity)player);
            Double best = (Double)bestDistByName.get(nameLower);
            if (best != null && !(dist < best)) continue;
            bestDistByName.put(nameLower, dist);
            chosenByName.put(nameLower, synth);
        }
        if (!chosenByName.isEmpty()) {
            targets = chosenByName.values();
        } else if (targetAllOwnedSynths) {
            ArrayList owned = new ArrayList();
            for (SynthEntity s : list) {
                if (!s.isOwner((Player)player)) continue;
                owned.add(s);
            }
            if (owned.isEmpty()) {
                return;
            }
            targets = owned;
        } else {
            return;
        }
        for (SynthEntity target : targets) {
            String reply;
            if (!target.isActivationComplete()) continue;
            if (hasFollow) {
                target.setStaying(false);
                target.setFollowing(true);
                reply = "All right, I'll follow you.";
            } else if (hasRoam) {
                target.setFollowing(false);
                target.setStaying(false);
                reply = "All right, I'll roam.";
            } else {
                target.setFollowing(false);
                target.setStaying(true);
                reply = "All right, I'll stay here.";
            }
            String displayName = target.getSynthName().isEmpty() ? "Synth" : target.getSynthName();
            String prefix = "\u00a79[\u00a7b" + displayName + "\u00a79]\u00a77 ";
            if (player.m_20194_() != null) {
                SynthUtils.sendChatMessages((Player)player, prefix + reply);
                continue;
            }
            player.m_213846_((Component)Component.m_237113_((String)(prefix + reply)));
        }
    }

    private static boolean containsWord(String word, String wholeString) {
        int indexPos = 0;
        while ((indexPos = word.indexOf(wholeString, indexPos)) != -1) {
            boolean endOk;
            boolean startOk = indexPos == 0 || !Character.isLetterOrDigit(word.charAt(indexPos - 1));
            int endIndexPos = indexPos + wholeString.length();
            boolean bl = endOk = endIndexPos >= word.length() || !Character.isLetterOrDigit(word.charAt(endIndexPos));
            if (startOk && endOk) {
                return true;
            }
            ++indexPos;
        }
        return false;
    }
}

