/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.event.synthevent.combat;

import it.mitl.minecraftbecomeplayers.entity.custom.SynthEntity;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SynthCombatAssistEvent {
    private static final double RADIUS = 25.0;

    @SubscribeEvent
    public static void onOwnerAttack(AttackEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        SynthCombatAssistEvent.commandNearbyAvailableSynths(player, target);
    }

    @SubscribeEvent
    public static void onOwnerHurt(LivingHurtEvent event) {
        LivingEntity entity;
        LivingEntity attacker;
        LivingEntity victim = event.getEntity();
        if (!(victim instanceof Player)) {
            return;
        }
        Player player = (Player)victim;
        DamageSource source = event.getSource();
        Entity entity2 = source.m_7639_();
        LivingEntity livingEntity = attacker = entity2 instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null;
        if (attacker == null || attacker == player) {
            return;
        }
        SynthCombatAssistEvent.commandNearbyAvailableSynths(player, attacker);
    }

    @SubscribeEvent
    public static void onSynthHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof SynthEntity)) {
            return;
        }
        SynthEntity synth = (SynthEntity)livingEntity;
        if (!synth.isActivationComplete()) {
            return;
        }
        if (synth.isStaying()) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity attacker = null;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity le;
            attacker = le = (LivingEntity)entity;
        } else {
            entity = source.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity le2;
                attacker = le2 = (LivingEntity)entity;
            }
        }
        if (attacker == null) {
            return;
        }
        if (attacker instanceof Player && synth.isOwner(player = (Player)attacker)) {
            return;
        }
        synth.m_6710_(attacker);
    }

    private static void commandNearbyAvailableSynths(Player owner, LivingEntity target) {
        List list = owner.m_9236_().m_6443_(SynthEntity.class, owner.m_20191_().m_82400_(25.0), LivingEntity::m_6084_);
        for (SynthEntity synth : list) {
            if (target instanceof SynthEntity && synth.isOwner(owner)) {
                return;
            }
            if (!synth.isActivationComplete() || !synth.isOwner(owner) || synth.isStaying()) continue;
            synth.m_6710_(target);
        }
    }
}

