/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.item.custom;

import it.mitl.minecraftbecomeplayers.entity.custom.SynthEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TrackerItem
extends Item {
    private static final String TAG_TRACKED = "TrackedSynths";
    private static final String TAG_SELECTED = "Selected";
    private static final String KEY_ID = "Id";
    private static final String KEY_NAME = "Name";
    private static final int MAX_TRACKED = 5;

    public TrackerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        ListTag list = TrackerItem.trackedList(stack);
        if (list.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)"Linked Synths: ").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)"  \u2022 None").m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)"Linked Synths:").m_130940_(ChatFormatting.GRAY));
        int selected = TrackerItem.getSelectedIndex(stack);
        for (int i = 0; i < list.size(); ++i) {
            String name = TrackerItem.getNameAt(list, i).orElse("Synth");
            MutableComponent line = Component.m_237113_((String)("  \u2022 " + name));
            line = i == selected ? line.m_130938_(s -> s.m_131140_(ChatFormatting.AQUA).m_131136_(Boolean.valueOf(true))) : line.m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)line);
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof SynthEntity)) {
            return InteractionResult.PASS;
        }
        SynthEntity synth = (SynthEntity)target;
        if (player.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!synth.isOwner(player)) {
            player.m_5661_((Component)Component.m_237113_((String)"You do not own this synth."), true);
            return InteractionResult.CONSUME;
        }
        if (player.m_6144_()) {
            boolean removed = TrackerItem.removeTracked(stack, synth.m_20148_());
            if (removed) {
                player.m_5661_((Component)Component.m_237113_((String)("Removed " + TrackerItem.displayName(synth) + " from tracker.")), true);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)(TrackerItem.displayName(synth) + " is not linked to this tracker.")), true);
            }
            return InteractionResult.CONSUME;
        }
        if (TrackerItem.isTracked(stack, synth.m_20148_())) {
            TrackerItem.selectByUUID(stack, synth.m_20148_());
            player.m_5661_((Component)Component.m_237113_((String)("Selected " + TrackerItem.displayName(synth) + ".")), true);
            return InteractionResult.CONSUME;
        }
        int size = TrackerItem.trackedList(stack).size();
        if (size >= 5) {
            player.m_5661_((Component)Component.m_237113_((String)"Tracker is full (5)."), true);
            return InteractionResult.CONSUME;
        }
        TrackerItem.addTracked(stack, synth.m_20148_(), synth.getSynthName());
        TrackerItem.setSelectedIndex(stack, TrackerItem.trackedList(stack).size() - 1);
        player.m_5661_((Component)Component.m_237113_((String)("Linked tracker to " + TrackerItem.displayName(synth) + ".")), true);
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ListTag list = TrackerItem.trackedList(stack);
        if (list.isEmpty()) {
            player.m_5661_((Component)Component.m_237113_((String)"No synths linked to this tracker."), true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (player.m_6144_()) {
            int idx = TrackerItem.getSelectedIndex(stack);
            idx = (idx + 1) % list.size();
            TrackerItem.setSelectedIndex(stack, idx);
            String name = TrackerItem.getNameAt(list, idx).orElse("Synth");
            player.m_5661_((Component)Component.m_237113_((String)("Selected: " + name)), true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        Optional<UUID> id = TrackerItem.getSelectedUUID(stack);
        if (id.isEmpty()) {
            player.m_5661_((Component)Component.m_237113_((String)"No synth selected."), true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        UUID uuid = id.get();
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SynthEntity synth = TrackerItem.findSynth(serverLevel, uuid);
        if (synth == null) {
            player.m_5661_((Component)Component.m_237113_((String)"Unable to find selected synth."), true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!synth.m_9236_().m_46472_().equals((Object)player.m_9236_().m_46472_())) {
            player.m_5661_((Component)Component.m_237113_((String)"Selected synth is in another dimension."), true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        int x = (int)Math.floor(synth.m_20185_());
        int y = (int)Math.floor(synth.m_20186_());
        int z = (int)Math.floor(synth.m_20189_());
        String name = synth.getSynthName().isEmpty() ? "Synth" : synth.getSynthName();
        player.m_5661_((Component)Component.m_237113_((String)(name + " @ (" + x + ", " + y + ", " + z + ")")), true);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private static String displayName(SynthEntity synth) {
        String n = synth.getSynthName();
        return n == null || n.isEmpty() ? "Synth" : n;
    }

    private static SynthEntity findSynth(ServerLevel level, UUID uuid) {
        Entity ent = level.m_8791_(uuid);
        if (ent instanceof SynthEntity) {
            SynthEntity s = (SynthEntity)ent;
            return s;
        }
        AABB box = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (SynthEntity s : level.m_45976_(SynthEntity.class, box)) {
            if (!uuid.equals(s.m_20148_())) continue;
            return s;
        }
        return null;
    }

    private static ListTag trackedList(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_(TAG_TRACKED, 9)) {
            ListTag list = new ListTag();
            tag.m_128365_(TAG_TRACKED, (Tag)list);
            if (!tag.m_128441_(TAG_SELECTED)) {
                tag.m_128405_(TAG_SELECTED, 0);
            }
            return list;
        }
        return tag.m_128437_(TAG_TRACKED, 10);
    }

    private static boolean isTracked(ItemStack stack, UUID uuid) {
        ListTag list = TrackerItem.trackedList(stack);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag e = list.m_128728_(i);
            if (!uuid.toString().equalsIgnoreCase(e.m_128461_(KEY_ID))) continue;
            return true;
        }
        return false;
    }

    private static void addTracked(ItemStack stack, UUID uuid, String name) {
        ListTag list = TrackerItem.trackedList(stack);
        CompoundTag e = new CompoundTag();
        e.m_128359_(KEY_ID, uuid.toString());
        if (name != null && !name.isEmpty()) {
            e.m_128359_(KEY_NAME, name);
        }
        list.add((Object)e);
    }

    private static boolean removeTracked(ItemStack stack, UUID uuid) {
        ListTag list = TrackerItem.trackedList(stack);
        int idxToRemove = -1;
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag e = list.m_128728_(i);
            if (!uuid.toString().equalsIgnoreCase(e.m_128461_(KEY_ID))) continue;
            idxToRemove = i;
            break;
        }
        if (idxToRemove >= 0) {
            list.remove(idxToRemove);
            int sel = TrackerItem.getSelectedIndex(stack);
            if (list.isEmpty()) {
                TrackerItem.setSelectedIndex(stack, 0);
            } else if (idxToRemove < sel) {
                TrackerItem.setSelectedIndex(stack, Math.max(0, sel - 1));
            } else if (idxToRemove == sel) {
                TrackerItem.setSelectedIndex(stack, sel % list.size());
            }
            return true;
        }
        return false;
    }

    private static void selectByUUID(ItemStack stack, UUID uuid) {
        ListTag list = TrackerItem.trackedList(stack);
        for (int i = 0; i < list.size(); ++i) {
            if (!uuid.toString().equalsIgnoreCase(list.m_128728_(i).m_128461_(KEY_ID))) continue;
            TrackerItem.setSelectedIndex(stack, i);
            return;
        }
    }

    private static int getSelectedIndex(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int size = TrackerItem.trackedList(stack).size();
        int sel = tag.m_128451_(TAG_SELECTED);
        if (size == 0) {
            return 0;
        }
        if (sel < 0 || sel >= size) {
            sel = 0;
        }
        return sel;
    }

    private static void setSelectedIndex(ItemStack stack, int idx) {
        stack.m_41784_().m_128405_(TAG_SELECTED, Math.max(0, idx));
    }

    private static Optional<UUID> getSelectedUUID(ItemStack stack) {
        ListTag list = TrackerItem.trackedList(stack);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int sel = TrackerItem.getSelectedIndex(stack);
        CompoundTag e = list.m_128728_(sel);
        try {
            return Optional.of(UUID.fromString(e.m_128461_(KEY_ID)));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private static Optional<String> getNameAt(ListTag list, int idx) {
        if (idx < 0 || idx >= list.size()) {
            return Optional.empty();
        }
        CompoundTag e = list.m_128728_(idx);
        if (e.m_128425_(KEY_NAME, 8)) {
            return Optional.of(e.m_128461_(KEY_NAME));
        }
        return Optional.of("Synth");
    }
}

