/*
 * Decompiled with CFR 0.152.
 */
package it.mitl.minecraftbecomeplayers.menu;

import it.mitl.minecraftbecomeplayers.entity.custom.SynthEntity;
import it.mitl.minecraftbecomeplayers.menu.ModMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SynthInventoryMenu
extends AbstractContainerMenu {
    private final SynthEntity synth;
    private final IItemHandler itemHandler;

    public SynthInventoryMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory, (SynthEntity)playerInventory.f_35978_.m_9236_().m_6815_(buf.m_130242_()));
    }

    public SynthInventoryMenu(int windowId, Inventory playerInventory, SynthEntity synth) {
        super((MenuType)ModMenus.SYNTH_INVENTORY.get(), windowId);
        this.synth = synth;
        this.itemHandler = synth.getItemHandler();
        int index = 0;
        int startX = 8;
        int startY = 18;
        int columns = 9;
        int rows = 3;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, index++, startX + c * 18, startY + r * 18));
            }
        }
        int playerInvY = startY + rows * 18 + 14;
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.m_38897_(new Slot((Container)playerInventory, c + r * 9 + 9, 8 + c * 18, playerInvY + r * 18));
            }
        }
        int hotbarY = playerInvY + 58;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, hotbarY));
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_20280_((Entity)this.synth) < 64.0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            int synthSlots = 27;
            if (index < synthSlots ? !this.m_38903_(stackInSlot, synthSlots, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, synthSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

