/*
 * Decompiled with CFR 0.152.
 */
package net.elysieon.aetherpunk.components;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.awt.Color;
import net.elysieon.aetherpunk.Aetherpunk;
import net.elysieon.aetherpunk.effect.FlashEffect;
import net.elysieon.aetherpunk.effect.RedFlashEffect;
import net.elysieon.aetherpunk.index.AetherpunkPacket;
import net.elysieon.aetherpunk.index.AetherpunkSounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class MaceComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 player;
    private boolean particleActive = false;
    private int frozen = 0;
    private int frozenstate = 0;
    private int maceCharge = 400;
    private int maceOverloadCharge = 350;
    private int maceVolatileCharge = 350;
    private int previousFrozen = 0;
    private boolean isClientSoundsPaused;

    public static MaceComponent get(@NotNull class_1657 player) {
        return (MaceComponent)Aetherpunk.MACE.get((Object)player);
    }

    public int getChargeTint(class_1799 stack) {
        if (stack.method_7964().getString().equals("Gaytherpunk")) {
            return Color.getHSBColor((float)((double)this.player.method_37908().method_8510() / 100.0) % 360.0f, 1.0f, 1.0f).getRGB();
        }
        return 0xFFFFFF;
    }

    public float getFrost() {
        return this.frozen;
    }

    public float getFrozenstate() {
        return this.frozenstate;
    }

    public void sparkFrozen() {
        this.frozen = 5;
        this.sync();
    }

    public void setFrozenstate(int fishystateuwu) {
        this.frozenstate = fishystateuwu;
        this.sync();
    }

    public void setFrozenstateFromVolatile(int fishystateuwu) {
        this.frozenstate = fishystateuwu;
        this.sync();
        if (this.player.method_37908() instanceof class_638) {
            this.isClientSoundsPaused = true;
            this.pauseClientSounds();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void pauseClientSounds() {
        class_310.method_1551().method_1483().method_4879();
    }

    @Environment(value=EnvType.CLIENT)
    private void resumeClientSounds() {
        class_310.method_1551().method_1483().method_4880();
    }

    public boolean isFrozen() {
        return this.frozen > 0;
    }

    private void tickFrozenState() {
        if (this.frozen == 1 && this.frozenstate == 1) {
            if (this.player.method_37908().field_9236) {
                this.isClientSoundsPaused = false;
                this.resumeClientSounds();
            } else {
                this.player.method_37908().method_8396(null, this.player.method_24515(), AetherpunkSounds.MACE_IMPACT_2, class_3419.field_15248, 1.25f, 0.9f);
            }
        }
        if (this.frozen > 0) {
            --this.frozen;
            this.sync();
        }
        if (this.frozen <= 0) {
            this.frozenstate = 0;
        }
        if (this.player.method_37908().field_9236 && this.frozen != 0 && this.previousFrozen == 0 && this.frozenstate == 1) {
            FlashEffect.LAST_PARRYING_TIME = this.player.method_37908().method_8510();
        }
        if (this.player.method_37908().field_9236 && this.frozen != 0 && this.previousFrozen == 0 && this.frozenstate == 2) {
            RedFlashEffect.LAST_PARRYING_TIME = this.player.method_37908().method_8510();
        }
        this.previousFrozen = this.frozen;
    }

    public float getCharge() {
        return (float)this.maceCharge / 400.0f;
    }

    public float getChargeOverload() {
        return (float)this.maceOverloadCharge / 350.0f;
    }

    public float getChargeVolatile() {
        return (float)this.maceVolatileCharge / 350.0f;
    }

    public void setCharge(int Charge) {
        this.maceCharge = Charge;
        this.sync();
    }

    public void setChargeOverload(int Charge) {
        this.maceOverloadCharge = Charge;
        this.sync();
    }

    public void setChargeVolatile(int Charge) {
        this.maceVolatileCharge = Charge;
        this.sync();
    }

    public MaceComponent(class_1657 playerEntity) {
        this.player = playerEntity;
    }

    public void handleParticles() {
        if (!this.particleActive) {
            this.particleActive = true;
        }
    }

    public boolean isParticleActive() {
        return this.particleActive;
    }

    private void sync() {
        Aetherpunk.MACE.sync((Object)this.player);
    }

    public void handleTrailParticles() {
        if (this.player.method_24828()) {
            this.particleActive = false;
        }
        for (int i = 0; i < 2; ++i) {
            for (class_1657 loopedplayer : this.player.method_37908().method_18456()) {
                if (!(loopedplayer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)loopedplayer;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)AetherpunkPacket.SPARK, (class_2540)new class_2540(PacketByteBufs.create().writeDouble(this.player.method_23317()).writeDouble(this.player.method_23318() + 1.0).writeDouble(this.player.method_23321()).writeDouble(15.0).writeFloat(0.15f).writeFloat(0.9f).writeFloat(0.15f)));
            }
        }
    }

    public void tick() {
        if (this.particleActive) {
            this.handleTrailParticles();
        }
        this.tickFrozenState();
        if (this.maceVolatileCharge < 350) {
            ++this.maceVolatileCharge;
        }
        if (this.maceOverloadCharge < 350) {
            ++this.maceOverloadCharge;
        }
        if (this.maceCharge < 400) {
            ++this.maceCharge;
        }
        this.sync();
    }

    public void readFromNbt(class_2487 tag) {
        this.particleActive = tag.method_10577("particleActive");
        this.maceCharge = tag.method_10550("maceCharge");
        this.maceVolatileCharge = tag.method_10550("maceVolatileCharge");
        this.maceOverloadCharge = tag.method_10550("maceOverloadCharge");
        this.frozen = tag.method_10550("frozen");
        this.frozenstate = tag.method_10550("frozenstate");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("particleActive", this.particleActive);
        tag.method_10569("maceCharge", this.maceCharge);
        tag.method_10569("maceVolatileCharge", this.maceVolatileCharge);
        tag.method_10569("maceOverloadCharge", this.maceOverloadCharge);
        tag.method_10569("frozen", this.frozen);
        tag.method_10569("frozenstate", this.frozenstate);
    }
}

