/*
 * Decompiled with CFR 0.152.
 */
package net.elysieon.aetherpunk.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.elysieon.aetherpunk.components.MaceComponent;
import net.elysieon.aetherpunk.entity.VolatileEntity;
import net.elysieon.aetherpunk.index.AetherpunkDamageTypes;
import net.elysieon.aetherpunk.index.AetherpunkEnchantments;
import net.elysieon.aetherpunk.index.AetherpunkPacket;
import net.elysieon.aetherpunk.index.AetherpunkParticles;
import net.elysieon.aetherpunk.index.AetherpunkSounds;
import net.elysieon.aetherpunk.item.AetherpunkToolMaterial;
import net.elysieon.aetherpunk.util.AetherpunkUtil;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5134;

public class AetherpunkMaceItem
extends class_1831 {
    private static final float ATTACK_DAMAGE = 6.0f;
    private static final float ATTACK_SPEED = 1.2f;
    private final Multimap<class_1320, class_1322> attributeModifiers = ImmutableMultimap.builder().put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", 6.0, class_1322.class_1323.field_6328)).put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)-2.8f, class_1322.class_1323.field_6328)).build();

    public AetherpunkMaceItem(FabricItemSettings settings) {
        super(AetherpunkToolMaterial.INSTANCE, (class_1792.class_1793)settings);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public class_2561 method_7864(class_1799 stack) {
        int rgbColor = 8510160;
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.RELOCITY)) {
            rgbColor = 7336589;
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.OVERLOAD)) {
            rgbColor = 16638847;
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.VOLATILE)) {
            rgbColor = 13584702;
        }
        return class_2561.method_43471((String)this.method_7866(stack)).method_10862(class_2583.field_24360.method_36139(rgbColor));
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        MaceComponent mace = MaceComponent.get(player);
        if (hand == class_1268.field_5810 || !AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.RELOCITY) || !(mace.getCharge() >= 1.0f)) {
            return class_1271.method_22431((Object)stack);
        }
        mace.setCharge(0);
        player.method_5783(AetherpunkSounds.RELOCITY, 0.3f, 1.1f);
        player.method_18799(player.method_5720().method_18805((double)2.4f, (double)1.3f, (double)2.4f));
        mace.handleParticles();
        return super.method_7836(world, player, hand);
    }

    public void overloadHit(class_1309 target, class_1657 player, float damage) {
        MaceComponent mace = MaceComponent.get(player);
        mace.setChargeOverload(0);
        damage = Math.min(23.0f, damage * 3.6f);
        target.method_5643(target.method_48923().method_48795(AetherpunkDamageTypes.OVERLOAD), damage);
        player.method_18800(player.method_18798().field_1352 * 2.5, 1.0, player.method_18798().field_1350 * 2.5);
        player.field_6037 = true;
        mace.sparkFrozen();
        mace.setFrozenstate(1);
        if (target instanceof class_1657) {
            class_1657 targetPlayer = (class_1657)target;
            MaceComponent targetMaceComponent = MaceComponent.get(targetPlayer);
            targetMaceComponent.sparkFrozen();
            targetMaceComponent.setFrozenstate(1);
        }
        if (!target.method_37908().field_9236) {
            player.method_37908().method_8396(null, player.method_24515(), AetherpunkSounds.MACE_IMPACT_3, class_3419.field_15248, 1.5f, 0.9f);
        }
        if (!player.method_37908().field_9236) {
            class_3218 serverWorld = (class_3218)player.method_37908();
            serverWorld.method_14199((class_2394)AetherpunkParticles.SHOCKWAVE, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 1, 0.0, 0.0, 0.0, 0.25);
        }
        for (int i = 0; i < 75; ++i) {
            for (class_1657 loopedplayer : player.method_37908().method_18456()) {
                if (!(loopedplayer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)loopedplayer;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)AetherpunkPacket.SPARK, (class_2540)new class_2540(PacketByteBufs.create().writeDouble(target.method_23317()).writeDouble(target.method_23318() + 1.0).writeDouble(target.method_23321()).writeDouble(2.0).writeFloat(0.9f).writeFloat(0.64f).writeFloat(0.1f)));
            }
        }
    }

    public void volatileHit(class_1309 target, class_1657 player, float damage) {
        MaceComponent mace = MaceComponent.get(player);
        mace.setChargeVolatile(0);
        damage = Math.min(20.0f, damage * 3.2f);
        target.method_5643(target.method_48923().method_48795(AetherpunkDamageTypes.VOLATILE), damage);
        player.method_5643(player.method_48923().method_48795(AetherpunkDamageTypes.VOLATILE), damage * 0.75f);
        VolatileEntity volatileEntity = new VolatileEntity(player.method_37908(), (class_1309)player);
        volatileEntity.method_18799(player.method_18798().method_38499(class_2350.class_2351.field_11052, 0.0).method_1029().method_1021(Math.max(0.75, player.method_18798().method_1033())));
        volatileEntity.field_6037 = true;
        volatileEntity.field_5960 = true;
        volatileEntity.damage = damage * 0.5f;
        player.method_37908().method_8649((class_1297)volatileEntity);
        mace.sparkFrozen();
        mace.setFrozenstateFromVolatile(2);
        if (target instanceof class_1657) {
            class_1657 targetPlayer = (class_1657)target;
            MaceComponent targetMaceComponent = MaceComponent.get(targetPlayer);
            targetMaceComponent.sparkFrozen();
            targetMaceComponent.setFrozenstate(2);
        }
        target.method_18800(player.method_18798().field_1352 * 1.75, 1.0, player.method_18798().field_1350 * 1.75);
        player.method_18800(player.method_18798().field_1352 * -1.0, 1.0, player.method_18798().field_1350 * -1.0);
        player.field_6037 = true;
        target.field_6037 = true;
        if (!player.method_37908().field_9236) {
            player.method_37908().method_8396(null, player.method_24515(), AetherpunkSounds.MACE_IMPACT_1, class_3419.field_15248, 1.0f, AetherpunkUtil.random(1.1f, 1.15f));
            player.method_37908().method_8396(null, player.method_24515(), AetherpunkSounds.MACE_IMPACT_2, class_3419.field_15248, 2.0f, AetherpunkUtil.random(1.1f, 1.15f));
        }
        if (!player.method_37908().field_9236) {
            class_3218 serverWorld = (class_3218)player.method_37908();
            serverWorld.method_14199((class_2394)AetherpunkParticles.SHOCKWAVER, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 1, 0.0, 0.0, 0.0, 0.25);
        }
        for (int i = 0; i < 50; ++i) {
            for (class_1657 loopedplayer : player.method_37908().method_18456()) {
                if (!(loopedplayer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)loopedplayer;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)AetherpunkPacket.SPARK, (class_2540)new class_2540(PacketByteBufs.create().writeDouble(target.method_23317()).writeDouble(target.method_23318() + 1.0).writeDouble(target.method_23321()).writeDouble(4.0).writeFloat(0.9f).writeFloat(0.15f).writeFloat(0.2f)));
            }
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        float damageMultiplier;
        MaceComponent mace = MaceComponent.get((class_1657)attacker);
        class_243 vel = attacker.method_18798();
        double horizontalSpeed = Math.sqrt(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350);
        float damage = (float)(horizontalSpeed * (double)(damageMultiplier = AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.RELOCITY) ? 9.0f : 11.0f));
        if (!((double)damage > 0.8)) {
            return super.method_7873(stack, target, attacker);
        }
        if (damage > 10.0f && AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.OVERLOAD) && mace.getChargeOverload() >= 1.0f) {
            this.overloadHit(target, (class_1657)attacker, damage);
            return super.method_7873(stack, target, attacker);
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.VOLATILE) && mace.getChargeVolatile() >= 1.0f) {
            this.volatileHit(target, (class_1657)attacker, damage);
            if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.VOLATILE)) {
                attacker.method_37908().method_8396(null, attacker.method_24515(), AetherpunkSounds.VOLATILE, class_3419.field_15248, 0.25f, AetherpunkUtil.random(1.1f, 1.15f));
            }
            return super.method_7873(stack, target, attacker);
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.OVERLOAD)) {
            mace.setChargeOverload((int)Math.min(mace.getChargeOverload() * 350.0f + 175.0f, 350.0f));
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.VOLATILE)) {
            mace.setChargeVolatile(350);
        }
        mace.setCharge(400);
        attacker.method_18800(attacker.method_18798().field_1352 * 1.3, 0.4 + (double)(damage / 25.0f), attacker.method_18798().field_1350 * 1.3);
        attacker.field_6037 = true;
        damage = Math.min(16.0f, damage * 3.2f);
        target.method_5643(target.method_48923().method_48795(AetherpunkDamageTypes.SLAM), damage);
        if (!target.method_37908().field_9236) {
            attacker.method_37908().method_8396(null, attacker.method_24515(), AetherpunkSounds.MACE_IMPACT_1, class_3419.field_15248, 1.0f, AetherpunkUtil.random(1.1f, 1.15f));
            attacker.method_37908().method_8396(null, attacker.method_24515(), AetherpunkSounds.MACE_IMPACT_2, class_3419.field_15248, 2.0f, AetherpunkUtil.random(1.1f, 1.15f));
        }
        if (!attacker.method_37908().field_9236) {
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.RELOCITY)) {
                serverWorld.method_14199((class_2394)AetherpunkParticles.SHOCKWAVEG, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 1, 0.0, 0.0, 0.0, 0.25);
            } else if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.OVERLOAD)) {
                serverWorld.method_14199((class_2394)AetherpunkParticles.SHOCKWAVE, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 1, 0.0, 0.0, 0.0, 0.25);
            } else if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.VOLATILE)) {
                serverWorld.method_14199((class_2394)AetherpunkParticles.SHOCKWAVER, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 1, 0.0, 0.0, 0.0, 0.25);
            } else {
                serverWorld.method_14199((class_2394)AetherpunkParticles.SHOCKWAVEB, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 1, 0.0, 0.0, 0.0, 0.25);
            }
        }
        float r = 0.0f;
        float g = 0.9f;
        float b = 0.9f;
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.RELOCITY)) {
            r = 0.2f;
            g = 0.9f;
            b = 0.2f;
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.OVERLOAD)) {
            r = 0.9f;
            g = 0.64f;
            b = 0.1f;
        }
        if (AetherpunkUtil.hasEnchantment(stack, AetherpunkEnchantments.VOLATILE)) {
            r = 0.9f;
            g = 0.15f;
            b = 0.2f;
        }
        for (int i = 0; i < 25; ++i) {
            for (class_1657 loopedplayer : attacker.method_37908().method_18456()) {
                if (!(loopedplayer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)loopedplayer;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)AetherpunkPacket.SPARK, (class_2540)new class_2540(PacketByteBufs.create().writeDouble(target.method_23317()).writeDouble(target.method_23318() + 1.0).writeDouble(target.method_23321()).writeDouble(8.0).writeFloat(r).writeFloat(g).writeFloat(b)));
            }
        }
        return super.method_7873(stack, target, attacker);
    }
}

