/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.recipeviewers.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackSettingsScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.recipeviewers.common.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.recipeviewers.common.subtypes.SubtypeInterpreters;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.SmithingBackpackUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayGenerator;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiCraftingContainerRecipeTransferHandlerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiRecipeDisplayGenerator;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiSettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiStorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.subtypes.JeiSubtypeInterpreter;

@JeiPlugin
public class BackpackJeiPlugin
implements IModPlugin {
    private static Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar = registration -> {};

    public static void addAdditionalCatalystRegistrar(Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar) {
        BackpackJeiPlugin.additionalCatalystRegistrar = BackpackJeiPlugin.additionalCatalystRegistrar.andThen(additionalCatalystRegistrar);
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        SubtypeInterpreters.getSubtypeInterpreters().forEach((item, subtypeInterpreter) -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, item, (ISubtypeInterpreter)JeiSubtypeInterpreter.of((PropertyBasedSubtypeInterpreter)subtypeInterpreter)));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BackpackScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackScreen>(this){

            public List<Rect2i> getGuiExtraAreas(BackpackScreen gui) {
                if (gui.getUpgradeSettingsControl() == null) {
                    return new ArrayList<Rect2i>();
                }
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                return ret;
            }
        });
        registration.addGuiContainerHandler(BackpackSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackSettingsScreen>(this){

            public List<Rect2i> getGuiExtraAreas(BackpackSettingsScreen gui) {
                return new ArrayList<Rect2i>(gui.getExtendedControlsRectangles());
            }
        });
        registration.addGhostIngredientHandler(BackpackScreen.class, (IGhostIngredientHandler)new JeiStorageGhostIngredientHandler());
        registration.addGhostIngredientHandler(SettingsScreen.class, (IGhostIngredientHandler)new JeiSettingsGhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        JeiRecipeDisplayGenerator generator = new JeiRecipeDisplayGenerator();
        DyeRecipesMaker.addRecipes(generator);
        ClientRecipeHelper.addAllRecipesOfType((IRecipeDisplayGenerator)generator, (RecipeType)RecipeType.CRAFTING, BackpackUpgradeRecipe.class);
        ClientRecipeHelper.addAllRecipesOfType((IRecipeDisplayGenerator)generator, (RecipeType)RecipeType.SMITHING, SmithingBackpackUpgradeRecipe.class);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, generator.getCraftingRecipes());
        registration.addRecipes((IRecipeType)RecipeTypes.SMITHING, generator.getSmithingRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation((IRecipeType)RecipeTypes.CRAFTING, new ItemStack[]{new ItemStack((ItemLike)ModItems.CRAFTING_UPGRADE.get())});
        registration.addCraftingStation((IRecipeType)RecipeTypes.STONECUTTING, new ItemStack[]{new ItemStack((ItemLike)ModItems.STONECUTTER_UPGRADE.get())});
        registration.addCraftingStation((IRecipeType)RecipeTypes.SMITHING, new ItemStack[]{new ItemStack((ItemLike)ModItems.SMITHING_UPGRADE.get())});
        additionalCatalystRegistrar.accept(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new JeiCraftingContainerRecipeTransferHandlerBase<BackpackContainer, RecipeHolder<CraftingRecipe>>(this, handlerHelper, stackHelper){

            public Class<BackpackContainer> getContainerClass() {
                return BackpackContainer.class;
            }

            public IRecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }
        }, (IRecipeType)RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new JeiCraftingContainerRecipeTransferHandlerBase<BackpackContainer, RecipeHolder<SmithingRecipe>>(this, handlerHelper, stackHelper){

            public Class<BackpackContainer> getContainerClass() {
                return BackpackContainer.class;
            }

            public IRecipeType<RecipeHolder<SmithingRecipe>> getRecipeType() {
                return RecipeTypes.SMITHING;
            }
        }, (IRecipeType)RecipeTypes.SMITHING);
    }
}

