/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;

public record BackpackOpenPayload(int slotIndex, String identifier, String handlerName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BackpackOpenPayload> TYPE = new CustomPacketPayload.Type(SophisticatedBackpacks.getRL("backpack_open"));
    private static final int CHEST_SLOT = 38;
    private static final int OFFHAND_SLOT = 40;
    public static final StreamCodec<ByteBuf, BackpackOpenPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, BackpackOpenPayload::slotIndex, (StreamCodec)ByteBufCodecs.STRING_UTF8, BackpackOpenPayload::identifier, (StreamCodec)ByteBufCodecs.STRING_UTF8, BackpackOpenPayload::handlerName, BackpackOpenPayload::new);

    public BackpackOpenPayload() {
        this(-1);
    }

    public BackpackOpenPayload(int backpackSlot) {
        this(backpackSlot, "");
    }

    public BackpackOpenPayload(int backpackSlot, String identifier) {
        this(backpackSlot, identifier, "");
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(BackpackOpenPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (!payload.handlerName.isEmpty()) {
            BackpackContainer backpackContainer;
            AbstractContainerMenu abstractContainerMenu;
            int adjustedSlotIndex = payload.slotIndex;
            if (adjustedSlotIndex == 38) {
                adjustedSlotIndex -= 36;
            } else if (adjustedSlotIndex == 40) {
                adjustedSlotIndex = 0;
            }
            BackpackContext.Item backpackContext = new BackpackContext.Item(payload.handlerName, payload.identifier, adjustedSlotIndex, player.containerMenu instanceof InventoryMenu || (abstractContainerMenu = player.containerMenu) instanceof BackpackContainer && (backpackContainer = (BackpackContainer)abstractContainerMenu).getBackpackContext().wasOpenFromInventory());
            BackpackOpenPayload.openBackpack(player, backpackContext);
        } else {
            AbstractContainerMenu adjustedSlotIndex = player.containerMenu;
            if (adjustedSlotIndex instanceof BackpackContainer) {
                BackpackContainer backpackContainer = (BackpackContainer)adjustedSlotIndex;
                backpackContext = backpackContainer.getBackpackContext();
                if (payload.slotIndex == -1) {
                    BackpackOpenPayload.openBackpack(player, ((BackpackContext)backpackContext).getParentBackpackContext());
                } else if (backpackContainer.isStorageInventorySlot(payload.slotIndex)) {
                    BackpackOpenPayload.openBackpack(player, ((BackpackContext)backpackContext).getSubBackpackContext(payload.slotIndex, BackpackWrapper.fromStack(((BackpackContext)backpackContext).getBackpackWrapper(player).getInventoryHandler().getInternalStack(payload.slotIndex)).getContentsUuid().isEmpty()));
                }
            } else {
                backpackContext = player.containerMenu;
                if (backpackContext instanceof IContextAwareContainer) {
                    IContextAwareContainer contextAwareContainer = (IContextAwareContainer)backpackContext;
                    backpackContext = contextAwareContainer.getBackpackContext();
                    BackpackOpenPayload.openBackpack(player, (BackpackContext)backpackContext);
                } else {
                    BackpackOpenPayload.findAndOpenFirstBackpack(player);
                }
            }
        }
    }

    private static void findAndOpenFirstBackpack(Player player) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, identifier, slot);
            player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.getHoverName(), false), backpackContext::toBuffer);
            return true;
        });
    }

    private static void openBackpack(Player player, BackpackContext backpackContext) {
        player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext.getDisplayName(player), false), backpackContext::toBuffer);
    }
}

