/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class InceptionUpgradeItem
extends UpgradeItemBase<InceptionUpgradeWrapper> {
    public static final UpgradeType<InceptionUpgradeWrapper> TYPE = new UpgradeType(InceptionUpgradeWrapper::new);
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(InceptionUpgradeItem.class::isInstance, 0, BackpackTranslationHelper.INSTANCE.translError("add.inception_exists", new Object[0])));

    public InceptionUpgradeItem(Item.Properties properties) {
        super((IUpgradeCountLimitConfig)Config.SERVER.maxUpgradesPerStorage, properties);
    }

    public UpgradeType<InceptionUpgradeWrapper> getType() {
        return TYPE;
    }

    public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, ItemStack upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        UpgradeSlotChangeResult result = super.canAddUpgradeTo(storageWrapper, upgradeStack, firstLevelStorage, isClientSide);
        if (!result.successful()) {
            return result;
        }
        if (!firstLevelStorage) {
            return UpgradeSlotChangeResult.fail((Component)BackpackTranslationHelper.INSTANCE.translError("add.inception_sub_backpack", new Object[0]), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        HashSet errorUpgradeSlots = new HashSet();
        storageWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof InceptionUpgradeWrapper) {
                errorUpgradeSlots.add(slot);
            }
        });
        if (!errorUpgradeSlots.isEmpty()) {
            return UpgradeSlotChangeResult.fail((Component)BackpackTranslationHelper.INSTANCE.translError("add.inception_exists", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
        }
        return UpgradeSlotChangeResult.success();
    }

    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        Set slots = InventoryHelper.getItemSlots((InventoryHandler)storageWrapper.getInventoryHandler(), stack -> stack.getItem() instanceof BackpackItem);
        if (!slots.isEmpty()) {
            return UpgradeSlotChangeResult.fail((Component)BackpackTranslationHelper.INSTANCE.translError("remove.inception_sub_backpack", new Object[0]), Collections.emptySet(), (Set)slots, Collections.emptySet());
        }
        return UpgradeSlotChangeResult.success();
    }

    public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, int upgradeSlot, IStorageWrapper storageWrapper, boolean isClientSide) {
        if (upgradeStackToPut.getItem() == this) {
            return UpgradeSlotChangeResult.success();
        }
        return this.canRemoveUpgradeFrom(storageWrapper, isClientSide);
    }
}

