/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockModel;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;

public class BackpackItemModel
implements ItemModel {
    private final SpecialRenderer specialRenderer = new SpecialRenderer();
    private final BakedModel baseModel;
    private final List<ItemTintSource> tints;

    public BackpackItemModel(BakedModel baseModel, List<ItemTintSource> tints) {
        this.baseModel = baseModel;
        this.tints = tints;
    }

    public void update(ItemStackRenderState stackRenderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int seed) {
        int[] tints = new int[this.tints.size()];
        for (int j = 0; j < tints.length; ++j) {
            tints[j] = this.tints.get(j).calculate(stack, clientLevel, livingEntity);
        }
        ItemStackRenderState.LayerRenderState renderLayer = stackRenderState.newLayer();
        if (stack.hasFoil()) {
            renderLayer.setFoilType(ItemStackRenderState.FoilType.STANDARD);
        }
        int[] tintLayers = renderLayer.prepareTintLayers(tints.length);
        System.arraycopy(tints, 0, tintLayers, 0, tints.length);
        this.setBackpackModelProperties(stack);
        RenderType renderType = this.baseModel.getRenderType(stack);
        renderLayer.setupBlockModel(this.baseModel, renderType);
        this.specialRenderer.setModelRenderParameters(tintLayers, this.baseModel, renderType);
        this.specialRenderer.displayItem = BackpackWrapper.fromStack(stack).getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().orElse(null);
        renderLayer.setupSpecialModel((SpecialModelRenderer)this.specialRenderer, (Object)this.specialRenderer.extractArgument(stack), this.baseModel);
    }

    private void setBackpackModelProperties(ItemStack stack) {
        BakedModel bakedModel = this.baseModel;
        if (bakedModel instanceof BackpackBlockModel.Baked) {
            BackpackBlockModel.Baked backpackModel = (BackpackBlockModel.Baked)bakedModel;
            backpackModel.tankRight = false;
            backpackModel.tankLeft = false;
            backpackModel.battery = false;
            IBackpackWrapper backpackWrapper = BackpackWrapper.fromStack(stack);
            RenderInfo renderInfo = backpackWrapper.getRenderInfo();
            Map tankRenderInfos = renderInfo.getTankRenderInfos();
            tankRenderInfos.forEach((pos, info) -> {
                if (pos == TankPosition.LEFT) {
                    backpackModel.tankLeft = true;
                    backpackModel.leftTankRenderInfo = info;
                } else {
                    backpackModel.tankRight = true;
                    backpackModel.rightTankRenderInfo = info;
                }
            });
            renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                backpackModel.battery = true;
                backpackModel.batteryRenderInfo = batteryRenderInfo;
            });
        }
    }

    public static class SpecialRenderer
    implements NoDataSpecialModelRenderer {
        private final Minecraft minecraft = Minecraft.getInstance();
        @Nullable
        public RenderInfo.DisplayItem displayItem = null;
        private int[] tintLayers;
        private BakedModel baseModel;
        private RenderType renderType;

        public void render(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int packedOverlay, boolean hasFoil) {
            ItemRenderer.renderItem((ItemDisplayContext)displayContext, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)combinedLight, (int)packedOverlay, (int[])this.tintLayers, (BakedModel)this.baseModel, (RenderType)this.renderType, (ItemStackRenderState.FoilType)(hasFoil ? ItemStackRenderState.FoilType.STANDARD : ItemStackRenderState.FoilType.NONE));
            if (this.displayItem != null) {
                poseStack.translate(0.5, 0.6, 0.25);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)this.displayItem.getRotation()));
                ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
                itemRenderer.renderStatic(this.displayItem.getItem(), ItemDisplayContext.FIXED, combinedLight, packedOverlay, poseStack, buffer, (Level)this.minecraft.level, 0);
            }
        }

        public void setModelRenderParameters(int[] tintLayers, BakedModel baseModel, RenderType renderType) {
            this.tintLayers = tintLayers;
            this.baseModel = baseModel;
            this.renderType = renderType;
        }
    }

    public record Unbaked(ResourceLocation base, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("base").forGetter(Unbaked::base), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)builder, Unbaked::new));

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            return new BackpackItemModel(bakingContext.bake(this.base), this.tints);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.resolve(this.base);
        }
    }
}

