/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper;

public class BackpackFluidHandler
implements IStorageFluidHandler {
    private final IStorageWrapper backpackWrapper;

    public BackpackFluidHandler(IStorageWrapper backpackWrapper) {
        this.backpackWrapper = backpackWrapper;
    }

    public int size() {
        return this.getAllTanks().size();
    }

    public FluidResource getResource(int index) {
        return this.isInvalidTank(index) ? FluidResource.EMPTY : this.getAllTanks().get(index).getResource();
    }

    public long getAmountAsLong(int index) {
        return this.isInvalidTank(index) ? 0L : (long)this.getAllTanks().get(index).getAmount();
    }

    private List<TankUpgradeWrapper> getAllTanks() {
        return this.backpackWrapper.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.isInvalidTank(index) || !resource.matches(this.getAllTanks().get(index).getContents()) ? 0L : (long)this.getAllTanks().get(index).getCapacity();
    }

    public boolean isValid(int index, FluidResource resource) {
        if (this.isInvalidTank(index)) {
            return false;
        }
        FluidStack contents = this.getAllTanks().get(index).getContents();
        if (contents.isEmpty()) {
            return true;
        }
        return resource.matches(contents);
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int filled = 0;
        int toFill = amount;
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            if ((filled += tank.insert(resource, toFill, tx, ignoreInOutLimit)) >= amount) {
                return amount;
            }
            toFill = amount - filled;
        }
        return filled;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int extracted = 0;
        int toExtract = amount;
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            if ((extracted += tank.extract(resource, toExtract, tx, ignoreInOutLimit)) >= amount) {
                return amount;
            }
            toExtract = amount - extracted;
        }
        return extracted;
    }

    private boolean isInvalidTank(int tank) {
        return tank < 0 || tank >= this.size();
    }
}

