/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.List;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInventoryWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.OverflowAwareInventoryHandler;

public class InventoryModificationHandler {
    private final IStorageWrapper backpackWrapper;
    private ITrackedContentsItemResourceHandler modifiedInventoryHandler;

    public InventoryModificationHandler(IStorageWrapper backpackWrapper) {
        this.backpackWrapper = backpackWrapper;
    }

    public ITrackedContentsItemResourceHandler getModifiedInventoryHandler() {
        if (this.modifiedInventoryHandler == null) {
            this.initializeWrappedInventory((ITrackedContentsItemResourceHandler)new OverflowAwareInventoryHandler(this.backpackWrapper.getInventoryHandler()));
        }
        return this.modifiedInventoryHandler;
    }

    private void initializeWrappedInventory(ITrackedContentsItemResourceHandler inventoryHandler) {
        List inventoryWrapperUpgrades = this.backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IInventoryWrapperUpgrade.class);
        ITrackedContentsItemResourceHandler wrappedHandler = inventoryHandler;
        for (IInventoryWrapperUpgrade inventoryWrapperUpgrade : inventoryWrapperUpgrades) {
            wrappedHandler = inventoryWrapperUpgrade.wrapInventory(wrappedHandler);
        }
        this.modifiedInventoryHandler = wrappedHandler;
    }
}

