/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterBlockStateModels;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplateStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.BackpackTintSources;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockEntityRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackItemModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackLayerRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.ClientBackpackContentsTooltip;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockPickPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestPlayerSettingsPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeClientTickHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeClientRegistry;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClientEventHandler {
    private static final String BACKPACK_REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"backpack"), "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ClientEventHandler::registerReloadListener);
        modBus.addListener(BackpackTintSources::register);
        modBus.addListener(ModBlockColors::registerBlockColorHandlers);
        modBus.addListener(ClientEventHandler::registerBackpackEntityRenderStateModifier);
        modBus.addListener(ClientEventHandler::registerBackpackItemModels);
        modBus.addListener(ClientEventHandler::registerBlockStateModels);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ClientBackpackContentsTooltip::onWorldLoad);
        eventBus.addListener(ClientEventHandler::handleBlockPick);
        eventBus.addListener(ClientEventHandler::onPlayerLoggingIn);
        eventBus.addListener(BackpackStorage::onClientWorldLoad);
        eventBus.addListener(ClientEventHandler::onEntityTick);
        eventBus.addListener(BackpackTemplateStorage::onClientWorldLoad);
    }

    private static void registerBlockStateModels(RegisterBlockStateModels event) {
        event.registerModel(BackpackBlockModel.UnbakedBlockStateModel.ID, BackpackBlockModel.UnbakedBlockStateModel.CODEC);
    }

    private static void registerBackpackItemModels(RegisterItemModelsEvent event) {
        event.register(SophisticatedBackpacks.getRL(BACKPACK_REG_NAME), BackpackItemModel.Unbaked.MAP_CODEC);
    }

    private static void onEntityTick(EntityTickEvent.Post event) {
        LivingEntity livingEntity;
        ItemStack chestStack;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerInventoryProvider.get().getBackpackFromRendered(player, false).ifPresent(backpackRenderData -> {
                ItemStack backpack = backpackRenderData.getBackpack();
                IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
                ClientEventHandler.clientTickUpgrades((LivingEntity)player, wrapper.getRenderDataHandler());
            });
        } else if (entity instanceof LivingEntity && (chestStack = (livingEntity = (LivingEntity)entity).getItemBySlot(EquipmentSlot.CHEST)).getItem() instanceof BackpackItem) {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(chestStack);
            ClientEventHandler.clientTickUpgrades(livingEntity, wrapper.getRenderDataHandler());
        }
    }

    private static void clientTickUpgrades(LivingEntity livingEntity, RenderDataHandler renderDataHandler) {
        if (Minecraft.getInstance().isPaused() || livingEntity.level().random.nextInt(32) != 0) {
            return;
        }
        renderDataHandler.getUpgradeClientData().forEach((type, data) -> UpgradeClientRegistry.getUpgradeClientTickHandler((UpgradeClientDataType)type).ifPresent(renderer -> ClientEventHandler.renderUpgrade(renderer, livingEntity, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(LivingEntity livingEntity, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        boolean isCrouching = livingEntity.isCrouching();
        point.rotate((Quaternionfc)Axis.XP.rotationDegrees(isCrouching ? 25.0f : 0.0f));
        point.add(0.0f, 0.8f, isCrouching ? 0.9f : 0.7f);
        point.rotate((Quaternionfc)Axis.YN.rotationDegrees(livingEntity.yBodyRot - 180.0f));
        point.add((Vector3fc)livingEntity.position().toVector3f());
        return point;
    }

    private static <T extends IUpgradeClientData> void renderUpgrade(IUpgradeClientTickHandler<T> renderer, LivingEntity livingEntity, UpgradeClientDataType<?> type, IUpgradeClientData data) {
        type.cast(data).ifPresent(clientData -> renderer.onClientTick(livingEntity.level(), livingEntity.level().random, vector3d -> ClientEventHandler.getBackpackMiddleFacePoint(livingEntity, vector3d), clientData));
    }

    private static void registerBackpackEntityRenderStateModifier(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(LivingEntityRenderer.class, BackpackLayerRenderer.RENDER_STATE_MODIFIER);
    }

    private static void onPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RequestPlayerSettingsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void onModelRegistry(ModelEvent.RegisterLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)BACKPACK_REG_NAME), (UnbakedModelLoader)BackpackBlockModel.Loader.INSTANCE);
    }

    public static void registerReloadListener(AddClientReloadListenersEvent event) {
        event.addListener(SophisticatedBackpacks.getRL("backpack_layer_registration"), (PreparableReloadListener)((ResourceManagerReloadListener)ClientEventHandler::registerBackpackLayer));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
        event.registerBlockEntityRenderer(ModBlocks.BACKPACK_TILE_TYPE.get(), BackpackBlockEntityRenderer::new);
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    private static void registerBackpackLayer(ResourceManager resourceManager) {
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        Map playerRenderers = renderManager.getPlayerRenderers();
        for (EntityRenderer renderer : playerRenderers.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            livingEntityRenderer.addLayer(new BackpackLayerRenderer(livingEntityRenderer));
        }
        renderManager.renderers.forEach((e, r) -> {
            if (r instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)r;
                livingEntityRenderer.addLayer(new BackpackLayerRenderer(livingEntityRenderer));
            }
        });
    }

    public static void handleBlockPick(InputEvent.InteractionKeyMappingTriggered event) {
        BlockPos pos;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.isCreative() || !event.isPickBlock() || mc.hitResult == null || mc.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        HitResult target = mc.hitResult;
        Level level = player.level();
        BlockState state = level.getBlockState(pos = ((BlockHitResult)target).getBlockPos());
        if (state.isAir()) {
            return;
        }
        ItemStack result = state.getCloneItemStack(pos, (LevelReader)level, true, (Player)player);
        if (result.isEmpty() || player.getInventory().findSlotMatchingItem(result) > -1) {
            return;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new BlockPickPayload(result), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

