/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.EmptyResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EmptyEnergyHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class BackpackBlockEntity
extends BlockEntity
implements IControllableStorage {
    public static final String BACKPACK_DATA = "backpackData";
    @Nullable
    private BlockPos controllerPos = null;
    private IBackpackWrapper backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
    private boolean updateBlockRender = true;
    private boolean chunkBeingUnloaded = false;
    @Nullable
    private ResourceHandler<ItemResource> externalItemHandler;
    @Nullable
    private ResourceHandler<FluidResource> externalFluidHandler;
    @Nullable
    private EnergyHandler externalEnergyHandler;
    private boolean triedUnpackingLoot = false;

    public BackpackBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.BACKPACK_TILE_TYPE.get(), pos, state);
    }

    public void setBackpack(ItemStack backpack) {
        this.backpackWrapper = BackpackWrapper.fromStack(backpack);
        this.backpackWrapper.setContentsChangeHandler(() -> {
            this.setChanged();
            this.updateBlockRender = false;
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        });
        this.backpackWrapper.setInventorySlotChangeHandler(() -> ((BackpackBlockEntity)this).setChanged());
        this.backpackWrapper.setUpgradeCachesInvalidatedHandler(this::invalidateHandlers);
    }

    public void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.setBackpackFrom(in);
        this.loadControllerPos(in);
        if (this.level != null && !this.level.isClientSide()) {
            this.removeControllerPos();
            this.tryToAddToController();
        }
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        this.registerWithControllerOnLoad();
    }

    private void setBackpackFrom(ValueInput in) {
        this.setBackpack(in.read(BACKPACK_DATA, ItemStack.CODEC).orElse(ItemStack.EMPTY));
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        this.writeBackpack(out);
        this.saveControllerPos(out);
    }

    private void writeBackpack(ValueOutput out) {
        ItemStack backpackCopy = this.backpackWrapper.getBackpack().copy();
        out.store(BACKPACK_DATA, ItemStack.CODEC, (Object)backpackCopy);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag ret = super.getUpdateTag(registries);
        return ret.merge(ValueIOHelper.collectOutputToTag((HolderLookup.Provider)registries, out -> {
            this.writeBackpack((ValueOutput)out);
            this.saveControllerPos((ValueOutput)out);
            out.putBoolean("updateBlockRender", this.updateBlockRender);
            this.updateBlockRender = true;
        }));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ValueInput in) {
        this.setBackpackFrom(in);
        if (in.getBooleanOr("updateBlockRender", false)) {
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        }
    }

    public IBackpackWrapper getBackpackWrapper() {
        return this.backpackWrapper;
    }

    private void invalidateHandlers() {
        this.invalidateCapabilities();
        this.externalItemHandler = null;
        this.externalFluidHandler = null;
        this.externalEnergyHandler = null;
        this.onInventoryInputOutputHandlerRefresh();
    }

    private boolean isBlockConnectionDisallowed(@Nullable Direction direction) {
        return direction != null && this.level != null && Config.SERVER.noConnectionBlocks.isBlockConnectionDisallowed(this.level.getBlockState(this.getBlockPos().relative(direction)).getBlock());
    }

    @Nullable
    public ResourceHandler<ItemResource> getExternalItemHandler(@Nullable Direction direction) {
        if (this.isBlockConnectionDisallowed(direction)) {
            return null;
        }
        if (this.externalItemHandler == null) {
            IBackpackWrapper backpackWrapper = this.getBackpackWrapper();
            if (!this.triedUnpackingLoot && this.level != null && !this.level.isClientSide()) {
                backpackWrapper.fillWithLootAndExtraItems(this.level, this.getBlockPos());
                this.triedUnpackingLoot = true;
            }
            this.externalItemHandler = backpackWrapper.getInventoryForInputOutput();
        }
        return this.externalItemHandler;
    }

    @Nullable
    public ResourceHandler<FluidResource> getExternalFluidHandler(@Nullable Direction direction) {
        if (this.isBlockConnectionDisallowed(direction)) {
            return null;
        }
        if (this.externalFluidHandler == null) {
            this.externalFluidHandler = this.getBackpackWrapper().getFluidHandler().map(fh -> fh).orElse((ResourceHandler)EmptyResourceHandler.instance());
        }
        return this.externalFluidHandler;
    }

    @Nullable
    public EnergyHandler getExternalEnergyHandler(@Nullable Direction direction) {
        if (this.isBlockConnectionDisallowed(direction)) {
            return null;
        }
        if (this.externalEnergyHandler == null) {
            this.externalEnergyHandler = (EnergyHandler)this.getBackpackWrapper().getEnergyHandler().orElse(EmptyEnergyHandler.INSTANCE);
        }
        return this.externalEnergyHandler;
    }

    public void refreshRenderState() {
        BlockState state = this.getBlockState();
        state = (BlockState)state.setValue((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.setValue((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(false));
        RenderDataHandler renderDataHandler = this.backpackWrapper.getRenderDataHandler();
        for (TankPosition pos : renderDataHandler.getTankRenderData().keySet()) {
            if (pos == TankPosition.LEFT) {
                state = (BlockState)state.setValue((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (pos != TankPosition.RIGHT) continue;
            state = (BlockState)state.setValue((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(true));
        }
        state = (BlockState)state.setValue((Property)BackpackBlock.BATTERY, (Comparable)Boolean.valueOf(renderDataHandler.getBatteryRenderData().isPresent()));
        Level l = Objects.requireNonNull(this.level);
        l.setBlockAndUpdate(this.worldPosition, state);
        l.updateNeighborsAt(this.worldPosition, state.getBlock());
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos blockPos, BackpackBlockEntity backpackBlockEntity) {
        if (level.isClientSide()) {
            return;
        }
        backpackBlockEntity.backpackWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public IStorageWrapper getStorageWrapper() {
        return this.backpackWrapper;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.setChanged();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.getLevel());
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void unregisterController() {
        super.unregisterController();
        this.backpackWrapper.unregisterOnSlotsChangeListener();
        this.backpackWrapper.unregisterOnInventoryHandlerRefreshListener();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        super.registerController(controllerBlockEntity);
        if (this.level != null && !this.level.isClientSide()) {
            this.backpackWrapper.registerOnSlotsChangeListener(arg_0 -> ((BackpackBlockEntity)this).changeSlots(arg_0));
            this.backpackWrapper.registerOnInventoryHandlerRefreshListener(() -> ((BackpackBlockEntity)this).registerInventoryStackListeners());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void setRemoved() {
        if (!this.chunkBeingUnloaded && this.level != null) {
            this.removeFromController();
        }
        super.setRemoved();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.removeFromController();
    }
}

