/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplate;
import org.apache.commons.io.IOUtils;

public class DatapackBackpackTemplateManager {
    private static final Map<ResourceLocation, BackpackTemplate> TEMPLATES = Maps.newTreeMap();

    private DatapackBackpackTemplateManager() {
    }

    private static void putBackpackTemplate(ResourceLocation templateName, BackpackTemplate tag) {
        TEMPLATES.put(templateName, tag);
    }

    public static Map<ResourceLocation, BackpackTemplate> getBackpackTemplates() {
        return TEMPLATES;
    }

    public static Optional<BackpackTemplate> getBackpackTemplate(ResourceLocation templateName) {
        return Optional.ofNullable(TEMPLATES.get(templateName));
    }

    public static class Loader
    extends SimplePreparableReloadListener<Map<ResourceLocation, BackpackTemplate>> {
        public static final ResourceLocation KEY = SophisticatedBackpacks.getRL("template_loader");
        public static final Loader INSTANCE = new Loader();
        private static final String DIRECTORY = "sophisticatedbackpacks_templates";
        private static final String SUFFIX = ".snbt";
        private static final int PATH_SUFFIX_LENGTH = ".snbt".length();

        private Loader() {
        }

        protected Map<ResourceLocation, BackpackTemplate> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            HashMap map = Maps.newHashMap();
            int i = DIRECTORY.length() + 1;
            resourceManager.listResources(DIRECTORY, fileName -> fileName.getPath().endsWith(SUFFIX)).forEach((resourcelocation, resource) -> {
                String s = resourcelocation.getPath();
                ResourceLocation resourceLocationWithoutSuffix = ResourceLocation.fromNamespaceAndPath((String)resourcelocation.getNamespace(), (String)s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
                try (InputStream inputstream = resource.open();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    String fileContents = IOUtils.toString((Reader)reader);
                    BackpackTemplate template = (BackpackTemplate)((Pair)BackpackTemplate.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)TagParser.parseCompoundFully((String)fileContents)).getOrThrow()).getFirst();
                    if (map.put(resourceLocationWithoutSuffix, template) != null) {
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocationWithoutSuffix));
                    }
                }
                catch (CommandSyntaxException | IOException | IllegalArgumentException ex) {
                    SophisticatedBackpacks.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceLocationWithoutSuffix, resourcelocation, (Object)ex);
                }
            });
            return map;
        }

        protected void apply(Map<ResourceLocation, BackpackTemplate> templates, ResourceManager resourceManager, ProfilerFiller profiler) {
            templates.forEach(DatapackBackpackTemplateManager::putBackpackTemplate);
        }
    }
}

