/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import org.joml.Quaternionfc;

public class BackpackModel
extends EntityModel<LivingEntityRenderState>
implements IBackpackModel {
    private static final Map<EntityType<?>, Vec3> entityTranslations = new HashMap();
    public static final MaterialMapper MAPPER = new MaterialMapper(TextureAtlas.LOCATION_BLOCKS, "entity");
    public static final Material BACKPACK_ENTITY_TEXTURE = MAPPER.apply(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"backpack"));
    public static final Material TANK_GLASS_TEXTURE = MAPPER.apply(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"tank_glass"));
    public static final float CHILD_Y_OFFSET = 0.3f;
    public static final float CHILD_Z_OFFSET = 0.1f;
    public static final float CHILD_SCALE = 0.55f;
    private static final String CLOTH_PART = "cloth";
    private static final String RIGHT_POUCHES_BORDER_PART = "rightPouchesBorder";
    private static final String LEFT_POUCHES_BORDER_PART = "leftPouchesBorder";
    private static final String FRONT_POUCH_BORDER_PART = "frontPouchBorder";
    private static final String FRONT_POUCH_PART = "frontPouch";
    private static final String RIGHT_POUCHES_PART = "rightPouches";
    private static final String LEFT_POUCHES_PART = "leftPouches";
    private static final String BORDER_PART = "border";
    private static final String FABRIC_FRONT_PART = "fabricFront";
    private static final String FABRIC_RIGHT_PART = "fabricRight";
    private static final String FABRIC_LEFT_PART = "fabricLeft";
    private static final String FABRIC_PART = "fabric";
    private static final String BATTERY_BORDER_PART = "batteryBorder";
    private static final String BATTERY_PART = "battery";
    private static final String LEFT_TANK_BORDER_PART = "leftTankBorder";
    private static final String LEFT_TANK_PART = "leftTank";
    private static final String RIGHT_TANK_BORDER_PART = "rightTankBorder";
    private static final String RIGHT_TANK_PART = "rightTank";
    private static final String BODY_CLIPS_PART = "bodyClips_";
    private static final String LEFT_POUCHES_CLIPS_PART = "leftPouchesClips_";
    private static final String RIGHT_POUCHES_CLIPS_PART = "rightPouchesClips_";
    private static final String FRONT_POUCH_CLIPS_PART = "frontPouchClips_";
    private static final String BATTERY_CLIPS_PART = "batteryClips_";
    private static final String LEFT_TANK_GLASS_PART = "leftTankGlass";
    private static final String RIGHT_TANK_GLASS_PART = "rightTankGlass";
    private static final String BATTERY_CHARGE_PART = "battery_charge_";
    private final Map<Item, ModelPart> clipsBody;
    private final Map<Item, ModelPart> clipsLeftPouches;
    private final Map<Item, ModelPart> clipsRightPouches;
    private final Map<Item, ModelPart> clipsFrontPouch;
    private final Map<Item, ModelPart> clipsBattery;
    private final Map<FluidBarCacheKey, ModelPart> fluidLevelsLeft = new HashMap<FluidBarCacheKey, ModelPart>();
    private final Map<FluidBarCacheKey, ModelPart> fluidLevelsRight = new HashMap<FluidBarCacheKey, ModelPart>();
    private final Map<Integer, ModelPart> batteryCharges;
    public final ModelPart cloth;
    private final ModelPart rightPouchesBorder;
    private final ModelPart leftPouchesBorder;
    private final ModelPart frontPouchBorder;
    private final ModelPart frontPouch;
    private final ModelPart rightPouches;
    private final ModelPart leftPouches;
    public final ModelPart border;
    private final ModelPart fabricFront;
    private final ModelPart fabricRight;
    private final ModelPart fabricLeft;
    public final ModelPart fabric;
    private final ModelPart battery;
    private final ModelPart batteryBorder;
    private final ModelPart leftTank;
    private final ModelPart leftTankBorder;
    private final ModelPart rightTank;
    private final ModelPart rightTankBorder;
    public final ModelPart leftTankGlass;
    public final ModelPart rightTankGlass;

    public BackpackModel(ModelPart part) {
        super(new ModelPart(Collections.emptyList(), Collections.emptyMap()));
        this.cloth = part.getChild(CLOTH_PART);
        this.rightPouchesBorder = part.getChild(RIGHT_POUCHES_BORDER_PART);
        this.leftPouchesBorder = part.getChild(LEFT_POUCHES_BORDER_PART);
        this.frontPouchBorder = part.getChild(FRONT_POUCH_BORDER_PART);
        this.frontPouch = part.getChild(FRONT_POUCH_PART);
        this.rightPouches = part.getChild(RIGHT_POUCHES_PART);
        this.leftPouches = part.getChild(LEFT_POUCHES_PART);
        this.border = part.getChild(BORDER_PART);
        this.fabricFront = part.getChild(FABRIC_FRONT_PART);
        this.fabricRight = part.getChild(FABRIC_RIGHT_PART);
        this.fabricLeft = part.getChild(FABRIC_LEFT_PART);
        this.fabric = part.getChild(FABRIC_PART);
        this.battery = part.getChild(BATTERY_PART);
        this.batteryBorder = part.getChild(BATTERY_BORDER_PART);
        this.leftTank = part.getChild(LEFT_TANK_PART);
        this.leftTankBorder = part.getChild(LEFT_TANK_BORDER_PART);
        this.rightTank = part.getChild(RIGHT_TANK_PART);
        this.rightTankBorder = part.getChild(RIGHT_TANK_BORDER_PART);
        ImmutableMap.Builder clipsBodyBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsLeftPouchesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsRightPouchesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsFrontPouchBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsBatteryBuilder = ImmutableMap.builder();
        BackpackModel.getBackpackItems().values().forEach(backpackItem -> {
            clipsBodyBuilder.put(backpackItem, (Object)part.getChild(BackpackModel.getTierPartName(backpackItem, BODY_CLIPS_PART)));
            clipsLeftPouchesBuilder.put(backpackItem, (Object)part.getChild(BackpackModel.getTierPartName(backpackItem, LEFT_POUCHES_CLIPS_PART)));
            clipsRightPouchesBuilder.put(backpackItem, (Object)part.getChild(BackpackModel.getTierPartName(backpackItem, RIGHT_POUCHES_CLIPS_PART)));
            clipsFrontPouchBuilder.put(backpackItem, (Object)part.getChild(BackpackModel.getTierPartName(backpackItem, FRONT_POUCH_CLIPS_PART)));
            clipsBatteryBuilder.put(backpackItem, (Object)part.getChild(BackpackModel.getTierPartName(backpackItem, BATTERY_CLIPS_PART)));
        });
        ImmutableMap.Builder batteryChargeBuilder = ImmutableMap.builder();
        for (int pixels = 1; pixels < 5; ++pixels) {
            batteryChargeBuilder.put((Object)pixels, (Object)part.getChild(BATTERY_CHARGE_PART + pixels));
        }
        this.batteryCharges = batteryChargeBuilder.build();
        this.clipsBody = clipsBodyBuilder.build();
        this.clipsLeftPouches = clipsLeftPouchesBuilder.build();
        this.clipsRightPouches = clipsRightPouchesBuilder.build();
        this.clipsFrontPouch = clipsFrontPouchBuilder.build();
        this.clipsBattery = clipsBatteryBuilder.build();
        ModelPart modelPart = this.getGlassModelPart();
        this.leftTankGlass = modelPart.getChild(LEFT_TANK_GLASS_PART);
        this.rightTankGlass = modelPart.getChild(RIGHT_TANK_GLASS_PART);
    }

    private ModelPart getGlassModelPart() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partDefinition = meshdefinition.getRoot();
        partDefinition.addOrReplaceChild(LEFT_TANK_GLASS_PART, CubeListBuilder.create().texOffs(18, 5).addBox(-15.0f, 3.5f, -2.5f, 4.0f, 10.0f, 0.01f).texOffs(0, 0).addBox(-15.0f, 3.5f, -2.5f, 0.01f, 10.0f, 5.0f).texOffs(10, 5).addBox(-15.0f, 3.5f, 2.5f, 4.0f, 10.0f, 0.01f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(RIGHT_TANK_GLASS_PART, CubeListBuilder.create().texOffs(18, 5).addBox(11.0f, 3.5f, -2.5f, 4.0f, 10.0f, 0.01f, true).texOffs(0, 0).addBox(15.0f, 3.5f, -2.5f, 0.01f, 10.0f, 5.0f, true).texOffs(10, 5).addBox(11.0f, 3.5f, 2.5f, 4.0f, 10.0f, 0.01f, true), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return partDefinition.bake(32, 32);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partDefinition = meshdefinition.getRoot();
        partDefinition.addOrReplaceChild(CLOTH_PART, CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -13.25f, -3.25f, 7.0f, 4.0f, 6.0f).texOffs(0, 10).addBox(-5.0f, -13.0f, -3.0f, 10.0f, 13.0f, 6.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(RIGHT_POUCHES_BORDER_PART, CubeListBuilder.create().texOffs(44, 0).addBox(5.0f, -2.0f, -2.5f, 2.0f, 1.0f, 5.0f, true), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(LEFT_POUCHES_BORDER_PART, CubeListBuilder.create().texOffs(44, 0).addBox(-7.0f, -2.0f, -2.5f, 2.0f, 1.0f, 5.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(FRONT_POUCH_BORDER_PART, CubeListBuilder.create().texOffs(44, 0).addBox(-4.0f, -2.0f, -5.0f, 8.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(FRONT_POUCH_PART, CubeListBuilder.create().texOffs(25, 0).addBox(-4.0f, -1.0f, -5.0f, 8.0f, 1.0f, 2.0f).texOffs(13, 2).addBox(-4.0f, -4.0f, -5.0f, 8.0f, 2.0f, 2.0f).texOffs(13, 0).addBox(-4.0f, -6.0f, -5.0f, 8.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(RIGHT_POUCHES_PART, CubeListBuilder.create().texOffs(32, 5).addBox(5.0f, -1.0f, -2.5f, 2.0f, 1.0f, 5.0f).texOffs(32, 13).addBox(5.0f, -4.0f, -2.5f, 2.0f, 2.0f, 5.0f).texOffs(32, 11).addBox(5.0f, -6.0f, -2.5f, 2.0f, 1.0f, 5.0f).texOffs(32, 22).addBox(5.0f, -9.0f, -2.5f, 1.0f, 2.0f, 5.0f).texOffs(32, 20).addBox(5.0f, -11.0f, -2.5f, 1.0f, 1.0f, 5.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(LEFT_POUCHES_PART, CubeListBuilder.create().texOffs(32, 5).addBox(-7.0f, -1.0f, -2.5f, 2.0f, 1.0f, 5.0f, true).texOffs(32, 13).addBox(-7.0f, -4.0f, -2.5f, 2.0f, 2.0f, 5.0f, true).texOffs(32, 11).addBox(-7.0f, -6.0f, -2.5f, 2.0f, 1.0f, 5.0f, true).texOffs(32, 22).addBox(-6.0f, -9.0f, -2.5f, 1.0f, 2.0f, 5.0f, true).texOffs(32, 20).addBox(-6.0f, -11.0f, -2.5f, 1.0f, 1.0f, 5.0f, true), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(BORDER_PART, CubeListBuilder.create().texOffs(44, 7).addBox(-3.5f, -9.25f, -3.25f, 7.0f, 1.0f, 1.0f).texOffs(50, 20).addBox(3.5f, -13.25f, -3.25f, 1.0f, 5.0f, 6.0f).texOffs(50, 9).addBox(-4.5f, -13.25f, -3.25f, 1.0f, 5.0f, 6.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(FABRIC_FRONT_PART, CubeListBuilder.create().texOffs(12, 58).addBox(-0.75f, 3.0f, 1.0f, 8.0f, 1.0f, 2.0f, true), PartPose.offset((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.addOrReplaceChild(FABRIC_RIGHT_PART, CubeListBuilder.create().texOffs(32, 49).addBox(8.25f, -2.0f, 3.5f, 1.0f, 1.0f, 5.0f, true).texOffs(8, 48).addBox(8.25f, 3.0f, 3.5f, 2.0f, 1.0f, 5.0f, true), PartPose.offset((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.addOrReplaceChild(FABRIC_LEFT_PART, CubeListBuilder.create().texOffs(32, 49).addBox(-2.75f, -2.0f, 3.5f, 1.0f, 1.0f, 5.0f).texOffs(8, 48).addBox(-3.75f, 3.0f, 3.5f, 2.0f, 1.0f, 5.0f), PartPose.offset((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.addOrReplaceChild(FABRIC_PART, CubeListBuilder.create().texOffs(54, 0).addBox(1.25f, -4.75f, 5.75f, 1.0f, 1.0f, 1.0f).texOffs(58, 0).addBox(4.25f, -4.75f, 5.75f, 1.0f, 1.0f, 1.0f).texOffs(44, 0).addBox(1.25f, -5.75f, 5.75f, 4.0f, 1.0f, 1.0f, true).texOffs(16, 47).addBox(0.0f, -5.5f, 2.5f, 1.0f, 4.0f, 7.0f).texOffs(0, 47).addBox(5.5f, -5.5f, 2.5f, 1.0f, 4.0f, 7.0f), PartPose.offset((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.addOrReplaceChild(BATTERY_BORDER_PART, CubeListBuilder.create().texOffs(28, 38).addBox(-4.25f, -5.25f, -6.25f, 1.0f, 1.0f, 4.0f).texOffs(28, 43).addBox(-3.5f, -5.25f, -6.25f, 7.0f, 1.0f, 1.0f).texOffs(33, 38).addBox(-4.25f, -1.25f, -6.25f, 1.0f, 1.0f, 4.0f).texOffs(33, 38).addBox(3.25f, -5.25f, -6.25f, 1.0f, 1.0f, 4.0f).texOffs(27, 45).addBox(-3.5f, -1.25f, -6.25f, 7.0f, 1.0f, 1.0f).texOffs(39, 37).addBox(3.25f, -1.25f, -6.25f, 1.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(BATTERY_PART, CubeListBuilder.create().texOffs(28, 29).addBox(-4.0f, -6.0f, -6.0f, 8.0f, 6.0f, 3.0f).texOffs(28, 53).addBox(-2.0f, -6.25f, -4.5f, 1.0f, 1.0f, 1.0f).texOffs(28, 53).addBox(-0.75f, -6.25f, -4.5f, 1.0f, 1.0f, 1.0f).texOffs(28, 53).addBox(-2.0f, -8.0f, -3.25f, 1.0f, 1.0f, 1.0f).texOffs(28, 53).addBox(-0.75f, -8.0f, -3.25f, 1.0f, 1.0f, 1.0f).texOffs(0, 58).addBox(-2.0f, -7.4f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(6, 58).addBox(-0.75f, -7.4f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(0, 61).addBox(-2.0f, -8.0f, -4.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).texOffs(6, 61).addBox(-0.75f, -8.0f, -4.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(LEFT_TANK_BORDER_PART, CubeListBuilder.create().texOffs(50, 43).addBox(-8.0f, -9.5f, -2.0f, 3.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(LEFT_TANK_PART, CubeListBuilder.create().texOffs(54, 27).addBox(-5.5f, -7.5f, -2.0f, 1.0f, 6.0f, 4.0f).texOffs(50, 37).addBox(-8.0f, -1.5f, -2.0f, 3.0f, 1.0f, 4.0f).texOffs(50, 42).addBox(-8.0f, -8.5f, -2.0f, 3.0f, 1.0f, 4.0f).texOffs(50, 37).addBox(-8.0f, -10.5f, -2.0f, 3.0f, 1.0f, 4.0f).texOffs(52, 48).addBox(-7.5f, -11.5f, -1.5f, 3.0f, 1.0f, 3.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(RIGHT_TANK_BORDER_PART, CubeListBuilder.create().texOffs(50, 43).addBox(5.0f, -9.5f, -2.0f, 3.0f, 1.0f, 4.0f, true), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(RIGHT_TANK_PART, CubeListBuilder.create().texOffs(54, 27).addBox(4.5f, -7.5f, -2.0f, 1.0f, 6.0f, 4.0f, true).texOffs(50, 37).addBox(5.0f, -1.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).texOffs(50, 42).addBox(5.0f, -8.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).texOffs(50, 37).addBox(5.0f, -10.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).texOffs(52, 48).addBox(4.5f, -11.5f, -1.5f, 3.0f, 1.0f, 3.0f, true), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        for (int pixels = 1; pixels < 5; ++pixels) {
            partDefinition.addOrReplaceChild(BATTERY_CHARGE_PART + pixels, CubeListBuilder.create().texOffs(30, 58).addBox(-2.0f, 21.0f, -6.01f, (float)pixels, 1.0f, 1.0f), PartPose.ZERO);
        }
        BackpackModel.getBackpackItems().forEach((idx, item) -> {
            BackpackModel.addBodyClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addLeftPouchesClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addRightPouchesClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addFrontPouchClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addBatteryClips(partDefinition, item, 30 + idx * 3);
        });
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static Map<Integer, Item> getBackpackItems() {
        return new LinkedHashMap<Integer, BackpackItem>(Map.of(0, ModItems.BACKPACK.get(), 1, ModItems.COPPER_BACKPACK.get(), 2, ModItems.IRON_BACKPACK.get(), 3, ModItems.GOLD_BACKPACK.get(), 4, ModItems.DIAMOND_BACKPACK.get(), 5, ModItems.NETHERITE_BACKPACK.get()));
    }

    @Override
    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, int clothColor, int borderColor, Item backpackItem, RenderDataHandler renderDataHandler) {
        RenderData.TankRenderData tankRenderData;
        Set tankPositions = renderDataHandler.getTankRenderData().keySet();
        boolean showLeftTank = tankPositions.contains(TankPosition.LEFT);
        boolean showRightTank = tankPositions.contains(TankPosition.RIGHT);
        Optional batteryRenderData = renderDataHandler.getBatteryRenderData();
        RenderType mainRenderType = BACKPACK_ENTITY_TEXTURE.renderType(RenderType::entityCutoutNoCull);
        AtlasManager atlasManager = Minecraft.getInstance().getAtlasManager();
        TextureAtlasSprite mainSprite = atlasManager.get(BACKPACK_ENTITY_TEXTURE);
        if (showLeftTank) {
            submitNodeCollector.submitModelPart(this.leftTank, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.leftTankBorder, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
        } else {
            submitNodeCollector.submitModelPart(this.fabricLeft, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.clipsLeftPouches.get(backpackItem), poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.leftPouches, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, clothColor, null);
            submitNodeCollector.submitModelPart(this.leftPouchesBorder, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, borderColor, null);
        }
        if (showRightTank) {
            submitNodeCollector.submitModelPart(this.rightTank, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.rightTankBorder, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
        } else {
            submitNodeCollector.submitModelPart(this.fabricRight, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.clipsRightPouches.get(backpackItem), poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.rightPouches, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, clothColor, null);
            submitNodeCollector.submitModelPart(this.rightPouchesBorder, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, borderColor, null);
        }
        if (batteryRenderData.isPresent()) {
            submitNodeCollector.submitModelPart(this.battery, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.batteryBorder, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, borderColor, null);
            submitNodeCollector.submitModelPart(this.clipsBattery.get(backpackItem), poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
        } else {
            submitNodeCollector.submitModelPart(this.fabricFront, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.clipsFrontPouch.get(backpackItem), poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
            submitNodeCollector.submitModelPart(this.frontPouch, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, clothColor, null);
            submitNodeCollector.submitModelPart(this.frontPouchBorder, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, borderColor, null);
        }
        submitNodeCollector.submitModelPart(this.fabric, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
        submitNodeCollector.submitModelPart(this.clipsBody.get(backpackItem), poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
        submitNodeCollector.submitModelPart(this.cloth, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, clothColor, null);
        submitNodeCollector.submitModelPart(this.border, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite, borderColor, null);
        RenderType tankGlassRenderType = TANK_GLASS_TEXTURE.renderType(RenderType::entityCutoutNoCull);
        TextureAtlasSprite tankGlassSprite = atlasManager.get(TANK_GLASS_TEXTURE);
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.6f, 0.5f);
        if (showLeftTank) {
            submitNodeCollector.submitModelPart(this.leftTankGlass, poseStack, tankGlassRenderType, packedLight, OverlayTexture.NO_OVERLAY, tankGlassSprite);
        }
        if (showRightTank) {
            submitNodeCollector.submitModelPart(this.rightTankGlass, poseStack, tankGlassRenderType, packedLight, OverlayTexture.NO_OVERLAY, tankGlassSprite);
        }
        if (showLeftTank) {
            tankRenderData = (RenderData.TankRenderData)renderDataHandler.getTankRenderData().get(TankPosition.LEFT);
            tankRenderData.getFluid().ifPresent(fluidStack -> this.submitFluid(submitNodeCollector, poseStack, (FluidStack)fluidStack, tankRenderData, true, packedLight));
        }
        if (showRightTank) {
            tankRenderData = (RenderData.TankRenderData)renderDataHandler.getTankRenderData().get(TankPosition.RIGHT);
            tankRenderData.getFluid().ifPresent(fluidStack -> this.submitFluid(submitNodeCollector, poseStack, (FluidStack)fluidStack, tankRenderData, false, packedLight));
        }
        poseStack.popPose();
        if (batteryRenderData.isPresent()) {
            batteryRenderData.ifPresent(info -> this.submitBatteryCharge(submitNodeCollector, poseStack, packedLight, info.chargeRatio()));
        }
    }

    private void submitFluid(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, FluidStack fluidStack, RenderData.TankRenderData tankRenderData, boolean left, int packedLight) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation texture = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite still = FluidSpriteCache.getSprite((ResourceLocation)texture);
        int color = renderProperties.getTintColor(fluidStack);
        this.submitFluid(submitNodeCollector, poseStack, still, tankRenderData.fillRatio(), color, left, packedLight);
    }

    @Override
    public void submitBatteryCharge(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, float chargeRatio) {
        ModelPart charge = this.batteryCharges.get((int)(chargeRatio * 4.0f));
        if (charge == null) {
            return;
        }
        RenderType mainRenderType = BACKPACK_ENTITY_TEXTURE.renderType(RenderType::entityCutoutNoCull);
        AtlasManager atlasManager = Minecraft.getInstance().getAtlasManager();
        TextureAtlasSprite mainSprite = atlasManager.get(BACKPACK_ENTITY_TEXTURE);
        submitNodeCollector.submitModelPart(charge, poseStack, mainRenderType, packedLight, OverlayTexture.NO_OVERLAY, mainSprite);
    }

    @Override
    public void submitFluid(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, TextureAtlasSprite sprite, float fill, int color, boolean left, int packedLight) {
        if (Mth.equal((float)fill, (float)0.0f)) {
            return;
        }
        ModelPart fluidBox = this.getFluidBar(sprite, (int)(fill * 10.0f), left);
        submitNodeCollector.submitModelPart(fluidBox, poseStack, RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), packedLight, OverlayTexture.NO_OVERLAY, sprite, color, null);
    }

    private ModelPart getFluidBar(TextureAtlasSprite still, int fill, boolean left) {
        int atlasWidth = (int)((float)still.contents().width() / (still.getU1() - still.getU0()));
        int atlasHeight = (int)((float)still.contents().height() / (still.getV1() - still.getV0()));
        int u = (int)(still.getU0() * (float)atlasWidth);
        int v = (int)(still.getV0() * (float)atlasHeight);
        FluidBarCacheKey key = new FluidBarCacheKey(u, v, fill);
        Map<FluidBarCacheKey, ModelPart> fluidLevels = left ? this.fluidLevelsLeft : this.fluidLevelsRight;
        return fluidLevels.computeIfAbsent(key, k -> {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partDefinition = meshdefinition.getRoot();
            partDefinition.addOrReplaceChild("fluid_fill", CubeListBuilder.create().texOffs(u, v).addBox(left ? -14.5f : 11.0f, 13.5f - (float)fill, -2.0f, 3.5f, (float)fill, 4.0f, !left), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            ModelPart root = partDefinition.bake(atlasWidth, atlasHeight);
            return root.getChild("fluid_fill");
        });
    }

    @Override
    public EquipmentSlot getRenderEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public <S extends EntityRenderState, M extends EntityModel<? super S>> void translateRotateAndScale(M parentModel, @Nullable EntityType<?> entityType, boolean isBaby, PoseStack poseStack, boolean wearsArmor) {
        if (parentModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)parentModel;
            humanoidModel.body.translateAndRotate(poseStack);
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        float zOffset = wearsArmor ? -0.35f : -0.3f;
        float yOffset = -0.75f;
        if (isBaby) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        poseStack.translate(0.0f, yOffset, zOffset);
        if (entityType == EntityType.PLAYER) {
            return;
        }
        if (isBaby) {
            poseStack.scale(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(entityType)) {
            Vec3 translVector = entityTranslations.get(entityType);
            poseStack.translate(translVector.x(), translVector.y(), translVector.z());
        }
    }

    private static void addBodyClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        BackpackModel.addBodyClips(partDefinition, backpackItem, 0, yTextureOffset);
    }

    private static void addBodyClips(PartDefinition partDefinition, Item backpackItem, int xTextureOffset, int yTextureOffset) {
        partDefinition.addOrReplaceChild(BackpackModel.getTierPartName(backpackItem, BODY_CLIPS_PART), CubeListBuilder.create().texOffs(22 + xTextureOffset, yTextureOffset).addBox(-3.25f, -9.5f, -3.5f, 1.0f, 2.0f, 1.0f).texOffs(25 + xTextureOffset, yTextureOffset).addBox(2.25f, -9.5f, -3.5f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static String getTierPartName(Item backpackItem, String partNamePrefix) {
        return partNamePrefix + BuiltInRegistries.ITEM.getKey((Object)backpackItem).getPath();
    }

    private static void addLeftPouchesClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.addOrReplaceChild(BackpackModel.getTierPartName(backpackItem, LEFT_POUCHES_CLIPS_PART), CubeListBuilder.create().texOffs(18, yTextureOffset).addBox(-6.25f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f).texOffs(6, yTextureOffset).addBox(-7.25f, -5.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addRightPouchesClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.addOrReplaceChild(BackpackModel.getTierPartName(backpackItem, RIGHT_POUCHES_CLIPS_PART), CubeListBuilder.create().texOffs(6, yTextureOffset).addBox(6.25f, -5.0f, -0.5f, 1.0f, 2.0f, 1.0f, true).texOffs(18, yTextureOffset).addBox(5.25f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addFrontPouchClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.addOrReplaceChild(BackpackModel.getTierPartName(backpackItem, FRONT_POUCH_CLIPS_PART), CubeListBuilder.create().texOffs(0, yTextureOffset).addBox(2.0f, -5.0f, -5.25f, 1.0f, 2.0f, 1.0f).texOffs(3, yTextureOffset).addBox(-3.0f, -5.0f, -5.25f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addBatteryClips(PartDefinition partDefinition, Item backpackItem, int yTextureOffset) {
        partDefinition.addOrReplaceChild(BackpackModel.getTierPartName(backpackItem, BATTERY_CLIPS_PART), CubeListBuilder.create().texOffs(24, yTextureOffset).addBox(1.0f, -5.25f, -6.15f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.2f)).texOffs(21, yTextureOffset).addBox(1.0f, -1.25f, -6.15f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
    }

    public void setupAnim(LivingEntityRenderState renderState) {
    }

    private record FluidBarCacheKey(int u, int v, int fill) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidBarCacheKey that = (FluidBarCacheKey)o;
            return this.u == that.u && this.v == that.v && this.fill == that.fill;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.u, this.v, this.fill);
        }
    }
}

