/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterType;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterAttributes;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class DepositFilterLogic
extends FilterLogic {
    private Set<ItemStackKey> inventoryFilterStacks = new HashSet<ItemStackKey>();

    public DepositFilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, DeferredHolder<DataComponentType<?>, DataComponentType<FilterAttributes>> contentsComponent) {
        super(upgrade, saveHandler, filterSlotCount, contentsComponent);
    }

    public DepositFilterType getDepositFilterType() {
        if (this.shouldFilterByInventory()) {
            return DepositFilterType.INVENTORY;
        }
        return this.isAllowList() ? DepositFilterType.ALLOW : DepositFilterType.BLOCK;
    }

    public void setDepositFilterType(DepositFilterType depositFilterType) {
        switch (depositFilterType) {
            case ALLOW: {
                this.setFilterByInventory(false);
                this.setAllowList(true);
                break;
            }
            case BLOCK: {
                this.setFilterByInventory(false);
                this.setAllowList(false);
                break;
            }
            default: {
                this.setFilterByInventory(true);
                this.save();
            }
        }
    }

    public void setInventory(ResourceHandler<ItemResource> inventory) {
        this.inventoryFilterStacks = InventoryHelper.getUniqueStacks(inventory);
    }

    protected boolean matchesFilter(Stream<TagKey<Item>> tags, Item item, int damageValue, boolean empty, DataComponentMap components) {
        if (!this.shouldFilterByInventory()) {
            return super.matchesFilter(tags, item, damageValue, empty, components);
        }
        for (ItemStackKey filterStack : this.inventoryFilterStacks) {
            if (!this.stackMatchesFilter(filterStack.stack(), item, damageValue, empty, components)) continue;
            return true;
        }
        return false;
    }

    private void setFilterByInventory(boolean filterByInventory) {
        this.upgrade.set(ModDataComponents.FILTER_BY_INVENTORY, (Object)filterByInventory);
        this.save();
    }

    private boolean shouldFilterByInventory() {
        return (Boolean)this.upgrade.getOrDefault(ModDataComponents.FILTER_BY_INVENTORY, (Object)false);
    }
}

