/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;

public class InceptionEnergyStorage
implements EnergyHandler {
    @Nullable
    private final EnergyHandler wrappedEnergyStorage;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private EnergyHandler[] energyHandlers;

    public InceptionEnergyStorage(@Nullable EnergyHandler wrappedEnergyStorage, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedEnergyStorage = wrappedEnergyStorage;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlers());
        this.refreshHandlers();
    }

    private void refreshHandlers() {
        ArrayList<EnergyHandler> storages = new ArrayList<EnergyHandler>();
        if (this.wrappedEnergyStorage != null && this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            storages.add(this.wrappedEnergyStorage);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> sbp.getEnergyHandler().ifPresent(storages::add));
        if (this.wrappedEnergyStorage != null && this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            storages.add(this.wrappedEnergyStorage);
        }
        this.energyHandlers = storages.toArray(new EnergyHandler[0]);
    }

    public int insert(int amount, TransactionContext tx) {
        int totalInserted = 0;
        for (EnergyHandler storage : this.energyHandlers) {
            if ((totalInserted += storage.insert(amount - totalInserted, tx)) == amount) break;
        }
        return totalInserted;
    }

    public int extract(int amount, TransactionContext tx) {
        int totalExtracted = 0;
        for (EnergyHandler storage : this.energyHandlers) {
            if ((totalExtracted += storage.extract(amount - totalExtracted, tx)) == amount) break;
        }
        return totalExtracted;
    }

    public long getAmountAsLong() {
        long totalEnergyStored = 0L;
        for (EnergyHandler storage : this.energyHandlers) {
            totalEnergyStored += storage.getAmountAsLong();
        }
        return totalEnergyStored;
    }

    public long getCapacityAsLong() {
        long totalMaxEnergy = 0L;
        for (EnergyHandler storage : this.energyHandlers) {
            totalMaxEnergy += storage.getCapacityAsLong();
        }
        return totalMaxEnergy;
    }
}

