/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.neoforged.neoforge.transfer.EmptyResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;

public class InceptionFluidHandler
implements IStorageFluidHandler {
    @Nullable
    private final IStorageFluidHandler wrappedFluidHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private IStorageFluidHandler[] fluidHandlers;
    protected int[] baseIndex;
    protected int tankCount;

    public InceptionFluidHandler(@Nullable IStorageFluidHandler wrappedFluidHandler, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedFluidHandler = wrappedFluidHandler;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlers());
        this.refreshHandlers();
    }

    private void refreshHandlers() {
        ArrayList<IStorageFluidHandler> handlers = new ArrayList<IStorageFluidHandler>();
        if (this.wrappedFluidHandler != null && this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            handlers.add(this.wrappedFluidHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> sbp.getFluidHandler().ifPresent(handlers::add));
        if (this.wrappedFluidHandler != null && this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            handlers.add(this.wrappedFluidHandler);
        }
        this.fluidHandlers = handlers.toArray(new IStorageFluidHandler[0]);
        this.baseIndex = new int[this.fluidHandlers.length];
        int index = 0;
        for (int i = 0; i < this.fluidHandlers.length; ++i) {
            this.baseIndex[i] = index += this.fluidHandlers[i].size();
        }
        this.tankCount = index;
    }

    public int size() {
        return this.tankCount;
    }

    private int getHandlerIndexForTank(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    protected ResourceHandler<FluidResource> getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.fluidHandlers.length) {
            return EmptyResourceHandler.instance();
        }
        return this.fluidHandlers[index];
    }

    protected int getIndexInHandler(int overallIndex, int handlerIndex) {
        if (handlerIndex <= 0 || handlerIndex >= this.baseIndex.length) {
            return overallIndex;
        }
        return overallIndex - this.baseIndex[handlerIndex - 1];
    }

    private <T> T getFluidHandlerValue(int overallTank, BiFunction<ResourceHandler<FluidResource>, Integer, T> getValue) {
        int handlerIndex = this.getHandlerIndexForTank(overallTank);
        return getValue.apply(this.getHandlerFromIndex(handlerIndex), this.getIndexInHandler(overallTank, handlerIndex));
    }

    public FluidResource getResource(int index) {
        return this.getFluidHandlerValue(index, ResourceHandler::getResource);
    }

    public long getAmountAsLong(int i) {
        return this.getFluidHandlerValue(i, ResourceHandler::getAmountAsLong);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.getFluidHandlerValue(index, (h, i) -> h.getCapacityAsLong(i.intValue(), (Resource)resource));
    }

    public boolean isValid(int i, FluidResource resource) {
        return this.getFluidHandlerValue(i, (h, t) -> h.isValid(t.intValue(), (Resource)resource));
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int handlerIndex = this.getHandlerIndexForTank(index);
        if (handlerIndex < 0 || handlerIndex >= this.fluidHandlers.length) {
            return 0;
        }
        return this.fluidHandlers[handlerIndex].insert(this.getIndexInHandler(index, handlerIndex), resource, amount, tx, ignoreInOutLimit);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int handlerIndex = this.getHandlerIndexForTank(index);
        if (handlerIndex < 0 || handlerIndex >= this.fluidHandlers.length) {
            return 0;
        }
        return this.fluidHandlers[handlerIndex].extract(this.getIndexInHandler(index, handlerIndex), resource, amount, tx, ignoreInOutLimit);
    }
}

