/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockPickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;

public class RefillUpgradeWrapper
extends UpgradeWrapperBase<RefillUpgradeWrapper, RefillUpgradeItem>
implements IFilteredUpgrade,
ITickableUpgrade,
IBlockPickResponseUpgrade {
    private static final int REFILL_RANGE = 3;
    private static final int COOLDOWN = 5;
    public static final Codec<Map<Integer, TargetSlot>> TARGET_SLOTS_CODEC = Codec.unboundedMap((Codec)CodecHelper.STRING_ENCODED_INT, TargetSlot.CODEC);
    public static final StreamCodec<FriendlyByteBuf, Map<Integer, TargetSlot>> TARGET_SLOTS_STREAM_CODEC = StreamCodecHelper.ofMap((StreamCodec)ByteBufCodecs.INT, TargetSlot.STREAM_CODEC, HashMap::new);
    private final Map<Integer, TargetSlot> targetSlots;
    private final FilterLogic filterLogic;

    public RefillUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((RefillUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
        this.targetSlots = new HashMap<Integer, TargetSlot>((Map)upgrade.getOrDefault(ModDataComponents.TARGET_SLOTS, new HashMap()));
        if (((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection()) {
            FilterLogic.ObservableFilterItemStackHandler filterHandler = this.filterLogic.getFilterHandler();
            filterHandler.setOnSlotChange(s -> this.onFilterChange(filterHandler, s));
        }
        this.filterLogic.setAllowByDefault(true);
    }

    private void onFilterChange(FilterLogic.ObservableFilterItemStackHandler filterHandler, int slot) {
        if (((ItemResource)filterHandler.getResource(slot)).isEmpty()) {
            this.targetSlots.remove(slot);
            this.saveTargetSlots();
        } else if (!this.targetSlots.containsKey(slot)) {
            this.setTargetSlot(slot, TargetSlot.ANY);
        }
    }

    public Map<Integer, TargetSlot> getTargetSlots() {
        return this.targetSlots;
    }

    public void setTargetSlot(int slot, TargetSlot targetSlot) {
        this.targetSlots.put(slot, targetSlot);
        this.saveTargetSlots();
    }

    private void saveTargetSlots() {
        this.upgrade.set(ModDataComponents.TARGET_SLOTS, (Object)ImmutableMap.copyOf(this.targetSlots));
        this.save();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        if (!(entity instanceof Player)) {
            level.getEntities((EntityTypeTest)EntityType.PLAYER, new AABB(pos).inflate(3.0), p -> true).forEach(this::refillItemFor);
        } else {
            this.refillItemFor(entity);
        }
        this.setCooldown(level, 5);
    }

    private void refillItemFor(Entity entity) {
        CapabilityHelper.runOnItemHandler((Entity)entity, playerInvHandler -> InventoryHelper.iterate((ResourceHandler)this.filterLogic.getFilterHandler(), (slot, filterResource, amount) -> {
            if (filterResource.isEmpty()) {
                return;
            }
            this.tryRefillFilter(entity, (ResourceHandler<ItemResource>)playerInvHandler, (ItemResource)filterResource, this.getTargetSlots().getOrDefault(slot, TargetSlot.ANY));
        }));
    }

    private void tryRefillFilter(@Nonnull Entity entity, ResourceHandler<ItemResource> playerInvHandler, ItemResource filter, TargetSlot targetSlot) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int missingCount = targetSlot.missingCountGetter.getMissingCount(player, playerInvHandler, filter);
        ItemStack stack = player.containerMenu.getCarried();
        if (filter.matches(stack)) {
            missingCount -= Math.min(missingCount, player.containerMenu.getCarried().getCount());
        }
        if (missingCount == 0) {
            return;
        }
        ITrackedContentsItemResourceHandler extractFromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        int extracted = InventoryHelper.simulateExtractExact((ResourceHandler)extractFromHandler, (ItemResource)filter, (int)missingCount);
        if (extracted == 0) {
            return;
        }
        int filled = targetSlot.filler.fill(player, playerInvHandler, filter, extracted);
        if (filled > 0) {
            InventoryHelper.extract((ResourceHandler)extractFromHandler, (ItemResource)filter, (int)filled);
        }
    }

    public boolean allowsTargetSlotSelection() {
        return ((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection();
    }

    @Override
    public boolean pickBlock(Player player, ItemStack filter) {
        if (!((RefillUpgradeItem)this.upgradeItem).supportsBlockPick() || filter.isEmpty()) {
            return false;
        }
        ITrackedContentsItemResourceHandler handler = this.storageWrapper.getInventoryForUpgradeProcessing();
        ItemStack handCopy = player.getMainHandItem().copy();
        try (Transaction tx = Transaction.openRoot();){
            boolean canStashHand;
            int pulled = handler.extract((Resource)ItemResource.of((ItemStack)filter), filter.getMaxStackSize(), (TransactionContext)tx);
            if (pulled <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = canStashHand = handCopy.isEmpty() || handler.insert((Resource)ItemResource.of((ItemStack)handCopy), handCopy.getCount(), (TransactionContext)tx) == handCopy.getCount();
            if (canStashHand) {
                tx.commit();
                player.setItemInHand(InteractionHand.MAIN_HAND, filter.copyWithCount(pulled));
                boolean bl2 = true;
                return bl2;
            }
            if (this.canMoveMainHandToInventory(player)) {
                tx.commit();
                if (!handCopy.isEmpty()) {
                    player.getInventory().add(handCopy);
                }
                player.setItemInHand(InteractionHand.MAIN_HAND, filter.copyWithCount(pulled));
                boolean bl3 = true;
                return bl3;
            }
            player.displayClientMessage((Component)Component.translatable((String)"gui.sophisticatedbackpacks.status.no_space_for_mainhand_item"), true);
            boolean bl4 = false;
            return bl4;
        }
    }

    private boolean canMoveMainHandToInventory(Player player) {
        ResourceHandler capability = (ResourceHandler)player.getCapability(Capabilities.Item.ENTITY);
        if (capability == null) {
            return false;
        }
        AtomicInteger countAdded = new AtomicInteger();
        return (Boolean)InventoryHelper.iterate((ResourceHandler)capability, (slot, resource, amount) -> {
            if (slot.intValue() == player.getInventory().getSelectedSlot()) {
                return false;
            }
            if (resource.isEmpty()) {
                return true;
            }
            if (resource.equals((Object)ItemResource.of((ItemStack)player.getMainHandItem()))) {
                countAdded.addAndGet(Math.min(player.getMainHandItem().getCount() - countAdded.get(), resource.getMaxStackSize() - amount));
                if (countAdded.get() >= player.getMainHandItem().getCount()) {
                    return true;
                }
            }
            return false;
        }, () -> false, returnValue -> returnValue);
    }

    public static enum TargetSlot implements StringRepresentable
    {
        ANY("any", (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any", new Object[0]), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any.tooltip", new Object[0]).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> InventoryHelper.getCountMissingInHandler((ResourceHandler)playerInvHandler, (ItemResource)filter, (int)filter.getMaxStackSize()), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillAnywhereInInventory((ResourceHandler<ItemResource>)playerInvHandler, resourceToAdd, amountToAdd)),
        MAIN_HAND("main_hand", (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand", new Object[0]), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand.tooltip", new Object[0]).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getMainHandItem(), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> ((Player)player).getMainHandItem(), resourceToAdd, amountToAdd, stack -> player.setItemInHand(InteractionHand.MAIN_HAND, stack))),
        OFF_HAND("off_hand", (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand", new Object[0]), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand.tooltip", new Object[0]).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getOffhandItem(), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> ((Player)player).getOffhandItem(), resourceToAdd, amountToAdd, stack -> player.setItemInHand(InteractionHand.OFF_HAND, stack))),
        TOOLBAR_1("toolbar_1", (Component)Component.literal((String)"1"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{1}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(0), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(0), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(0, stack))),
        TOOLBAR_2("toolbar_2", (Component)Component.literal((String)"2"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{2}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(1), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(1), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(1, stack))),
        TOOLBAR_3("toolbar_3", (Component)Component.literal((String)"3"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{3}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(2), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(2), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(2, stack))),
        TOOLBAR_4("toolbar_4", (Component)Component.literal((String)"4"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{4}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(3), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(3), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(3, stack))),
        TOOLBAR_5("toolbar_5", (Component)Component.literal((String)"5"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{5}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(4), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(4), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(4, stack))),
        TOOLBAR_6("toolbar_6", (Component)Component.literal((String)"6"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{6}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(5), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(5), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(5, stack))),
        TOOLBAR_7("toolbar_7", (Component)Component.literal((String)"7"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{7}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(6), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(6), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(6, stack))),
        TOOLBAR_8("toolbar_8", (Component)Component.literal((String)"8"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{8}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(7), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(7), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(7, stack))),
        TOOLBAR_9("toolbar_9", (Component)Component.literal((String)"9"), (Component)BackpackTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{9}).withStyle(ChatFormatting.DARK_GREEN), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.getInventory().getItem(8), filter), (player, playerInvHandler, resourceToAdd, amountToAdd) -> TargetSlot.refillSlot(() -> player.getInventory().getItem(8), resourceToAdd, amountToAdd, stack -> player.getInventory().setItem(8, stack)));

        private final String name;
        private final Component acronym;
        private final Component description;
        private final MissingCountGetter missingCountGetter;
        private final Filler filler;
        public static final Codec<TargetSlot> CODEC;
        public static final StreamCodec<FriendlyByteBuf, TargetSlot> STREAM_CODEC;
        private static final Map<String, TargetSlot> NAME_VALUES;
        private static final TargetSlot[] VALUES;

        private TargetSlot(String name, Component acronym, Component description, MissingCountGetter missingCountGetter, Filler filler) {
            this.name = name;
            this.acronym = acronym;
            this.description = description;
            this.missingCountGetter = missingCountGetter;
            this.filler = filler;
        }

        public String getSerializedName() {
            return this.name;
        }

        public TargetSlot next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public TargetSlot previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        public static TargetSlot fromName(String name) {
            return NAME_VALUES.getOrDefault(name, ANY);
        }

        public Component getAcronym() {
            return this.acronym;
        }

        public Component getDescription() {
            return this.description;
        }

        private static int refillAnywhereInInventory(ResourceHandler<ItemResource> playerInvHandler, ItemResource resourceToAdd, int amountToAdd) {
            AtomicInteger filled = new AtomicInteger(0);
            try (Transaction tx = Transaction.openRoot();){
                InventoryHelper.iterate(playerInvHandler, (slot, resource, amount) -> {
                    if (resource.equals((Object)resourceToAdd)) {
                        filled.addAndGet(playerInvHandler.insert(slot.intValue(), (Resource)resourceToAdd, amountToAdd - filled.get(), (TransactionContext)tx));
                    }
                }, () -> filled.get() >= amountToAdd);
                if (filled.get() < amountToAdd) {
                    filled.addAndGet(playerInvHandler.insert((Resource)resourceToAdd, amountToAdd - filled.get(), (TransactionContext)tx));
                }
                tx.commit();
            }
            return filled.get();
        }

        private static int getMissingCount(ItemStack stack, ItemResource filter) {
            if (filter.matches(stack)) {
                return filter.getMaxStackSize() - stack.getCount();
            }
            return filter.getMaxStackSize();
        }

        private static int refillSlot(Supplier<ItemStack> getSlotContents, ItemResource resourceToAdd, int amountToAdd, Consumer<ItemStack> setSlotContents) {
            ItemStack contents = getSlotContents.get();
            if (contents.isEmpty()) {
                setSlotContents.accept(resourceToAdd.toStack(amountToAdd));
                return amountToAdd;
            }
            if (resourceToAdd.matches(contents)) {
                contents.grow(amountToAdd);
                return amountToAdd;
            }
            return 0;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TargetSlot::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(TargetSlot.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (TargetSlot value : TargetSlot.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            NAME_VALUES = builder.build();
            VALUES = TargetSlot.values();
        }

        private static interface MissingCountGetter {
            public int getMissingCount(Player var1, ResourceHandler<ItemResource> var2, ItemResource var3);
        }

        private static interface Filler {
            public int fill(Player var1, ResourceHandler<ItemResource> var2, ItemResource var3, int var4);
        }

        private static class Constants {
            private static final String HOTBAR_TRANSL = "refill.target_slot.hotbar.tooltip";

            private Constants() {
            }
        }
    }
}

