/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockModel;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackpackItemModel
implements ItemModel {
    public static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final ItemTransforms ITEM_TRANSFORMS = BackpackItemModel.createItemTransforms();
    private final BackpackBlockModel.BlockStateModel baseModel;
    private final List<ItemTintSource> tints;
    private final Supplier<Vector3f[]> extents;

    private static ItemTransforms createItemTransforms() {
        return new ItemTransforms(new ItemTransform((Vector3fc)new Vector3f(85.0f, -90.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, -0.125f, -0.28125f), (Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(85.0f, -90.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, -0.125f, -0.28125f), (Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.890625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(30.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.078125f, 0.0f), (Vector3fc)new Vector3f(0.9f, 0.9f, 0.9f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.1875f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f), (Vector3fc)DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, -0.140625f), (Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), (Vector3fc)DEFAULT_ROTATION), ImmutableMap.of());
    }

    public BackpackItemModel(BackpackBlockModel.BlockStateModel baseModel, List<ItemTintSource> tints) {
        this.baseModel = baseModel;
        this.tints = tints;
        this.extents = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(baseModel.getQuads()));
    }

    public void update(ItemStackRenderState stackRenderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int seed) {
        stackRenderState.appendModelIdentityElement((Object)this);
        int[] tints = new int[this.tints.size()];
        for (int j = 0; j < tints.length; ++j) {
            tints[j] = this.tints.get(j).calculate(stack, clientLevel, livingEntity);
            stackRenderState.appendModelIdentityElement((Object)tints[j]);
        }
        ItemStackRenderState.LayerRenderState renderLayer = stackRenderState.newLayer();
        if (stack.hasFoil()) {
            renderLayer.setFoilType(ItemStackRenderState.FoilType.STANDARD);
            stackRenderState.appendModelIdentityElement((Object)ItemStackRenderState.FoilType.STANDARD);
        }
        int[] tintLayers = renderLayer.prepareTintLayers(tints.length);
        System.arraycopy(tints, 0, tintLayers, 0, tints.length);
        this.setBackpackModelProperties(stack, stackRenderState);
        renderLayer.setExtents(this.extents);
        renderLayer.setUsesBlockLight(true);
        renderLayer.setParticleIcon(this.baseModel.particleIcon());
        renderLayer.setTransform(ITEM_TRANSFORMS.getTransform(displayContext));
        renderLayer.prepareQuadList().addAll(this.baseModel.getQuads());
        SpecialRenderer specialRenderer = new SpecialRenderer();
        specialRenderer.setModelRenderParameters(tintLayers, this.baseModel.getQuads());
        specialRenderer.displayItem = BackpackWrapper.fromStack(stack).getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().map(displayItem -> {
            stackRenderState.appendModelIdentityElement((Object)displayItem.getItem().getItem());
            stackRenderState.appendModelIdentityElement((Object)displayItem.getItem().getComponents());
            stackRenderState.appendModelIdentityElement((Object)displayItem.getRotation());
            return displayItem;
        }).orElse(null);
        renderLayer.setupSpecialModel((SpecialModelRenderer)specialRenderer, (Object)specialRenderer.extractArgument(stack));
    }

    private void setBackpackModelProperties(ItemStack stack, ItemStackRenderState stackRenderState) {
        BackpackBlockModel.BlockStateModel blockStateModel = this.baseModel;
        if (blockStateModel instanceof BackpackBlockModel.BlockStateModel) {
            BackpackBlockModel.BlockStateModel backpackModel = blockStateModel;
            backpackModel.tankRight = false;
            backpackModel.tankLeft = false;
            backpackModel.battery = false;
            IBackpackWrapper backpackWrapper = BackpackWrapper.fromStack(stack);
            RenderInfo renderInfo = backpackWrapper.getRenderInfo();
            Map tankRenderInfos = renderInfo.getTankRenderInfos();
            tankRenderInfos.forEach((pos, info) -> {
                if (pos == TankPosition.LEFT) {
                    backpackModel.tankLeft = true;
                    backpackModel.leftTankRenderInfo = info;
                    stackRenderState.appendModelIdentityElement((Object)TankPosition.LEFT);
                    info.getFluid().ifPresent(fs -> {
                        stackRenderState.appendModelIdentityElement((Object)fs.getFluid());
                        stackRenderState.appendModelIdentityElement((Object)fs.getComponents());
                    });
                    stackRenderState.appendModelIdentityElement((Object)Float.valueOf(info.getFillRatio()));
                } else {
                    backpackModel.tankRight = true;
                    backpackModel.rightTankRenderInfo = info;
                    stackRenderState.appendModelIdentityElement((Object)TankPosition.RIGHT);
                    info.getFluid().ifPresent(fs -> {
                        stackRenderState.appendModelIdentityElement((Object)fs.getFluid());
                        stackRenderState.appendModelIdentityElement((Object)fs.getComponents());
                    });
                    stackRenderState.appendModelIdentityElement((Object)Float.valueOf(info.getFillRatio()));
                }
            });
            renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                backpackModel.battery = true;
                backpackModel.batteryRenderInfo = batteryRenderInfo;
                stackRenderState.appendModelIdentityElement((Object)"battery");
                stackRenderState.appendModelIdentityElement((Object)Float.valueOf(batteryRenderInfo.getChargeRatio()));
            });
        }
    }

    public static class SpecialRenderer
    implements NoDataSpecialModelRenderer {
        private final Minecraft minecraft = Minecraft.getInstance();
        @Nullable
        public RenderInfo.DisplayItem displayItem = null;
        private int[] tintLayers;
        private List<BakedQuad> baseModel;

        public void render(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int packedOverlay, boolean hasFoil) {
            ItemRenderer.renderItem((ItemDisplayContext)displayContext, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)combinedLight, (int)packedOverlay, (int[])this.tintLayers, this.baseModel, (RenderType)Sheets.translucentItemSheet(), (ItemStackRenderState.FoilType)(hasFoil ? ItemStackRenderState.FoilType.STANDARD : ItemStackRenderState.FoilType.NONE));
            if (this.displayItem != null) {
                poseStack.translate(0.5, 0.6, 0.25);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)this.displayItem.getRotation()));
                ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
                itemRenderer.renderStatic(this.displayItem.getItem(), ItemDisplayContext.FIXED, combinedLight, packedOverlay, poseStack, buffer, (Level)this.minecraft.level, 0);
            }
        }

        public void setModelRenderParameters(int[] tintLayers, List<BakedQuad> baseModel) {
            this.tintLayers = tintLayers;
            this.baseModel = baseModel;
        }

        public void getExtents(Set<Vector3f> set) {
        }
    }

    public record Unbaked(ResourceLocation base, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("base").forGetter(Unbaked::base), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)builder, Unbaked::new));

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ResolvedModel resolved = context.blockModelBaker().getModel(this.base);
            UnbakedModel unbakedModel = resolved.wrapped();
            if (unbakedModel instanceof BackpackBlockModel) {
                BackpackBlockModel baseModel = (BackpackBlockModel)unbakedModel;
                return new BackpackItemModel(baseModel.bakeBlockStateModel(context.blockModelBaker(), resolved, (ModelState)BlockModelRotation.X0_Y0), this.tints);
            }
            throw new IllegalStateException("Expected a BackpackBlockModel, but got " + resolved.getClass().getName());
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.base);
        }
    }
}

