/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.mojang.math.Axis;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackShapes;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeClientTickHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeClientRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.infinity.InfinityUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackpackBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty LEFT_TANK = BooleanProperty.create((String)"left_tank");
    public static final BooleanProperty RIGHT_TANK = BooleanProperty.create((String)"right_tank");
    public static final BooleanProperty BATTERY = BooleanProperty.create((String)"battery");
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final int BEDROCK_RESISTANCE = 3600000;

    public BackpackBlock(BlockBehaviour.Properties properties) {
        this(0.8f, properties);
    }

    public BackpackBlock(float explosionResistance, BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.WOOL).noOcclusion().strength(0.8f, explosionResistance).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT_TANK, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT_TANK, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).map(t -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)t.getBackpackWrapper().getInventoryForInputOutput())).orElse(0);
    }

    public FluidState getFluidState(BlockState state) {
        return Boolean.TRUE.equals(state.getValue((Property)BlockStateProperties.WATERLOGGED)) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (Boolean.TRUE.equals(state.getValue((Property)BlockStateProperties.WATERLOGGED))) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED, LEFT_TANK, RIGHT_TANK, BATTERY});
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (this.hasEverlastingUpgrade(world, pos)) {
            return 3600000.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    private boolean hasEverlastingUpgrade(BlockGetter world, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).map(be -> !be.getBackpackWrapper().getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty()).orElse(false);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BackpackShapes.getShape(this, (Direction)state.getValue(FACING), (Boolean)state.getValue((Property)LEFT_TANK), (Boolean)state.getValue((Property)RIGHT_TANK), (Boolean)state.getValue((Property)BATTERY));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BackpackBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getMainHandItem();
        if (player.isShiftKeyDown() && heldItem.isEmpty()) {
            if (BackpackBlock.hasPermissionsToPickup(player, pos)) {
                BackpackBlock.putInPlayersHandAndRemove(state, level, pos, player, InteractionHand.MAIN_HAND);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        BackpackContext.Block backpackContext = new BackpackContext.Block(pos);
        player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), this.getBackpackDisplayName(level, pos)), backpackContext::toBuffer);
        return InteractionResult.SUCCESS;
    }

    private static boolean hasPermissionsToPickup(Player player, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)player.level(), (BlockPos)pos, BackpackBlockEntity.class).map(be -> {
            if (be.getStorageWrapper().getUpgradeHandler().getTypeWrappers(InfinityUpgradeItem.TYPE).stream().anyMatch(w -> !player.hasPermissions(w.getPermissionLevel()))) {
                player.displayClientMessage((Component)BackpackTranslationHelper.INSTANCE.translStatusMessage("infinity_upgrade_only_admin_pickup", new Object[0]).withStyle(ChatFormatting.RED), true);
                return false;
            }
            return true;
        }).orElse(true);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.isEmpty() && stack.getCapability(Capabilities.FluidHandler.ITEM) instanceof IFluidHandlerItem) {
            return (InteractionResult)WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).flatMap(be -> be.getBackpackWrapper().getFluidHandler()).map(backpackFluidHandler -> (Record)CapabilityHelper.getFromItemHandler((Entity)player, playerInventory -> {
                FluidActionResult resultOfEmptying = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)backpackFluidHandler, (IItemHandler)playerInventory, (int)1000, (Player)player, (boolean)true);
                if (resultOfEmptying.isSuccess()) {
                    player.setItemInHand(hand, resultOfEmptying.getResult());
                    return InteractionResult.SUCCESS.heldItemTransformedTo(resultOfEmptying.getResult());
                }
                FluidActionResult resultOfFilling = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)backpackFluidHandler, (IItemHandler)playerInventory, (int)1000, (Player)player, (boolean)true);
                if (resultOfFilling.isSuccess()) {
                    player.setItemInHand(hand, resultOfFilling.getResult());
                    return InteractionResult.SUCCESS.heldItemTransformedTo(resultOfFilling.getResult());
                }
                return InteractionResult.PASS;
            }, (Object)InteractionResult.PASS)).orElse((Record)InteractionResult.FAIL);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private Component getBackpackDisplayName(Level level, BlockPos pos) {
        Component defaultDisplayName = new ItemStack((ItemLike)ModItems.BACKPACK.get()).getHoverName();
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).map(be -> be.getBackpackWrapper().getBackpack().getHoverName()).orElse(defaultDisplayName);
    }

    private static void putInPlayersHandAndRemove(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack backpack = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).map(be -> be.getBackpackWrapper().getBackpack()).orElse(ItemStack.EMPTY);
        BackpackBlock.stopBackpackSounds(backpack, level, pos);
        player.setItemInHand(hand, backpack.copy());
        player.getCooldowns().addCooldown(backpack, 5);
        level.removeBlock(pos, false);
        SoundType soundType = state.getSoundType();
        level.playSound(null, pos, soundType.getBreakSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState result = super.playerWillDestroy(level, pos, state, player);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(IControllableStorage::removeFromController);
        return result;
    }

    private static void stopBackpackSounds(ItemStack backpack, Level level, BlockPos pos) {
        BackpackWrapper.fromStack(backpack).getContentsUuid().ifPresent(uuid -> ServerStorageSoundHandler.stopPlayingDisc((Level)level, (Vec3)Vec3.atCenterOf((Vec3i)pos), (UUID)uuid));
    }

    public static void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.level();
        BlockPos pos = event.getPos();
        if (!player.isShiftKeyDown() || !BackpackBlock.hasEmptyMainHandAndSomethingInOffhand(player) || BackpackBlock.didntInteractWithBackpack(event)) {
            return;
        }
        if (level.isClientSide) {
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof BackpackBlock)) {
            return;
        }
        if (!BackpackBlock.hasPermissionsToPickup(player, pos)) {
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            return;
        }
        BackpackBlock.putInPlayersHandAndRemove(state, level, pos, player, player.getMainHandItem().isEmpty() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        event.setCanceled(true);
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    private static boolean didntInteractWithBackpack(PlayerInteractEvent.RightClickBlock event) {
        return !(event.getLevel().getBlockState(event.getPos()).getBlock() instanceof BackpackBlock);
    }

    private static boolean hasEmptyMainHandAndSomethingInOffhand(Player player) {
        return player.getMainHandItem().isEmpty() && !player.getOffhandItem().isEmpty();
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier) {
        super.entityInside(state, level, pos, entity, effectApplier);
        if (!level.isClientSide && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(be -> this.tryToPickup(level, itemEntity, be.getBackpackWrapper()));
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        if (this.hasEverlastingUpgrade(world, pos)) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    private void tryToPickup(Level level, ItemEntity itemEntity, IStorageWrapper w) {
        ItemStack remainingStack = itemEntity.getItem().copy();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)w.getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainingStack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return !level.isClientSide ? BackpackBlock.createTickerHelper(blockEntityType, ModBlocks.BACKPACK_TILE_TYPE.get(), (l, blockPos, blockState, backpackBlockEntity) -> BackpackBlockEntity.serverTick(l, blockPos, backpackBlockEntity)) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typePassedIn, BlockEntityType<E> typeExpected, BlockEntityTicker<? super E> blockEntityTicker) {
        return typeExpected == typePassedIn ? blockEntityTicker : null;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(be -> {
            RenderInfo renderInfo = be.getBackpackWrapper().getRenderInfo();
            BackpackBlock.renderUpgrades(level, rand, pos, (Direction)state.getValue(FACING), renderInfo);
        });
    }

    private static void renderUpgrades(Level level, RandomSource rand, BlockPos pos, Direction facing, RenderInfo renderInfo) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        renderInfo.getUpgradeClientData().forEach((type, data) -> UpgradeClientRegistry.getUpgradeClientTickHandler((UpgradeClientDataType)type).ifPresent(renderer -> BackpackBlock.clientTickUpgrade(renderer, level, rand, pos, facing, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(BlockPos pos, Direction facing, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        point.add(0.0f, 0.0f, 0.41f);
        point.rotate((Quaternionfc)Axis.YN.rotationDegrees(facing.toYRot()));
        point.add((float)pos.getX() + 0.5f, (float)pos.getY(), (float)pos.getZ() + 0.5f);
        return point;
    }

    private static <T extends IUpgradeClientData> void clientTickUpgrade(IUpgradeClientTickHandler<T> renderer, Level level, RandomSource rand, BlockPos pos, Direction facing, UpgradeClientDataType<?> type, IUpgradeClientData data) {
        type.cast(data).ifPresent(clientData -> renderer.onClientTick(level, rand, vector -> BackpackBlock.getBackpackMiddleFacePoint(pos, facing, vector), clientData));
    }
}

