/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;

public class BackpackUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public BackpackUpgradeRecipe(ShapedRecipe compose) {
        super(compose.group(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack upgradedBackpack = super.assemble(inv, registries);
        this.getBackpack(inv).map(ItemStack::getComponentsPatch).ifPresent(arg_0 -> ((ItemStack)upgradedBackpack).applyComponents(arg_0));
        IBackpackWrapper wrapper = BackpackWrapper.fromStack(upgradedBackpack);
        BackpackItem backpackItem = (BackpackItem)upgradedBackpack.getItem();
        wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBackpack(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (!(slotStack.getItem() instanceof BackpackItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<BackpackUpgradeRecipe> getSerializer() {
        return ModItems.BACKPACK_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, BackpackUpgradeRecipe> {
        public Serializer() {
            super(BackpackUpgradeRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

