/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.template.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.BackpackTintSources;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackItemModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.data.SophisticatedModelProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;

public class BackpackModelProvider
extends SophisticatedModelProvider {
    public BackpackModelProvider(PackOutput output) {
        super(output, "sophisticatedbackpacks");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        ArrayList<Item> flatItems = new ArrayList<Item>();
        this.addItemClasses(flatItems, List.of(UpgradeItemBase.class));
        flatItems.add((Item)ModItems.UPGRADE_BASE.get());
        flatItems.forEach(item -> itemModels.generateFlatItem(item, ModelTemplates.FLAT_ITEM));
        this.generateBackpackBlockModels(blockModels, itemModels);
    }

    protected void generateBackpackBlockModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        ModItems.ITEMS.getEntries().stream().filter(item -> item.get() instanceof BackpackItem).forEach(item -> {
            ResourceKey key = (ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)((Item)item.get())).orElseThrow();
            this.generateBackpackBlockAndItemModel(blockModels, itemModels, (ResourceKey<Item>)key, (BackpackItem)((Object)((Object)item.get())));
        });
    }

    private void generateBackpackBlockAndItemModel(BlockModelGenerators blockModels, ItemModelGenerators itemModels, ResourceKey<Item> key, BackpackItem item) {
        String backpackRegistryName = key.location().getPath();
        Object clips = backpackRegistryName.contains("_") ? backpackRegistryName.substring(0, backpackRegistryName.indexOf(95)) + "_clips" : "leather_clips";
        TexturedModel.Provider provider = TexturedModel.createDefault(b -> new TextureMapping(), (ModelTemplate)ExtendedModelTemplateBuilder.builder().customLoader(() -> BackpackModelProvider.lambda$generateBackpackBlockAndItemModel$4((String)clips), loader -> {}).build());
        Block block = item.getBackpackBlock();
        ResourceLocation blockModel = provider.create(block, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)blockModel)).with(BlockModelGenerators.createHorizontalFacingDispatch()));
        blockModels.itemModelOutput.accept((Item)item, (ItemModel.Unbaked)new BackpackItemModel.Unbaked(blockModel, List.of(new BackpackTintSources.Main(-3382982), new BackpackTintSources.Accent(-10342886))));
        itemModels.createFlatItemModel((Item)item, ModelTemplates.create((String)key.location().toString(), (TextureSlot[])new TextureSlot[0]));
    }

    private static /* synthetic */ BackpackLoaderBuilder lambda$generateBackpackBlockAndItemModel$4(String clips) {
        return new BackpackLoaderBuilder(clips);
    }

    private static class BackpackLoaderBuilder
    extends CustomLoaderBuilder {
        private final String clipsTexture;

        protected BackpackLoaderBuilder(String clipsTexture) {
            super(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"backpack"), false);
            this.clipsTexture = clipsTexture;
        }

        protected CustomLoaderBuilder copyInternal() {
            return new BackpackLoaderBuilder(this.clipsTexture);
        }

        public JsonObject toJson(JsonObject json) {
            json = super.toJson(json);
            json.add("clipsTexture", (JsonElement)new JsonPrimitive(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)("block/" + this.clipsTexture)).toString()));
            return json;
        }
    }
}

