/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.Iterator;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class UUIDDeduplicator {
    private UUIDDeduplicator() {
    }

    public static void checkForDuplicateBackpacksAndRemoveTheirUUID(Player player, UUID backpackUuid, ItemStack backpack) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (otherBackpack, inventoryHandlerName, identifier, slot) -> {
            if (otherBackpack != backpack) {
                IBackpackWrapper wrapper = BackpackWrapper.fromStack(otherBackpack);
                wrapper.getContentsUuid().ifPresent(uuid -> {
                    if (uuid.equals(backpackUuid)) {
                        wrapper.removeContentsUUIDTag();
                        wrapper.onContentsNbtUpdated();
                    }
                });
            }
            return false;
        });
    }

    public static void dedupeBackpackItemEntityInArea(ItemEntity newBackpackItemEntity) {
        IBackpackWrapper newBackpackWrapper = BackpackWrapper.fromStack(newBackpackItemEntity.getItem());
        newBackpackWrapper.getContentsUuid().ifPresent(backpackId -> UUIDDeduplicator.dedupeBackpackItemEntityInArea(newBackpackWrapper, newBackpackItemEntity, backpackId));
    }

    private static void dedupeBackpackItemEntityInArea(IBackpackWrapper newBackpackWrapper, ItemEntity newBackpackItemEntity, UUID backpackId) {
        ItemEntity entity;
        Iterator iterator = newBackpackItemEntity.level().getEntitiesOfClass(ItemEntity.class, newBackpackItemEntity.getBoundingBox().inflate(10.0), Entity::isAlive).iterator();
        while (iterator.hasNext() && !UUIDDeduplicator.checkEntityBackpackIdMatchAndRemoveIfItDoes(newBackpackWrapper, backpackId, entity = (ItemEntity)iterator.next())) {
        }
    }

    private static boolean checkEntityBackpackIdMatchAndRemoveIfItDoes(IBackpackWrapper newBackpackWrapper, UUID newBackpackId, ItemEntity entity) {
        return BackpackWrapper.fromStack(entity.getItem()).getContentsUuid().map(backpackId -> {
            if (backpackId.equals(newBackpackId)) {
                newBackpackWrapper.removeContentsUUIDTag();
                newBackpackWrapper.onContentsNbtUpdated();
                return true;
            }
            return false;
        }).orElse(false);
    }
}

