/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import org.joml.Quaternionfc;

public class BackpackBlockEntityRenderer
implements BlockEntityRenderer<BackpackBlockEntity> {
    public void render(BackpackBlockEntity backpackBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        IRenderedTankUpgrade.TankRenderInfo tankRenderInfo;
        BlockState state = backpackBlockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(BackpackBlock.FACING);
        boolean showLeftTank = (Boolean)state.getValue((Property)BackpackBlock.LEFT_TANK);
        boolean showRightTank = (Boolean)state.getValue((Property)BackpackBlock.RIGHT_TANK);
        boolean showBattery = (Boolean)state.getValue((Property)BackpackBlock.BATTERY);
        IBackpackWrapper backpackWrapper = backpackBlockEntity.getBackpackWrapper();
        RenderInfo renderInfo = backpackWrapper.getRenderInfo();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(facing.toYRot()));
        poseStack.pushPose();
        poseStack.scale(0.6f, 0.6f, 0.6f);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -2.5, 0.0);
        IBackpackModel model = BackpackModelManager.getBackpackModel(backpackWrapper.getBackpack().getItem());
        if (showLeftTank && (tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.LEFT)) != null) {
            poseStack.pushPose();
            poseStack.translate(1.45, 0.0, 0.0);
            tankRenderInfo.getFluid().ifPresent(fluid -> model.renderFluid(poseStack, buffer, combinedLight, (FluidStack)fluid, tankRenderInfo.getFillRatio(), true));
            poseStack.popPose();
        }
        if (showRightTank && (tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.RIGHT)) != null) {
            poseStack.pushPose();
            poseStack.translate(-1.45, 0.0, 0.0);
            tankRenderInfo.getFluid().ifPresent(fluid -> model.renderFluid(poseStack, buffer, combinedLight, (FluidStack)fluid, tankRenderInfo.getFillRatio(), false));
            poseStack.popPose();
        }
        poseStack.popPose();
        if (showBattery) {
            renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                if (batteryRenderInfo.getChargeRatio() > 0.1f) {
                    poseStack.pushPose();
                    poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(180.0f));
                    poseStack.translate(0.0, -1.5, 0.0);
                    model.renderBatteryCharge(poseStack, buffer, combinedLight, batteryRenderInfo.getChargeRatio());
                    poseStack.popPose();
                }
            });
        }
        this.renderItemDisplay(poseStack, buffer, combinedLight, combinedOverlay, renderInfo, backpackBlockEntity.getLevel());
        poseStack.popPose();
    }

    private void renderItemDisplay(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, RenderInfo renderInfo, @Nullable Level level) {
        renderInfo.getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.6, 0.25);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(180.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f + (float)displayItem.getRotation()));
            Minecraft.getInstance().getItemRenderer().renderStatic(displayItem.getItem(), ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, level, 0);
            poseStack.popPose();
        });
    }
}

