/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilteredUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    private static final String REGISTRY_NAME_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)";
    private static final String MAX_UPGRADES_MATCHER = "([a-z0-9_/.-]+\\|\\d+)";
    public static final Server SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair serverSpec = new ModConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ModConfigSpec)serverSpec.getRight();
        SERVER = (Server)serverSpec.getLeft();
        Pair commonSpec = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Server {
        public final DisallowedItems disallowedItems;
        public final NoInteractionBlocks noInteractionBlocks;
        public final NoConnectionBlocks noConnectionBlocks;
        public final BackpackConfig leatherBackpack;
        public final BackpackConfig copperBackpack;
        public final BackpackConfig ironBackpack;
        public final BackpackConfig goldBackpack;
        public final BackpackConfig diamondBackpack;
        public final BackpackConfig netheriteBackpack;
        public final FilteredUpgradeConfig compactingUpgrade;
        public final FilteredUpgradeConfig advancedCompactingUpgrade;
        public final FilteredUpgradeConfig depositUpgrade;
        public final FilteredUpgradeConfig advancedDepositUpgrade;
        public final FilteredUpgradeConfig feedingUpgrade;
        public final FilteredUpgradeConfig advancedFeedingUpgrade;
        public final FilteredUpgradeConfig filterUpgrade;
        public final FilteredUpgradeConfig advancedFilterUpgrade;
        public final MagnetUpgradeConfig magnetUpgrade;
        public final MagnetUpgradeConfig advancedMagnetUpgrade;
        public final FilteredUpgradeConfig pickupUpgrade;
        public final FilteredUpgradeConfig advancedPickupUpgrade;
        public final FilteredUpgradeConfig refillUpgrade;
        public final FilteredUpgradeConfig advancedRefillUpgrade;
        public final FilteredUpgradeConfig restockUpgrade;
        public final FilteredUpgradeConfig advancedRestockUpgrade;
        public final VoidUpgradeConfig voidUpgrade;
        public final VoidUpgradeConfig advancedVoidUpgrade;
        public final CookingUpgradeConfig smeltingUpgrade;
        public final CookingUpgradeConfig smokingUpgrade;
        public final CookingUpgradeConfig blastingUpgrade;
        public final AutoCookingUpgradeConfig autoSmeltingUpgrade;
        public final AutoCookingUpgradeConfig autoSmokingUpgrade;
        public final AutoCookingUpgradeConfig autoBlastingUpgrade;
        public final InceptionUpgradeConfig inceptionUpgrade;
        public final EntityBackpackAdditionsConfig entityBackpackAdditions;
        public final ModConfigSpec.BooleanValue itemFluidHandlerEnabled;
        public final ModConfigSpec.BooleanValue allowOpeningOtherPlayerBackpacks;
        public final ModConfigSpec.BooleanValue itemDisplayDisabled;
        public final ModConfigSpec.BooleanValue tickDedupeLogicDisabled;
        public final ModConfigSpec.BooleanValue canBePlacedInContainerItems;
        public final FilteredUpgradeConfig toolSwapperUpgrade;
        public final TankUpgradeConfig tankUpgrade;
        public final BatteryUpgradeConfig batteryUpgrade;
        public final StackUpgradeConfig stackUpgrade;
        public final PumpUpgradeConfig pumpUpgrade;
        public final XpPumpUpgradeConfig xpPumpUpgrade;
        public final JukeboxUpgradeConfig advancedJukeboxUpgrade;
        public final AlchemyUpgradeConfig alchemyUpgrade;
        public final AlchemyUpgradeConfig advancedAlchemyUpgrade;
        public final NerfsConfig nerfsConfig;
        public final MaxUgradesPerStorageConfig maxUpgradesPerStorage;

        public void initListeners(IEventBus modBus) {
            modBus.addListener(this::onConfigReload);
            modBus.addListener(this::onConfigLoad);
        }

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.clearCache();
        }

        public void onConfigLoad(ModConfigEvent.Loading event) {
            this.clearCache();
        }

        private void clearCache() {
            this.disallowedItems.initialized = false;
            this.stackUpgrade.clearNonStackableItems();
            this.maxUpgradesPerStorage.clearCache();
            this.nerfsConfig.cachedEffect = null;
        }

        Server(ModConfigSpec.Builder builder) {
            builder.comment("Server Settings").push("server");
            this.disallowedItems = new DisallowedItems(builder);
            this.noInteractionBlocks = new NoInteractionBlocks(builder);
            this.noConnectionBlocks = new NoConnectionBlocks(builder);
            this.leatherBackpack = new BackpackConfig(builder, "Leather", 27, 1);
            this.copperBackpack = new BackpackConfig(builder, "Copper", 45, 1);
            this.ironBackpack = new BackpackConfig(builder, "Iron", 54, 2);
            this.goldBackpack = new BackpackConfig(builder, "Gold", 81, 3);
            this.diamondBackpack = new BackpackConfig(builder, "Diamond", 108, 5);
            this.netheriteBackpack = new BackpackConfig(builder, "Netherite", 120, 7);
            this.compactingUpgrade = new FilteredUpgradeConfig(builder, "Compacting Upgrade", "compactingUpgrade", 9, 3);
            this.advancedCompactingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Compacting Upgrade", "advancedCompactingUpgrade", 16, 4);
            this.depositUpgrade = new FilteredUpgradeConfig(builder, "Deposit Upgrade", "depositUpgrade", 9, 3);
            this.advancedDepositUpgrade = new FilteredUpgradeConfig(builder, "Advanced Deposit Upgrade", "advancedDepositUpgrade", 16, 4);
            this.feedingUpgrade = new FilteredUpgradeConfig(builder, "Feeding Upgrade", "feedingUpgrade", 9, 3);
            this.advancedFeedingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Feeding Upgrade", "advancedFeedingUpgrade", 16, 4);
            this.filterUpgrade = new FilteredUpgradeConfig(builder, "Filter Upgrade", "filterUpgrade", 9, 3);
            this.advancedFilterUpgrade = new FilteredUpgradeConfig(builder, "Advanced Filter Upgrade", "advancedFilterUpgrade", 16, 4);
            this.magnetUpgrade = new MagnetUpgradeConfig(builder, "Magnet Upgrade", "magnetUpgrade", 9, 3, 3);
            this.advancedMagnetUpgrade = new MagnetUpgradeConfig(builder, "Advanced Magnet Upgrade", "advancedMagnetUpgrade", 16, 4, 5);
            this.pickupUpgrade = new FilteredUpgradeConfig(builder, "Pickup Upgrade", "pickupUpgrade", 9, 3);
            this.advancedPickupUpgrade = new FilteredUpgradeConfig(builder, "Advanced Pickup Upgrade", "advancedPickupUpgrade", 16, 4);
            this.refillUpgrade = new FilteredUpgradeConfig(builder, "Refill Upgrade", "refillUpgrade", 6, 3);
            this.advancedRefillUpgrade = new FilteredUpgradeConfig(builder, "Advanced Refill Upgrade", "advancedRefillUpgrade", 12, 4);
            this.restockUpgrade = new FilteredUpgradeConfig(builder, "Restock Upgrade", "restockUpgrade", 9, 3);
            this.advancedRestockUpgrade = new FilteredUpgradeConfig(builder, "Advanced Restock Upgrade", "advancedRestockUpgrade", 16, 4);
            this.voidUpgrade = new VoidUpgradeConfig(builder, "Void Upgrade", "voidUpgrade", 9, 3);
            this.advancedVoidUpgrade = new VoidUpgradeConfig(builder, "Advanced Void Upgrade", "advancedVoidUpgrade", 16, 4);
            this.stackUpgrade = new StackUpgradeConfig(builder);
            this.smeltingUpgrade = CookingUpgradeConfig.getInstance((ModConfigSpec.Builder)builder, (String)"Smelting Upgrade", (String)"smeltingUpgrade");
            this.smokingUpgrade = CookingUpgradeConfig.getInstance((ModConfigSpec.Builder)builder, (String)"Smoking Upgrade", (String)"smokingUpgrade");
            this.blastingUpgrade = CookingUpgradeConfig.getInstance((ModConfigSpec.Builder)builder, (String)"Blasting Upgrade", (String)"blastingUpgrade");
            this.autoSmeltingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smelting Upgrade", "autoSmeltingUpgrade");
            this.autoSmokingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smoking Upgrade", "autoSmokingUpgrade");
            this.autoBlastingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Blasting Upgrade", "autoBlastingUpgrade");
            this.inceptionUpgrade = new InceptionUpgradeConfig(builder);
            this.toolSwapperUpgrade = new FilteredUpgradeConfig(builder, "Tool Swapper Upgrade", "toolSwapperUpgrade", 8, 4);
            this.tankUpgrade = new TankUpgradeConfig(builder);
            this.batteryUpgrade = new BatteryUpgradeConfig(builder);
            this.pumpUpgrade = new PumpUpgradeConfig(builder);
            this.xpPumpUpgrade = new XpPumpUpgradeConfig(builder);
            this.advancedJukeboxUpgrade = new JukeboxUpgradeConfig(builder, "Advanced Jukebox Upgrade", "advancedJukeboxUpgrade", 12);
            this.alchemyUpgrade = new AlchemyUpgradeConfig(builder, "Alchemy Upgrade", "alchemyUpgrade", 4);
            this.advancedAlchemyUpgrade = new AlchemyUpgradeConfig(builder, "Advanced Alchemy Upgrade", "advancedAlchemyUpgrade", 8);
            this.entityBackpackAdditions = new EntityBackpackAdditionsConfig(builder);
            this.nerfsConfig = new NerfsConfig(builder);
            this.maxUpgradesPerStorage = new MaxUgradesPerStorageConfig(builder, Map.of(StackUpgradeItem.UPGRADE_GROUP.name(), 3, ICookingUpgrade.UPGRADE_GROUP.name(), 1, JukeboxUpgradeItem.UPGRADE_GROUP.name(), 1));
            this.itemFluidHandlerEnabled = builder.comment("Turns on/off item fluid handler of backpack in its item form. There are some dupe bugs caused by default fluid handling implementation that manifest when backpack is drained / filled in its item form in another mod's tank and the only way to prevent them is disallowing drain/fill in item form altogether").define("itemFluidHandlerEnabled", true);
            this.allowOpeningOtherPlayerBackpacks = builder.comment("Determines whether player can right click on backpack that another player is wearing to open it. If off will turn off that capability for everyone and remove related settings from backpack.").define("allowOpeningOtherPlayerBackpacks", true);
            this.itemDisplayDisabled = builder.comment("Allows disabling item display settings. Primarily in cases where custom backpack model doesn't support showing the item. (Requires game restart to take effect)").define("itemDisplayDisabled", false);
            this.tickDedupeLogicDisabled = builder.comment("Allows disabling logic that dedupes backpacks with the same UUID in players' inventory. This is here to allow turning off the logic just in case it would be causing performance issues.").define("tickDedupeLogicDisabled", false);
            this.canBePlacedInContainerItems = builder.comment("Determines if backpacks can be placed in container items (those that check for return value of canFitInsideContainerItems)").define("canBePlacedInContainerItems", false);
            builder.pop();
        }

        public static class DisallowedItems {
            private final ModConfigSpec.BooleanValue containerItemsDisallowed;
            private final ModConfigSpec.ConfigValue<List<String>> disallowedItemsList;
            private boolean initialized = false;
            private Set<Item> disallowedItemsSet = null;

            DisallowedItems(ModConfigSpec.Builder builder) {
                this.disallowedItemsList = builder.comment("List of items that are not allowed to be put in backpacks - e.g. \"minecraft:shulker_box\"").define("disallowedItems", new ArrayList());
                this.containerItemsDisallowed = builder.comment("Determines if container items (those that override canFitInsideContainerItems to false) are able to fit in backpacks").define("containerItemsDisallowed", false);
            }

            public boolean isItemDisallowed(Item item) {
                if (!SERVER_SPEC.isLoaded()) {
                    return true;
                }
                if (!this.initialized) {
                    this.loadDisallowedSet();
                }
                if (Boolean.TRUE.equals(this.containerItemsDisallowed.get()) && !(item instanceof BackpackItem) && !item.canFitInsideContainerItems()) {
                    return true;
                }
                return this.disallowedItemsSet.contains(item);
            }

            private void loadDisallowedSet() {
                this.initialized = true;
                this.disallowedItemsSet = new HashSet<Item>();
                for (String disallowedItemName : (List)this.disallowedItemsList.get()) {
                    ResourceLocation registryName = ResourceLocation.parse((String)disallowedItemName);
                    BuiltInRegistries.ITEM.getOptional(registryName).ifPresent(this.disallowedItemsSet::add);
                }
            }
        }

        public static class MaxUgradesPerStorageConfig
        implements IUpgradeCountLimitConfig {
            private final ModConfigSpec.ConfigValue<List<? extends String>> maxUpgradesPerStorageList;
            @Nullable
            private Map<String, Integer> maxUpgradesPerStorage = null;

            protected MaxUgradesPerStorageConfig(ModConfigSpec.Builder builder, Map<String, Integer> defaultUpgradesPerStorage) {
                this.maxUpgradesPerStorageList = builder.comment("Maximum number of upgrades of type per backpack in format of \"UpgradeRegistryName[or UpgradeGroup]|MaxNumber\"").defineList("maxUpgradesPerStorage", this.convertToList(defaultUpgradesPerStorage), () -> "upgrade_name|1", mapping -> ((String)mapping).matches(Config.MAX_UPGRADES_MATCHER));
            }

            private List<String> convertToList(Map<String, Integer> defaultUpgradesPerStorage) {
                return defaultUpgradesPerStorage.entrySet().stream().map(e -> (String)e.getKey() + "|" + String.valueOf(e.getValue())).collect(Collectors.toList());
            }

            public void clearCache() {
                this.maxUpgradesPerStorage = null;
            }

            public int getMaxUpgradesPerStorage(String storageType, @Nullable ResourceLocation upgradeRegistryName) {
                if (this.maxUpgradesPerStorage == null) {
                    this.initMaxUpgradesPerStorage();
                }
                if (upgradeRegistryName == null) {
                    return Integer.MAX_VALUE;
                }
                return this.maxUpgradesPerStorage.getOrDefault(upgradeRegistryName.getPath(), Integer.MAX_VALUE);
            }

            private void initMaxUpgradesPerStorage() {
                this.maxUpgradesPerStorage = new HashMap<String, Integer>();
                for (String mapping : (List)this.maxUpgradesPerStorageList.get()) {
                    String[] upgradeMax = mapping.split("\\|");
                    if (upgradeMax.length < 2) continue;
                    String name = upgradeMax[0];
                    int max = Integer.parseInt(upgradeMax[1]);
                    this.maxUpgradesPerStorage.put(name, max);
                }
            }

            public int getMaxUpgradesInGroupPerStorage(String storageType, UpgradeGroup upgradeGroup) {
                if (this.maxUpgradesPerStorage == null) {
                    this.initMaxUpgradesPerStorage();
                }
                return this.maxUpgradesPerStorage.getOrDefault(upgradeGroup.name(), Integer.MAX_VALUE);
            }
        }

        public static class NerfsConfig {
            public final ModConfigSpec.BooleanValue tooManyBackpacksSlowness;
            public final ModConfigSpec.IntValue maxNumberOfBackpacks;
            public final ModConfigSpec.DoubleValue slownessLevelsPerAdditionalBackpack;
            public final ModConfigSpec.BooleanValue onlyWornBackpackTriggersUpgrades;
            public final ModConfigSpec.ConfigValue<String> nerfEffect;
            @Nullable
            private Holder<MobEffect> cachedEffect = null;

            public NerfsConfig(ModConfigSpec.Builder builder) {
                builder.push("nerfs");
                this.tooManyBackpacksSlowness = builder.comment("Determines if too many backpacks in player's inventory cause slowness to the player").define("tooManyBackpacksSlowness", false);
                this.maxNumberOfBackpacks = builder.comment("Maximum number of backpacks in player's inventory that will not cause slowness").defineInRange("maxNumberOfBackpacks", 3, 1, 27);
                this.slownessLevelsPerAdditionalBackpack = builder.comment("Ratio of slowness levels per every backpack above the maximum number allowed. (number of backpacks above the max gets multiplied by this number and ceiled)").defineInRange("slownessLevelsPerAdditionalBackpack", 1.0, 0.1, 5.0);
                this.onlyWornBackpackTriggersUpgrades = builder.comment("Determines if active upgrades will only work in the backpack that's worn by the player. Active upgrades are for example magnet, pickup, cooking, feeding upgrades.").define("onlyWornBackpackTriggersUpgrades", false);
                this.nerfEffect = builder.comment("Effect that is applied to player when they have too many backpacks. Can be any effect including modded ones like overencumbered effect some mods have.").define("nerfEffect", (Object)"minecraft:slowness", s -> {
                    String str;
                    return s instanceof String && (str = (String)s).matches(Config.REGISTRY_NAME_MATCHER);
                });
                builder.pop();
            }

            public Holder<MobEffect> getEffect(RegistryAccess registryAccess) {
                if (this.cachedEffect == null) {
                    Registry effectRegistry = registryAccess.lookupOrThrow(Registries.MOB_EFFECT);
                    this.cachedEffect = effectRegistry.get(ResourceLocation.parse((String)((String)this.nerfEffect.get()))).map(h -> h).orElse(MobEffects.MOVEMENT_SLOWDOWN);
                }
                return this.cachedEffect;
            }
        }

        public static class NoInteractionBlocks {
            private final ModConfigSpec.ConfigValue<List<String>> noInteractionBlocksList;
            private boolean initialized = false;
            private Set<Block> noInteractionBlocksSet = null;

            NoInteractionBlocks(ModConfigSpec.Builder builder) {
                this.noInteractionBlocksList = builder.comment("List of blocks that inventory interaction upgrades can't interact with - e.g. \"minecraft:shulker_box\"").define("noInteractionBlocks", new ArrayList());
            }

            public boolean isBlockInteractionDisallowed(Block block) {
                if (!SERVER_SPEC.isLoaded()) {
                    return true;
                }
                if (!this.initialized) {
                    this.loadDisallowedSet();
                }
                return this.noInteractionBlocksSet.contains(block);
            }

            private void loadDisallowedSet() {
                this.initialized = true;
                this.noInteractionBlocksSet = new HashSet<Block>();
                for (String disallowedItemName : (List)this.noInteractionBlocksList.get()) {
                    ResourceLocation registryName = ResourceLocation.parse((String)disallowedItemName);
                    if (!BuiltInRegistries.BLOCK.containsKey(registryName)) continue;
                    this.noInteractionBlocksSet.add((Block)BuiltInRegistries.BLOCK.getValue(registryName));
                }
            }
        }

        public static class NoConnectionBlocks {
            private final ModConfigSpec.ConfigValue<List<? extends String>> noConnectionBlocksList;
            private final ModConfigSpec.BooleanValue allBlockConnectionsDisallowed;
            private boolean initialized = false;
            private Set<Block> noConnnectionBlocksSet = null;

            NoConnectionBlocks(ModConfigSpec.Builder builder) {
                this.noConnectionBlocksList = builder.comment("List of blocks that are not allowed to connect to backpacks - e.g. \"refinedstorage:external_storage\"").defineList("noConnectionBlocks", new ArrayList(), () -> "mod_id:block_name", mapping -> ((String)mapping).matches(Config.REGISTRY_NAME_MATCHER));
                this.allBlockConnectionsDisallowed = builder.comment("If true, disallows all blocks from connecting to backpacks").define("allBlockConnectionsDisallowed", false);
            }

            public boolean isBlockConnectionDisallowed(Block block) {
                if (!SERVER_SPEC.isLoaded()) {
                    return true;
                }
                if (((Boolean)this.allBlockConnectionsDisallowed.get()).booleanValue()) {
                    return true;
                }
                if (!this.initialized) {
                    this.loadDisallowedSet();
                }
                return this.noConnnectionBlocksSet.contains(block);
            }

            private void loadDisallowedSet() {
                this.initialized = true;
                this.noConnnectionBlocksSet = new HashSet<Block>();
                for (String disallowedItemName : (List)this.noConnectionBlocksList.get()) {
                    ResourceLocation registryName = ResourceLocation.parse((String)disallowedItemName);
                    if (!BuiltInRegistries.BLOCK.containsKey(registryName)) continue;
                    this.noConnnectionBlocksSet.add((Block)BuiltInRegistries.BLOCK.getValue(registryName));
                }
            }
        }

        public static class BackpackConfig {
            public final ModConfigSpec.IntValue inventorySlotCount;
            public final ModConfigSpec.IntValue upgradeSlotCount;

            public BackpackConfig(ModConfigSpec.Builder builder, String backpackPrefix, int inventorySlotCountDefault, int upgradeSlotCountDefault) {
                builder.comment(backpackPrefix + " Backpack Settings").push(backpackPrefix.toLowerCase(Locale.ENGLISH) + "Backpack");
                this.inventorySlotCount = builder.comment("Number of inventory slots in the backpack").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 144);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the backpack").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }
        }

        public static class InceptionUpgradeConfig {
            public final ModConfigSpec.BooleanValue upgradesUseInventoriesOfBackpacksInBackpack;
            public final ModConfigSpec.BooleanValue upgradesInContainedBackpacksAreFunctional;

            public InceptionUpgradeConfig(ModConfigSpec.Builder builder) {
                builder.comment("Inception Upgrade Settings").push("inceptionUpgrade");
                this.upgradesUseInventoriesOfBackpacksInBackpack = builder.comment("Allows / Disallows backpack upgrades to work with inventories of Backpacks in the Backpack with Inception Upgrade").define("upgradesUseInventoriesOfBackpacksInBackpack", true);
                this.upgradesInContainedBackpacksAreFunctional = builder.comment("Allows / Disallows upgrades to be functional even when they are in Backpacks in the inventory of Backpack with Inception Upgrade").define("upgradesInContainedBackpacksAreFunctional", true);
                builder.pop();
            }
        }

        public static class EntityBackpackAdditionsConfig {
            private static final String ENTITY_LOOT_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)\\|(null|[a-z0-9_.-]+:[a-z0-9/_.-]+)";
            public final ModConfigSpec.DoubleValue chance;
            public final ModConfigSpec.BooleanValue addLoot;
            public final ModConfigSpec.BooleanValue buffWithPotionEffects;
            public final ModConfigSpec.BooleanValue buffHealth;
            public final ModConfigSpec.BooleanValue equipWithArmor;
            public final ModConfigSpec.BooleanValue playJukebox;
            public final ModConfigSpec.BooleanValue dropToFakePlayers;
            public final ModConfigSpec.DoubleValue backpackDropChance;
            public final ModConfigSpec.DoubleValue lootingChanceIncreasePerLevel;
            public final ModConfigSpec.IntValue leatherWeight;
            public final ModConfigSpec.IntValue copperWeight;
            public final ModConfigSpec.IntValue ironWeight;
            public final ModConfigSpec.IntValue goldWeight;
            public final ModConfigSpec.IntValue diamondWeight;
            public final ModConfigSpec.IntValue netheriteWeight;
            public final ModConfigSpec.IntValue minBackpackTierMidDifficulty;
            public final ModConfigSpec.IntValue minBackpackTierHighDifficulty;
            public final ModConfigSpec.BooleanValue localDifficultyEffectsBackpackSpawns;
            public final ModConfigSpec.ConfigValue<List<? extends String>> entityLootTableList;
            public final ModConfigSpec.ConfigValue<List<? extends String>> discBlockList;
            @Nullable
            private Map<EntityType<?>, ResourceLocation> entityLootTables = null;

            public EntityBackpackAdditionsConfig(ModConfigSpec.Builder builder) {
                builder.comment("Settings for Spawning Entities with Backpack").push("entityBackpackAdditions");
                this.chance = builder.comment("Chance of an entity spawning with Backpack").defineInRange("chance", 0.01, 0.0, 1.0);
                this.addLoot = builder.comment("Turns on/off addition of loot into backpacks").define("addLoot", true);
                this.buffWithPotionEffects = builder.comment("Turns on/off buffing the entity that wears backpack with potion effects. These are scaled based on how much loot is added.").define("buffWithPotionEffects", true);
                this.buffHealth = builder.comment("Turns on/off buffing the entity that wears backpack with additional health. Health is scaled based on backpack tier the mob wears.").define("buffHealth", true);
                this.equipWithArmor = builder.comment("Turns on/off equiping the entity that wears backpack with armor. What armor material and how enchanted is scaled based on backpack tier the mob wears.").define("equipWithArmor", true);
                this.entityLootTableList = builder.comment("Map of entities that can spawn with backpack and related loot tables (if adding a loot is enabled) in format of \"EntityRegistryName|LootTableName\"").defineList("entityLootTableList", this::getDefaultEntityLootTableList, () -> "mod_id:mob_name|mod_id:loot_folder/loot_table_name", mapping -> ((String)mapping).matches(ENTITY_LOOT_MATCHER));
                this.discBlockList = builder.comment("List of music discs that are not supposed to be played by entities").defineList("discBlockList", this::getDefaultDiscBlockList, () -> "mod_id:disc_name", mapping -> ((String)mapping).matches(Config.REGISTRY_NAME_MATCHER));
                this.playJukebox = builder.comment("Turns on/off a chance that the entity that wears backpack gets jukebox upgrade and plays a music disc.").define("playJukebox", true);
                this.dropToFakePlayers = builder.comment("Determines whether backpack drops to fake players if killed by them in addition to real ones that it always drops to").define("dropToFakePlayers", false);
                this.backpackDropChance = builder.comment("Chance of mob dropping backpack when killed by player").defineInRange("backpackDropChance", 0.5, 0.0, 1.0);
                this.lootingChanceIncreasePerLevel = builder.comment("Chance increase per looting level of mob dropping backpack").defineInRange("lootingChanceIncreasePerLevel", 0.15, 0.0, 0.3);
                this.leatherWeight = builder.comment("Weight of selecting a Leather Backpack when an entity spawns with a backpack").defineInRange("leatherWeight", 625, 0, 9999);
                this.copperWeight = builder.comment("Weight of selecting a Copper Backpack when an entity spawns with a backpack").defineInRange("copperWeight", 250, 0, 9999);
                this.ironWeight = builder.comment("Weight of selecting a Iron Backpack when an entity spawns with a backpack").defineInRange("ironWeight", 125, 0, 9999);
                this.goldWeight = builder.comment("Weight of selecting a Gold Backpack when an entity spawns with a backpack").defineInRange("goldWeight", 25, 0, 9999);
                this.diamondWeight = builder.comment("Weight of selecting a Diamond Backpack when an entity spawns with a backpack").defineInRange("diamondWeight", 5, 0, 9999);
                this.netheriteWeight = builder.comment("Weight of selecting a Netherite Backpack when an entity spawns with a backpack").defineInRange("netheriteWeight", 1, 0, 9999);
                this.minBackpackTierMidDifficulty = builder.comment("Minimum tier of backpack mobs are equipped with at mid local difficulty (above 1/3 of max, 0 is leather)").defineInRange("minBackpackTierMidDifficulty", 1, 0, 6);
                this.minBackpackTierHighDifficulty = builder.comment("Minimum tier of backpack mobs are equipped with at high local difficulty (above 2/3 of max, 0 is leather)").defineInRange("minBackpackTierHighDifficulty", 2, 0, 6);
                this.localDifficultyEffectsBackpackSpawns = builder.comment("If local difficulty is taken into consideration when determining the difficulty. If local difficulty is high enough then it will use difficulty settings above").define("localDifficultyEffectsBackpackSpawns", true);
                builder.pop();
            }

            public Optional<ResourceLocation> getLootTableName(EntityType<?> entityType) {
                if (this.entityLootTables == null) {
                    this.initEntityLootTables();
                }
                return Optional.ofNullable(this.entityLootTables.get(entityType));
            }

            public boolean canWearBackpack(EntityType<?> entityType) {
                if (this.entityLootTables == null) {
                    this.initEntityLootTables();
                }
                return this.entityLootTables.containsKey(entityType);
            }

            private void initEntityLootTables() {
                this.entityLootTables = new HashMap();
                for (String mapping : (List)this.entityLootTableList.get()) {
                    String[] entityLoot = mapping.split("\\|");
                    if (entityLoot.length < 2) continue;
                    String entityRegistryName = entityLoot[0];
                    String lootTableName = entityLoot[1];
                    BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)entityRegistryName)).ifPresent(entityType -> this.entityLootTables.put((EntityType<?>)entityType, lootTableName.equals("null") ? null : ResourceLocation.parse((String)lootTableName)));
                }
            }

            private List<String> getDefaultDiscBlockList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("botania:record_gaia_1");
                ret.add("botania:record_gaia_2");
                return ret;
            }

            private List<String> getDefaultEntityLootTableList() {
                return this.getDefaultEntityLootMapping().entrySet().stream().map(e -> String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)e.getKey()))) + "|" + String.valueOf(((ResourceKey)e.getValue()).location())).collect(Collectors.toList());
            }

            private Map<EntityType<?>, ResourceKey<LootTable>> getDefaultEntityLootMapping() {
                LinkedHashMap mapping = new LinkedHashMap();
                mapping.put(EntityType.CREEPER, BuiltInLootTables.DESERT_PYRAMID);
                mapping.put(EntityType.DROWNED, BuiltInLootTables.SHIPWRECK_TREASURE);
                mapping.put(EntityType.ENDERMAN, BuiltInLootTables.END_CITY_TREASURE);
                mapping.put(EntityType.EVOKER, BuiltInLootTables.WOODLAND_MANSION);
                mapping.put(EntityType.HUSK, BuiltInLootTables.DESERT_PYRAMID);
                mapping.put(EntityType.PIGLIN, BuiltInLootTables.BASTION_BRIDGE);
                mapping.put(EntityType.PIGLIN_BRUTE, BuiltInLootTables.BASTION_TREASURE);
                mapping.put(EntityType.PILLAGER, BuiltInLootTables.PILLAGER_OUTPOST);
                mapping.put(EntityType.SKELETON, BuiltInLootTables.SIMPLE_DUNGEON);
                mapping.put(EntityType.STRAY, BuiltInLootTables.IGLOO_CHEST);
                mapping.put(EntityType.VEX, BuiltInLootTables.WOODLAND_MANSION);
                mapping.put(EntityType.VINDICATOR, BuiltInLootTables.WOODLAND_MANSION);
                mapping.put(EntityType.WITCH, BuiltInLootTables.BURIED_TREASURE);
                mapping.put(EntityType.WITHER_SKELETON, BuiltInLootTables.NETHER_BRIDGE);
                mapping.put(EntityType.ZOMBIE, BuiltInLootTables.SIMPLE_DUNGEON);
                mapping.put(EntityType.ZOMBIE_VILLAGER, BuiltInLootTables.VILLAGE_ARMORER);
                mapping.put(EntityType.ZOMBIFIED_PIGLIN, BuiltInLootTables.BASTION_OTHER);
                return mapping;
            }
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue chestLootEnabled;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.chestLootEnabled = builder.comment("Turns on/off loot added to various vanilla chest loot tables").define("chestLootEnabled", true);
            builder.pop();
        }
    }
}

