/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.crafting.ICustomSmithingRecipe;

public class SmithingBackpackUpgradeRecipe
implements ICustomSmithingRecipe {
    final Optional<Ingredient> template;
    final Optional<Ingredient> base;
    final Optional<Ingredient> addition;
    final ItemStack result;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingBackpackUpgradeRecipe(Optional<Ingredient> template, Optional<Ingredient> base, Optional<Ingredient> addition, ItemStack result) {
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(SmithingRecipeInput inv, HolderLookup.Provider registryAccess) {
        ItemStack upgradedBackpack = this.result.copy();
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            this.getBackpack(inv).map(ItemStack::getComponentsPatch).ifPresent(arg_0 -> ((ItemStack)upgradedBackpack).applyComponents(arg_0));
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(upgradedBackpack);
            BackpackItem backpackItem = (BackpackItem)upgradedBackpack.getItem();
            wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
        }
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBackpack(SmithingRecipeInput inv) {
        ItemStack slotStack = inv.getItem(1);
        if (slotStack.getItem() instanceof BackpackItem) {
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<SmithingBackpackUpgradeRecipe> getSerializer() {
        return ModItems.SMITHING_BACKPACK_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public Optional<Ingredient> templateIngredient() {
        return this.template;
    }

    public Optional<Ingredient> baseIngredient() {
        return this.base;
    }

    public Optional<Ingredient> additionIngredient() {
        return this.addition;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, this.base, this.addition));
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new SmithingRecipeDisplay(Ingredient.optionalIngredientToDisplay(this.template), Ingredient.optionalIngredientToDisplay(this.base), Ingredient.optionalIngredientToDisplay(this.addition), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    public ItemStack result() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<SmithingBackpackUpgradeRecipe> {
        private static final MapCodec<SmithingBackpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.optionalFieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(recipe -> recipe.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, SmithingBackpackUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingBackpackUpgradeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, recipe -> recipe.template, (StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, recipe -> recipe.base, (StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, recipe -> recipe.addition, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, SmithingBackpackUpgradeRecipe::new);

        public MapCodec<SmithingBackpackUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SmithingBackpackUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

