/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.BackpackMainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;

public class BackpackSettingsContainerMenu
extends SettingsContainerMenu<IBackpackWrapper>
implements IContextAwareContainer {
    private final BackpackContext backpackContext;
    private CompoundTag lastSettingsNbt = null;

    protected BackpackSettingsContainerMenu(int windowId, Player player, BackpackContext backpackContext) {
        super(ModItems.SETTINGS_CONTAINER_TYPE.get(), windowId, player, (IStorageWrapper)backpackContext.getBackpackWrapper(player));
        this.backpackContext = backpackContext;
    }

    public static BackpackSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new BackpackSettingsContainerMenu(windowId, playerInventory.player, BackpackContext.fromBuffer(buffer, playerInventory.player.level()));
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.level().isClientSide) {
            ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
                BackpackStorage storage = BackpackStorage.get();
                if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                    ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                }
            });
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.sendBackpackSettingsToClient();
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.level().isClientSide) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt().copy();
            ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt();
                if (!settingsNbt.isEmpty()) {
                    settingsContents.put("settings", (Tag)settingsNbt);
                    Player patt0$temp = this.player;
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BackpackContentsPayload((UUID)uuid, settingsContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            });
        }
    }

    @Override
    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    static {
        SettingsContainerMenu.addFactory((String)"backpackGlobal", BackpackMainSettingsContainer::new);
    }
}

