/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BackpackTemplateStorage
extends SavedData {
    private static final SavedDataType<BackpackTemplateStorage> TYPE = new SavedDataType("sophisticatedbackpacks_backpack_templates", BackpackTemplateStorage::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)CompoundTag.CODEC).fieldOf("backpackTemplates").forGetter(storage -> storage.backpackTemplates)).apply((Applicative)builder, BackpackTemplateStorage::new)));
    private static final BackpackTemplateStorage clientStorageCopy = new BackpackTemplateStorage();
    private final Map<ResourceLocation, CompoundTag> backpackTemplates = new HashMap<ResourceLocation, CompoundTag>();

    private BackpackTemplateStorage(Map<ResourceLocation, CompoundTag> backpackTemplates) {
        this.backpackTemplates.putAll(backpackTemplates);
    }

    private BackpackTemplateStorage() {
    }

    public static BackpackTemplateStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (BackpackTemplateStorage)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    public Optional<CompoundTag> getBackpackTemplate(ResourceLocation templateName) {
        return Optional.ofNullable(this.backpackTemplates.get(templateName));
    }

    public void setBackpackTemplate(ResourceLocation templateName, CompoundTag contents) {
        this.backpackTemplates.put(templateName, contents);
        this.setDirty();
    }

    public void removeBackpackTemplate(ResourceLocation templateName) {
        this.backpackTemplates.remove(templateName);
        this.setDirty();
    }

    public Map<ResourceLocation, CompoundTag> getBackpackTemplates() {
        return this.backpackTemplates;
    }

    public static void onClientWorldLoad(LevelEvent.Load evt) {
        if (evt.getLevel().isClientSide()) {
            BackpackTemplateStorage.clientStorageCopy.backpackTemplates.clear();
        }
    }
}

