/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BackpackBlockModel
implements UnbakedModel {
    private final Map<ModelPart, UnbakedModel> modelParts;

    private BackpackBlockModel(Map<ModelPart, UnbakedModel> modelParts) {
        this.modelParts = modelParts;
    }

    public BlockStateModel bakeBlockStateModel(ModelBaker baker, ResolvedModel resolvedModel, ModelState modelState) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelParts.forEach((part, model) -> builder.put((Object)part, (Object)baker.getModel(model.parent()).getTopGeometry().bake(this.getTextureSlots(baker, (UnbakedModel)model, (ModelDebugName)resolvedModel), baker, modelState, (ModelDebugName)resolvedModel, ContextMap.EMPTY)));
        return new BlockStateModel((Map<ModelPart, QuadCollection>)builder.build(), modelState, resolvedModel.resolveParticleSprite(this.getTextureSlots(baker, this.modelParts.get((Object)ModelPart.BASE), (ModelDebugName)resolvedModel), baker));
    }

    private TextureSlots getTextureSlots(ModelBaker baker, UnbakedModel partModel, ModelDebugName debugName) {
        TextureSlots.Resolver resolver = new TextureSlots.Resolver();
        resolver.addLast(partModel.textureSlots());
        ResourceLocation parent = partModel.parent();
        if (parent != null) {
            for (ResolvedModel resolvedParent = baker.getModel(parent); resolvedParent != null; resolvedParent = resolvedParent.parent()) {
                resolver.addLast(resolvedParent.wrapped().textureSlots());
            }
        }
        return resolver.resolve(debugName);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        this.modelParts.values().forEach(model -> {
            ResourceLocation parent = model.parent();
            if (parent != null) {
                resolver.markDependency(parent);
            }
            model.resolveDependencies(resolver);
        });
    }

    public static final class BlockStateModel
    implements DynamicBlockStateModel {
        private static final ResourceLocation BACKPACK_MODULES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"block/backpack_modules");
        private final Map<ModelPart, QuadCollection> models;
        private final ModelState modelState;
        private final TextureAtlasSprite particleIcon;
        public boolean tankLeft;
        @Nullable
        public IRenderedTankUpgrade.TankRenderInfo leftTankRenderInfo = null;
        public boolean tankRight;
        @Nullable
        public IRenderedTankUpgrade.TankRenderInfo rightTankRenderInfo = null;
        public boolean battery;
        @Nullable
        public IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;

        public BlockStateModel(Map<ModelPart, QuadCollection> models, ModelState modelState, TextureAtlasSprite particleIcon) {
            this.models = models;
            this.modelState = modelState;
            this.particleIcon = particleIcon;
        }

        public void collectParts(@Nullable BlockAndTintGetter level, BlockPos pos, @Nullable BlockState state, RandomSource rand, List<BlockModelPart> parts) {
            if (state != null) {
                this.tankLeft = (Boolean)state.getValue((Property)BackpackBlock.LEFT_TANK);
                this.tankRight = (Boolean)state.getValue((Property)BackpackBlock.RIGHT_TANK);
                this.battery = (Boolean)state.getValue((Property)BackpackBlock.BATTERY);
            }
            this.collectPartsNoStateUpdate(parts);
        }

        private void collectPartsNoStateUpdate(List<BlockModelPart> parts) {
            QuadCollection.Builder builder = new QuadCollection.Builder();
            builder.addAll(this.models.get((Object)ModelPart.BASE));
            this.addLeftSide(builder);
            this.addRightSide(builder);
            this.addFront(builder);
            parts.add((BlockModelPart)new SimpleModelWrapper(builder.build(), true, this.particleIcon, RenderType.CUTOUT));
        }

        private void addFront(QuadCollection.Builder builder) {
            if (this.battery) {
                if (this.batteryRenderInfo != null) {
                    this.addCharge(builder, this.batteryRenderInfo.getChargeRatio());
                }
                builder.addAll(this.models.get((Object)ModelPart.BATTERY));
            } else {
                builder.addAll(this.models.get((Object)ModelPart.FRONT_POUCH));
            }
        }

        private void addCharge(QuadCollection.Builder builder, float chargeRatio) {
            if (Mth.equal((float)chargeRatio, (float)0.0f)) {
                return;
            }
            int pixels = (int)(chargeRatio * 4.0f);
            float minX = (float)(10 - pixels) / 16.0f;
            float minY = 0.125f;
            float minZ = 0.121875f;
            float maxX = minX + (float)pixels / 16.0f;
            float maxY = minY + 0.0625f;
            float[] cols = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(BACKPACK_MODULES_TEXTURE);
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(maxX, maxY, minZ), this.getVector(maxX, minY, minZ), this.getVector(minX, minY, minZ), this.getVector(minX, maxY, minZ)), cols, sprite, Direction.NORTH, 14.0f, 14.0f + (float)pixels / 2.0f, 6.0f, 6.5f));
        }

        private void addRightSide(QuadCollection.Builder builder) {
            if (this.tankRight) {
                if (this.rightTankRenderInfo != null) {
                    this.rightTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(builder, (FluidStack)fluid, this.rightTankRenderInfo.getFillRatio(), 0.0375));
                }
                builder.addAll(this.models.get((Object)ModelPart.RIGHT_TANK));
            } else {
                builder.addAll(this.models.get((Object)ModelPart.RIGHT_POUCH));
            }
        }

        private void addLeftSide(QuadCollection.Builder builder) {
            if (this.tankLeft) {
                if (this.leftTankRenderInfo != null) {
                    this.leftTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(builder, (FluidStack)fluid, this.leftTankRenderInfo.getFillRatio(), 0.803125));
                }
                builder.addAll(this.models.get((Object)ModelPart.LEFT_TANK));
            } else {
                builder.addAll(this.models.get((Object)ModelPart.LEFT_POUCH));
            }
        }

        private void addFluid(QuadCollection.Builder builder, FluidStack fluidStack, float ratio, double xMin) {
            if (fluidStack == FluidStack.EMPTY || Mth.equal((float)ratio, (float)0.0f)) {
                return;
            }
            double yMin = 0.09375;
            double yMax = yMin + (double)(ratio * 6.0f) / 16.0;
            AABB bounds = new AABB(xMin, yMin, 0.421875, xMin + 0.15625, yMax, 0.578125);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation texture = renderProperties.getStillTexture(fluidStack);
            int color = renderProperties.getTintColor(fluidStack);
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
            float bx1 = 0.0f;
            float bx2 = 5.0f;
            float by1 = 0.0f;
            float by2 = ratio * 10.0f;
            float bz1 = 0.0f;
            float bz2 = 5.0f;
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.minZ), this.getVector(bounds.minX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.minZ)), cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.maxX, bounds.maxY, bounds.minZ), this.getVector(bounds.maxX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.maxY, bounds.minZ)), cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.maxZ), this.getVector(bounds.minX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ)), cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.maxZ), this.getVector(bounds.minX, bounds.maxY, bounds.maxZ)), cols, still, Direction.WEST, bz1, bz2, by1, by2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.minZ), this.getVector(bounds.maxX, bounds.maxY, bounds.minZ)), cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelState.transformation().getMatrix());
            return ret;
        }

        private BakedQuad createQuad(List<Vector3f> vecs, float[] colors, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
            QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer();
            quadBaker.setSprite(sprite);
            Vec3i dirVec = face.getUnitVec3i();
            quadBaker.setDirection(face);
            quadBaker.setTintIndex(-1);
            u1 = sprite.getU0() + u1 / 4.0f * sprite.uvShrinkRatio();
            u2 = sprite.getU0() + u2 / 4.0f * sprite.uvShrinkRatio();
            v1 = sprite.getV0() + v1 / 4.0f * sprite.uvShrinkRatio();
            v2 = sprite.getV0() + v2 / 4.0f * sprite.uvShrinkRatio();
            quadBaker.addVertex(vecs.get(0).x(), vecs.get(0).y(), vecs.get(0).z()).setColor(colors[1], colors[2], colors[3], colors[0]).setUv(u1, v1).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vecs.get(1).x(), vecs.get(1).y(), vecs.get(1).z()).setColor(colors[1], colors[2], colors[3], colors[0]).setUv(u1, v2).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vecs.get(2).x(), vecs.get(2).y(), vecs.get(2).z()).setColor(colors[1], colors[2], colors[3], colors[0]).setUv(u2, v2).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vecs.get(3).x(), vecs.get(3).y(), vecs.get(3).z()).setColor(colors[1], colors[2], colors[3], colors[0]).setUv(u2, v1).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            return quadBaker.bakeQuad();
        }

        private void rotate(Vector3f posIn, Matrix4fc transform) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0f));
            posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
        }

        public TextureAtlasSprite particleIcon() {
            return this.particleIcon;
        }

        public List<BakedQuad> getQuads() {
            ArrayList<BlockModelPart> parts = new ArrayList<BlockModelPart>();
            this.collectPartsNoStateUpdate(parts);
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
            for (BlockModelPart part : parts) {
                for (Direction dir : Direction.values()) {
                    bakedQuads.addAll(part.getQuads(dir));
                }
                bakedQuads.addAll(part.getQuads(null));
            }
            return bakedQuads;
        }
    }

    public static enum ModelPart {
        BASE,
        BATTERY,
        FRONT_POUCH,
        LEFT_POUCH,
        LEFT_TANK,
        RIGHT_POUCH,
        RIGHT_TANK;

    }

    public static final class Loader
    implements UnbakedModelLoader<BackpackBlockModel> {
        public static final Loader INSTANCE = new Loader();

        public BackpackBlockModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ResourceLocation clipsTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TextureSlots.Data.Builder texturesBuilder = new TextureSlots.Data.Builder();
            if (modelContents.has("clipsTexture") && (clipsTexture = ResourceLocation.tryParse((String)modelContents.get("clipsTexture").getAsString())) != null) {
                texturesBuilder.addTexture("clips", new Material(TextureAtlas.LOCATION_BLOCKS, clipsTexture));
            }
            for (ModelPart part : ModelPart.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelPart, UnbakedModel>)builder, part, texturesBuilder.build());
            }
            return new BackpackBlockModel((Map<ModelPart, UnbakedModel>)builder.build());
        }

        private void addPartModel(ImmutableMap.Builder<ModelPart, UnbakedModel> builder, ModelPart modelPart, TextureSlots.Data textures) {
            builder.put((Object)modelPart, (Object)new BlockModel(null, null, Boolean.valueOf(true), ItemTransforms.NO_TRANSFORMS, textures, SophisticatedBackpacks.getRL("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH))));
        }
    }

    public record UnbakedBlockStateModel(Variant variant) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<UnbakedBlockStateModel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Variant.MAP_CODEC.forGetter(UnbakedBlockStateModel::variant)).apply((Applicative)instance, UnbakedBlockStateModel::new));
        public static final ResourceLocation ID = SophisticatedBackpacks.getRL("backpack_model_loader");

        public BlockStateModel bake(ModelBaker modelBaker) {
            ResolvedModel resolvedModel = modelBaker.getModel(this.variant.modelLocation());
            UnbakedModel unbakedModel = resolvedModel.wrapped();
            if (unbakedModel instanceof BackpackBlockModel) {
                BackpackBlockModel model = (BackpackBlockModel)unbakedModel;
                return model.bakeBlockStateModel(modelBaker, resolvedModel, this.variant.modelState().asModelState());
            }
            throw new IllegalStateException("Expected BackpackBlockModel, but got " + resolvedModel.wrapped().getClass().getName());
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.variant.modelLocation());
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }
}

