/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplates;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackItemArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackTemplateArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackUpgradeItemArgumentType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class DynamicCommand {
    static final Cache<String, DynamicTemplate> DYNAMIC_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext commandBuildContext) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dynamic").then(Commands.literal((String)"begin").then(((RequiredArgumentBuilder)Commands.argument((String)"templateName", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"backpackItem", (ArgumentType)BackpackItemArgumentType.item(commandBuildContext)).executes(context -> DynamicCommand.beginNewDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), BackpackItemArgumentType.getItem((CommandContext)context, (String)"backpackItem"))))).then(Commands.argument((String)"baseTemplateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> DynamicCommand.beginBasedDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "baseTemplateName"))))))).then(Commands.literal((String)"addItem").then(((RequiredArgumentBuilder)Commands.argument((String)"templateName", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)commandBuildContext)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), ItemArgument.getItem((CommandContext)context, (String)"item"), 1, false))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), ItemArgument.getItem((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), false)))))).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)commandBuildContext)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), -1, ItemArgument.getItem((CommandContext)context, (String)"item"), 1, false))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), -1, ItemArgument.getItem((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), false))))))).then(Commands.literal((String)"addUpgrade").then(Commands.argument((String)"templateName", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"item", (ArgumentType)BackpackUpgradeItemArgumentType.item(commandBuildContext)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), -1, ItemArgument.getItem((CommandContext)context, (String)"item"), 1, true)))))).then(Commands.literal((String)"end").then(Commands.argument((String)"templateName", (ArgumentType)StringArgumentType.word()).executes(context -> DynamicCommand.endDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class)))));
    }

    private static int beginNewDynamic(CommandSourceStack source, String templateName, ItemInput backpackItem) throws CommandSyntaxException {
        if (DYNAMIC_CACHE.asMap().containsKey(templateName)) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.templateInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        ItemStack backpack = backpackItem.createItemStack(1, false);
        DYNAMIC_CACHE.put((Object)templateName, (Object)new DynamicTemplate(backpack, new ArrayList<ItemStack>(), new ArrayList<ItemStack>()));
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.begin.success", (Object[])new Object[]{templateName}), false);
        return 0;
    }

    private static int beginBasedDynamic(CommandSourceStack source, String templateName, ResourceLocation baseTemplateName) {
        if (DYNAMIC_CACHE.getIfPresent((Object)templateName) != null) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.templateInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        Optional<CompoundTag> templateData = BackpackTemplates.getBackpackTemplate(baseTemplateName);
        if (templateData.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.begin.noBaseTemplate", (Object[])new Object[]{baseTemplateName.toString()}));
            return 1;
        }
        ItemStack backpack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue((ResourceLocation)templateData.get().getString("backpackItemRegistryName").map(ResourceLocation::parse).orElse(null)));
        IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
        wrapper.setTemplate(baseTemplateName);
        wrapper.fillFromTemplate();
        DYNAMIC_CACHE.put((Object)templateName, (Object)new DynamicTemplate(backpack, new ArrayList<ItemStack>(), new ArrayList<ItemStack>()));
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.begin.success", (Object[])new Object[]{templateName}), false);
        return 0;
    }

    private static int addDynamic(CommandSourceStack source, String templateName, int slot, ItemInput item, int count, boolean upgrade) throws CommandSyntaxException {
        DynamicTemplate template = (DynamicTemplate)DYNAMIC_CACHE.getIfPresent((Object)templateName);
        if (template == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.templateNotInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        ItemStack stack = item.createItemStack(count, true);
        if (slot == -1) {
            if (upgrade) {
                template.itemsForUpgradeHandler.add(stack);
            } else {
                template.itemsForInventoryHandler.add(stack);
            }
        } else {
            UpgradeHandler inventory;
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(template.backpack);
            Object object = inventory = upgrade ? wrapper.getUpgradeHandler() : wrapper.getInventoryHandler();
            if (!inventory.getStackInSlot(slot).isEmpty()) {
                template.itemsForInventoryHandler.add(stack);
            } else {
                inventory.setStackInSlot(slot, stack);
                source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.add.success", (Object[])new Object[]{templateName, stack.getDisplayName()}), false);
                return 0;
            }
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.add.delayed", (Object[])new Object[]{templateName, stack.getDisplayName()}), false);
        return 0;
    }

    private static int endDynamic(CommandSourceStack source, String templateName) {
        Optional backpackUuid;
        DynamicTemplate template = (DynamicTemplate)DYNAMIC_CACHE.getIfPresent((Object)templateName);
        if (template == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.templateNotInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        IBackpackWrapper wrapper = BackpackWrapper.fromStack(template.backpack);
        ArrayList remainings = new ArrayList();
        remainings.addAll(InventoryHelper.insertIntoInventory(template.itemsForInventoryHandler, (IItemHandler)wrapper.getInventoryHandler(), (boolean)false));
        remainings.addAll(InventoryHelper.insertIntoInventory(template.itemsForUpgradeHandler, (IItemHandler)wrapper.getUpgradeHandler(), (boolean)false));
        if (!remainings.isEmpty()) {
            for (ItemStack remaining : remainings) {
                source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.end.addRemainingItemsFailed", (Object[])new Object[]{remaining.getCount(), remaining.getDisplayName()}));
            }
        }
        if ((backpackUuid = wrapper.getContentsUuid()).isEmpty() || InventoryHelper.isEmpty((IItemHandler)wrapper.getInventoryHandler()) && InventoryHelper.isEmpty((IItemHandler)wrapper.getUpgradeHandler())) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.backpackempty"));
            return 3;
        }
        if (source.isPlayer()) {
            DynamicCommand.giveBackpackToPlayer(template.backpack(), source.getPlayer());
        } else if (source.getEntity() != null) {
            DynamicCommand.dropBackpackToPosition(template.backpack(), source.getLevel(), source.getEntity().position());
        } else {
            DynamicCommand.dropBackpackToPosition(template.backpack(), source.getLevel(), source.getPosition());
        }
        DYNAMIC_CACHE.invalidate((Object)templateName);
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.dynamic.end.success", (Object[])new Object[]{templateName}), false);
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayer p) {
        ItemEntity itemEntity;
        boolean flag = p.getInventory().add(backpack);
        if (flag && backpack.isEmpty()) {
            backpack.setCount(1);
            itemEntity = p.drop(backpack, false);
            if (itemEntity != null) {
                itemEntity.makeFakeItem();
            }
            p.level().playSound(null, p.getX(), p.getY(), p.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)p.getRandom()) * 0.7f + 1.0f) * 2.0f);
            p.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity itementity = p.drop(backpack, false);
            if (itementity != null) {
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)p);
            }
        }
        itemEntity = p.drop(backpack, false);
        if (itemEntity != null) {
            itemEntity.makeFakeItem();
        }
    }

    private static void dropBackpackToPosition(ItemStack backpack, ServerLevel level, Vec3 pos) {
        ItemEntity itemEntity = new ItemEntity((Level)level, pos.x, pos.y, pos.z, backpack, 0.0, 0.0, 0.0);
        level.addFreshEntity((Entity)itemEntity);
    }

    private record DynamicTemplate(ItemStack backpack, List<ItemStack> itemsForInventoryHandler, List<ItemStack> itemsForUpgradeHandler) {
    }
}

