/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IItemResourceHandlerInteractionUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class DepositUpgradeWrapper
extends UpgradeWrapperBase<DepositUpgradeWrapper, DepositUpgradeItem>
implements IFilteredUpgrade,
IItemResourceHandlerInteractionUpgrade {
    private final DepositFilterLogic filterLogic;

    public DepositUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new DepositFilterLogic(upgrade, upgradeSaveHandler, ((DepositUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    public DepositFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public void onHandlerInteract(ResourceHandler<ItemResource> handler, Player player) {
        if (this.filterLogic.getDepositFilterType() == DepositFilterType.INVENTORY) {
            this.filterLogic.setInventory(handler);
        }
        AtomicInteger stacksAdded = new AtomicInteger(0);
        try (Transaction tx = Transaction.openRoot();){
            FilteredItemHandler filteredTarget = new FilteredItemHandler(handler, Collections.singletonList(this.filterLogic), Collections.emptyList());
            InventoryHelper.iterate((ResourceHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), (index, resource, amount) -> {
                if (resource.isEmpty()) {
                    return;
                }
                int moved = filteredTarget.insert(resource, amount.intValue(), (TransactionContext)tx);
                if (moved > 0) {
                    this.storageWrapper.getInventoryForUpgradeProcessing().extract(index.intValue(), (Resource)resource, moved, (TransactionContext)tx);
                    stacksAdded.incrementAndGet();
                }
            });
            tx.commit();
        }
        int stacksDeposited = stacksAdded.get();
        String translKey = stacksDeposited > 0 ? "gui.sophisticatedbackpacks.status.stacks_deposited" : "gui.sophisticatedbackpacks.status.nothing_to_deposit";
        player.displayClientMessage((Component)Component.translatable((String)translKey, (Object[])new Object[]{stacksDeposited}), true);
    }
}

