/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IItemResourceHandlerInteractionUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock.RestockUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class RestockUpgradeWrapper
extends UpgradeWrapperBase<RestockUpgradeWrapper, RestockUpgradeItem>
implements IContentsFilteredUpgrade,
IItemResourceHandlerInteractionUpgrade {
    private final ContentsFilterLogic filterLogic;

    public RestockUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((RestockUpgradeItem)this.upgradeItem).getFilterSlotCount(), () -> ((IStorageWrapper)backpackWrapper).getInventoryHandler(), (MemorySettingsCategory)backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public void onHandlerInteract(ResourceHandler<ItemResource> handler, Player player) {
        AtomicInteger stacksAdded = new AtomicInteger(0);
        try (Transaction tx = Transaction.openRoot();){
            FilteredItemHandler filteredTarget = new FilteredItemHandler((ResourceHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), Collections.singletonList(this.filterLogic), Collections.emptyList());
            InventoryHelper.iterate(handler, (index, resource, amount) -> {
                int moved = filteredTarget.insert(resource, amount.intValue(), (TransactionContext)tx);
                if (moved > 0) {
                    handler.extract(index.intValue(), (Resource)resource, moved, (TransactionContext)tx);
                    stacksAdded.incrementAndGet();
                }
            });
            if (stacksAdded.get() > 0) {
                tx.commit();
            }
        }
        int stacksRestocked = stacksAdded.get();
        String translKey = stacksRestocked > 0 ? "gui.sophisticatedbackpacks.status.stacks_restocked" : "gui.sophisticatedbackpacks.status.nothing_to_restock";
        player.displayClientMessage((Component)Component.translatable((String)translKey, (Object[])new Object[]{stacksRestocked}), true);
    }
}

