/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.AccessLogRecord;

public class BackpackStorage
extends SavedData {
    private static final SavedDataType<BackpackStorage> TYPE = new SavedDataType("sophisticatedbackpacks", BackpackStorage::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), (Codec)CompoundTag.CODEC).fieldOf("backpackContents").forGetter(storage -> storage.backpackContents), (App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), AccessLogRecord.CODEC).fieldOf("accessLogRecords").forGetter(storage -> storage.accessLogRecords)).apply((Applicative)builder, BackpackStorage::new)));
    private final Map<UUID, CompoundTag> backpackContents = new HashMap<UUID, CompoundTag>();
    private static final BackpackStorage clientStorageCopy = new BackpackStorage();
    private final Map<UUID, AccessLogRecord> accessLogRecords = new HashMap<UUID, AccessLogRecord>();
    private final Set<UUID> updatedBackpackSettingsFlags = new HashSet<UUID>();

    private BackpackStorage(Map<UUID, CompoundTag> backpackContents, Map<UUID, AccessLogRecord> accessLogRecords) {
        this.accessLogRecords.putAll(accessLogRecords);
        backpackContents.forEach((uuid, contents) -> {
            if (BackpackStorage.isPlayerBackpackOrNotEmpty(this, uuid, contents)) {
                this.backpackContents.put((UUID)uuid, (CompoundTag)contents);
            }
        });
    }

    private BackpackStorage() {
    }

    public static BackpackStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (BackpackStorage)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    private static boolean isPlayerBackpackOrNotEmpty(BackpackStorage storage, UUID backpackUuid, CompoundTag contentsNbt) {
        if (storage.accessLogRecords.containsKey(backpackUuid)) {
            return true;
        }
        if (contentsNbt.contains("inventory")) {
            return contentsNbt.getCompound("inventory").map(inventoryNbt -> {
                if (inventoryNbt.contains("Items")) {
                    return inventoryNbt.getList("Items").isPresent();
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public CompoundTag getOrCreateBackpackContents(UUID backpackUuid) {
        return this.backpackContents.computeIfAbsent(backpackUuid, uuid -> {
            this.setDirty();
            return new CompoundTag();
        });
    }

    public void putAccessLog(AccessLogRecord alr) {
        this.accessLogRecords.put(alr.backpackUuid(), alr);
        this.setDirty();
    }

    public void removeBackpackContents(UUID backpackUuid) {
        this.backpackContents.remove(backpackUuid);
        this.setDirty();
    }

    public void setBackpackContents(UUID backpackUuid, CompoundTag contents) {
        if (!this.backpackContents.containsKey(backpackUuid)) {
            this.backpackContents.put(backpackUuid, contents);
            this.updatedBackpackSettingsFlags.add(backpackUuid);
        } else {
            CompoundTag currentContents = this.backpackContents.get(backpackUuid);
            for (String key : contents.keySet()) {
                currentContents.put(key, contents.get(key));
                if (!key.equals("settings")) continue;
                this.updatedBackpackSettingsFlags.add(backpackUuid);
            }
            this.setDirty();
        }
    }

    public Map<UUID, AccessLogRecord> getAccessLogs() {
        return this.accessLogRecords;
    }

    public int removeNonPlayerBackpackContents(boolean onlyWithEmptyInventory) {
        AtomicInteger numberRemoved = new AtomicInteger(0);
        this.backpackContents.entrySet().removeIf(entry -> {
            if (!(this.accessLogRecords.containsKey(entry.getKey()) || onlyWithEmptyInventory && ((CompoundTag)entry.getValue()).contains("inventory"))) {
                numberRemoved.incrementAndGet();
                return true;
            }
            return false;
        });
        if (numberRemoved.get() > 0) {
            this.setDirty();
        }
        return numberRemoved.get();
    }

    public boolean removeUpdatedBackpackSettingsFlag(UUID backpackUuid) {
        return this.updatedBackpackSettingsFlags.remove(backpackUuid);
    }

    public static void onClientWorldLoad(LevelEvent.Load evt) {
        if (evt.getLevel().isClientSide()) {
            BackpackStorage.clientStorageCopy.backpackContents.clear();
            BackpackStorage.clientStorageCopy.accessLogRecords.clear();
        }
    }
}

