package com.jowhjy.hidecoords;

import com.jowhjy.hidecoords.command.CoordoffsetCommand;
import com.jowhjy.hidecoords.mixin.ServerChunkLoadingManagerAccessor;
import com.jowhjy.hidecoords.mixin.ServerWaypointHandlerInvoker;
import com.jowhjy.hidecoords.mixin.ServerWorldAccessor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_11179;
import net.minecraft.class_1928;
import net.minecraft.class_2632;
import net.minecraft.class_2724;
import net.minecraft.class_2748;
import net.minecraft.class_3222;
import net.minecraft.class_4282;
import net.minecraft.class_5217;
import net.minecraft.network.packet.s2c.play.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hidecoords implements ModInitializer {


    public static final String MOD_ID = "hidecoords";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_1928.class_4313<class_1928.class_4310> HIDECOORDS_GAMERULE =
            GameRuleRegistry.register("hideCoordinates", class_1928.class_5198.field_24094, GameRuleFactory.createBooleanRule(true));

    @Override
    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> CoordoffsetCommand.register(dispatcher, registryAccess));
    }

    //credit to Patbox (Polymer) for parts of this method!
    public static void resendDataAfterOffsetChange(class_3222 player) {

        var world = player.method_51469();
        var chunksLoadingManagerAccess = ((ServerChunkLoadingManagerAccessor) player.method_51469().method_14178().field_17254);

        try {
            for (var e : ((ServerWorldAccessor) player.method_51469()).hidecoords$getEntityManager().method_31841().method_31803()) {
                var tracker = chunksLoadingManagerAccess.hidecoords$getEntityTrackers().get(e.method_5628());
                if (tracker != null) {
                    tracker.method_18736(player);
                }
            }
        }
        catch (Throwable throwable) {
            Hidecoords.LOGGER.warn("Failed to reload entities", throwable);
        }

        if (player.method_5682() == null) return;
        var playerManager = player.method_5682().method_3760();
        //some code from respawnPlayer is reused here
        class_5217 worldProperties = world.method_8401();
        player.field_13987.method_14364(new class_2724(player.method_52374(world), class_2724.field_41732));
        player.field_13987
                .method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        player.field_13987.method_14364(new class_2632(worldProperties.method_207(), worldProperties.method_197()));
        player.field_13987
                .method_14364(new class_2748(player.field_7510, player.field_7495, player.field_7520));
        playerManager.method_60598(player);
        playerManager.method_14606(player, world);
        playerManager.method_14576(player);
        player.method_34225();
        player.method_6033(player.method_6032());

        player.field_13987.method_14364(new class_4282(player.method_31476().field_9181, player.method_31476().field_9180));

        player.method_52372().method_52363((chunkPos) -> {
            var chunk = world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            player.field_13987.field_45026.method_52387(player, chunk.method_12004());
            player.field_13987.field_45026.method_52390(chunk);
        });

        //waypoints?
        class_11179 waypointHandler = player.method_51469().method_70636();
        waypointHandler.method_70647().forEach(waypoint -> ((ServerWaypointHandlerInvoker)waypointHandler).invokeRefreshTracking(player, waypoint));
    }



}
